/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.model.SystemLibraryApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.ui.internal.ApiToolsLabelProvider;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.wizards.ApiBaselineWizardPage;
import org.eclipse.pde.api.tools.ui.internal.wizards.WizardMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class DirectoryBasedApiBaselineWizardPage
extends ApiBaselineWizardPage {
    private Text nametext = null;
    private TreeViewer treeviewer = null;
    Combo locationcombo = null;
    private Button browsebutton = null;
    private Button reloadbutton = null;
    private boolean initializing = false;

    public static boolean isApplicable(IApiBaseline profile) {
        String loc = profile.getLocation();
        return loc != null && new Path(loc).toFile().exists();
    }

    protected DirectoryBasedApiBaselineWizardPage(IApiBaseline profile) {
        super(profile);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 4, 1, 768);
        SWTFactory.createWrapLabel(comp, WizardMessages.ApiProfileWizardPage_5, 1);
        this.nametext = SWTFactory.createText(comp, 2052, 3, 769);
        this.nametext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DirectoryBasedApiBaselineWizardPage.this.setPageComplete(DirectoryBasedApiBaselineWizardPage.this.pageValid());
            }
        });
        SWTFactory.createVerticalSpacer(comp, 1);
        SWTFactory.createWrapLabel(comp, WizardMessages.ApiProfileWizardPage_9, 1);
        this.locationcombo = SWTFactory.createCombo(comp, 2052, 1, 769, null);
        this.locationcombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DirectoryBasedApiBaselineWizardPage.this.setPageComplete(DirectoryBasedApiBaselineWizardPage.this.pageValid());
                DirectoryBasedApiBaselineWizardPage.this.updateButtons();
            }
        });
        this.browsebutton = SWTFactory.createPushButton(comp, WizardMessages.ApiProfileWizardPage_10, null);
        this.browsebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newPath;
                DirectoryDialog dialog = new DirectoryDialog(DirectoryBasedApiBaselineWizardPage.this.getShell());
                dialog.setMessage(WizardMessages.ApiProfileWizardPage_11);
                String loctext = DirectoryBasedApiBaselineWizardPage.this.locationcombo.getText().trim();
                if (loctext.length() > 0) {
                    dialog.setFilterPath(loctext);
                }
                if (!((newPath = dialog.open()) == null || new Path(loctext).equals((Object)new Path(newPath)) && DirectoryBasedApiBaselineWizardPage.this.getCurrentComponents().length != 0)) {
                    DirectoryBasedApiBaselineWizardPage.this.locationcombo.setText(newPath);
                    DirectoryBasedApiBaselineWizardPage.this.setErrorMessage(null);
                    DirectoryBasedApiBaselineWizardPage.this.doReload();
                }
            }
        });
        this.reloadbutton = SWTFactory.createPushButton(comp, WizardMessages.ApiProfileWizardPage_12, null);
        this.reloadbutton.setEnabled(this.locationcombo.getText().trim().length() > 0);
        this.reloadbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryBasedApiBaselineWizardPage.this.doReload();
            }
        });
        SWTFactory.createWrapLabel(comp, WizardMessages.ApiProfileWizardPage_13, 4);
        Tree tree = new Tree(comp, 67586);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.horizontalSpan = 4;
        tree.setLayoutData((Object)gd);
        this.treeviewer = new TreeViewer(tree);
        this.treeviewer.setLabelProvider((IBaseLabelProvider)new ApiToolsLabelProvider());
        this.treeviewer.setContentProvider((IContentProvider)new ApiBaselineWizardPage.ContentProvider());
        this.treeviewer.setComparator(new ViewerComparator());
        this.treeviewer.setInput((Object)this.getCurrentComponents());
        this.treeviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DirectoryBasedApiBaselineWizardPage.this.updateButtons();
            }
        });
        this.treeviewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IApiComponent) {
                    IApiComponent component = (IApiComponent)element;
                    try {
                        if (component.isSourceComponent() || component.isSystemComponent()) {
                            return false;
                        }
                    }
                    catch (CoreException e) {
                        ApiPlugin.log((Throwable)e);
                    }
                    return true;
                }
                return !(element instanceof SystemLibraryApiComponent);
            }
        });
        this.setControl((Control)comp);
        this.setPageComplete(this.fProfile != null);
        this.initialize();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, IApiToolsHelpContextIds.APIPROFILES_WIZARD_PAGE);
        Dialog.applyDialogFont((Control)comp);
    }

    @Override
    protected void initialize() {
        this.initializing = true;
        try {
            super.initialize();
            if (this.fProfile != null) {
                this.nametext.setText(this.fProfile.getName());
                IApiComponent[] components = this.fProfile.getApiComponents();
                HashSet<String> locations = new HashSet<String>();
                String loc = this.fProfile.getLocation();
                Path location = null;
                if (loc != null) {
                    location = new Path(loc);
                    if (location.toFile().isDirectory()) {
                        locations.add(location.removeTrailingSeparator().toOSString());
                    }
                } else {
                    int i = 0;
                    while (i < components.length) {
                        if (!components[i].isSystemComponent() && (location = new Path(components[i].getLocation()).removeLastSegments(1)).toFile().isDirectory()) {
                            locations.add(location.removeTrailingSeparator().toOSString());
                        }
                        ++i;
                    }
                }
                if (locations.size() > 0) {
                    this.locationcombo.setItems(locations.toArray(new String[locations.size()]));
                    this.locationcombo.select(0);
                }
            } else {
                URL url;
                IPath path;
                Location location = Platform.getInstallLocation();
                if (location != null && (path = new Path((url = location.getURL()).getFile()).removeTrailingSeparator()).toFile().exists()) {
                    this.locationcombo.add(path.toOSString());
                    this.locationcombo.select(0);
                }
            }
        }
        finally {
            this.initializing = false;
        }
    }

    protected void doReload() {
        ReloadOperation op = new ReloadOperation(this.nametext.getText().trim(), this.locationcombo.getText().trim());
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
            this.treeviewer.setInput((Object)this.getCurrentComponents());
            this.treeviewer.refresh();
            this.setPageComplete(this.pageValid());
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public IApiBaseline finish() throws IOException, CoreException {
        if (this.fProfile != null) {
            this.fProfile.setName(this.nametext.getText().trim());
        }
        return this.fProfile;
    }

    protected boolean pageValid() {
        if (this.initializing) {
            return false;
        }
        this.setErrorMessage(null);
        if (!this.isNameValid(this.nametext.getText().trim())) {
            return false;
        }
        String text = this.locationcombo.getText().trim();
        if (text.length() < 1) {
            this.setErrorMessage(WizardMessages.ApiProfileWizardPage_23);
            this.reloadbutton.setEnabled(false);
            return false;
        }
        if (!new Path(text).toFile().exists()) {
            this.setErrorMessage(WizardMessages.ApiProfileWizardPage_24);
            this.reloadbutton.setEnabled(false);
            return false;
        }
        if (this.fProfile != null) {
            if (this.fProfile.getApiComponents().length == 0) {
                this.setErrorMessage(WizardMessages.ApiProfileWizardPage_2);
                return false;
            }
            IStatus status = this.fProfile.getExecutionEnvironmentStatus();
            if (status.getSeverity() == 4) {
                this.setErrorMessage(status.getMessage());
                return false;
            }
            if (this.fProfile.getLocation() != null && !this.fProfile.getLocation().equals(this.locationcombo.getText())) {
                this.setErrorMessage(WizardMessages.ApiProfileWizardPage_location_needs_reset);
                return false;
            }
        } else {
            this.setErrorMessage(WizardMessages.ApiProfileWizardPage_location_needs_reset);
            return false;
        }
        return true;
    }

    protected void updateButtons() {
        String loctext = this.locationcombo.getText().trim();
        this.reloadbutton.setEnabled(loctext.length() > 0);
    }

    class ReloadOperation
    implements IRunnableWithProgress {
        private String location;
        private String name;

        public ReloadOperation(String name, String location) {
            this.location = location;
            this.name = name;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(WizardMessages.ApiProfileWizardPage_0, 10);
            try {
                try {
                    DirectoryBasedApiBaselineWizardPage.this.fProfile = ApiModelFactory.newApiBaseline((String)this.name, (String)this.location);
                    ApiModelFactory.addComponents((IApiBaseline)DirectoryBasedApiBaselineWizardPage.this.fProfile, (String)this.location, (IProgressMonitor)monitor);
                    DirectoryBasedApiBaselineWizardPage.this.contentchange = true;
                }
                catch (CoreException e) {
                    ApiPlugin.log((Throwable)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

