/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.customizer;

import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.error.HttpWhiteboardFailureException;
import org.eclipse.equinox.http.servlet.internal.registration.ServletRegistration;
import org.eclipse.equinox.http.servlet.internal.util.BooleanPlus;
import org.eclipse.equinox.http.servlet.internal.util.ServiceProperties;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.runtime.dto.FailedServletDTO;

public class ContextServletTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<Servlet, AtomicReference<ServletRegistration>> {
    private ContextController contextController;

    public ContextServletTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime);
        this.contextController = contextController;
    }

    public AtomicReference<ServletRegistration> addingService(ServiceReference<Servlet> serviceReference) {
        AtomicReference<ServletRegistration> result = new AtomicReference<ServletRegistration>();
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return result;
        }
        if (!this.contextController.matches(serviceReference)) {
            return result;
        }
        try {
            result.set(this.contextController.addServletRegistration(serviceReference));
        }
        catch (HttpWhiteboardFailureException hwfe) {
            this.httpServiceRuntime.log(hwfe.getMessage(), hwfe);
            this.recordFailedServletDTO(serviceReference, hwfe.getFailureReason());
        }
        catch (Exception e) {
            this.httpServiceRuntime.log(e.getMessage(), e);
            this.recordFailedServletDTO(serviceReference, 4);
        }
        return result;
    }

    public void modifiedService(ServiceReference<Servlet> serviceReference, AtomicReference<ServletRegistration> servletReference) {
        this.removedService(serviceReference, servletReference);
        Object added = this.addingService((ServiceReference)serviceReference);
        servletReference.set((ServletRegistration)((AtomicReference)added).get());
    }

    public void removedService(ServiceReference<Servlet> serviceReference, AtomicReference<ServletRegistration> servletReference) {
        ServletRegistration registration = servletReference.get();
        if (registration != null) {
            registration.destroy();
        }
        this.contextController.getHttpServiceRuntime().removeFailedServletDTOs(serviceReference);
    }

    private void recordFailedServletDTO(ServiceReference<Servlet> serviceReference, int failureReason) {
        FailedServletDTO failedServletDTO = new FailedServletDTO();
        failedServletDTO.asyncSupported = BooleanPlus.from(serviceReference.getProperty("osgi.http.whiteboard.servlet.asyncSupported"), false);
        failedServletDTO.failureReason = failureReason;
        failedServletDTO.initParams = ServiceProperties.parseInitParams(serviceReference, "servlet.init.");
        failedServletDTO.name = (String)serviceReference.getProperty("osgi.http.whiteboard.servlet.name");
        failedServletDTO.patterns = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.servlet.pattern")).toArray(new String[0]);
        failedServletDTO.serviceId = (Long)serviceReference.getProperty("service.id");
        failedServletDTO.servletContextId = this.contextController.getServiceId();
        failedServletDTO.servletInfo = "";
        this.contextController.getHttpServiceRuntime().recordFailedServletDTO(serviceReference, failedServletDTO);
    }
}

