/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;

public class JobsManager {
    private Set<Job> asyncJobs = new HashSet<Job>();
    private Set<Job> toNullifyTime = new HashSet<Job>();
    private static JobsManager instance = null;
    private static List<InternalJob> cancelled = new ArrayList<InternalJob>();
    private static Map<InternalJob, Long> timeouts = new HashMap<InternalJob, Long>();

    public synchronized void notifyJobDone(Job job, IStatus status, boolean notify) {
        if (status.equals(Job.ASYNC_FINISH)) {
            this.asyncJobs.add(job);
        } else {
            this.asyncJobs.remove(job);
        }
        timeouts.remove(job);
    }

    public synchronized boolean isFinishedAsyncJob(Job job) {
        return this.asyncJobs.contains(job);
    }

    public static synchronized JobsManager getInstance() {
        if (instance == null) {
            instance = new JobsManager();
        }
        return instance;
    }

    public synchronized long calculateNewTime(InternalJob job, long time) {
        if (this.toNullifyTime.contains(job)) {
            this.toNullifyTime.remove(job);
            return 0L;
        }
        return time;
    }

    public synchronized void putJobTime(InternalJob job, long time) {
        if (time != 0L && time != -1L) {
            long now = System.currentTimeMillis();
            if (time >= now) {
                time -= now;
            }
            timeouts.put(job, time);
        }
    }

    public synchronized void nulifyTime(Job job) {
        this.toNullifyTime.add(job);
        timeouts.remove(job);
    }

    public synchronized void notifyJobCancel(InternalJob job) {
        cancelled.add(job);
        timeouts.remove(job);
    }

    public synchronized void clean() {
        this.toNullifyTime.clear();
        cancelled.clear();
    }

    public synchronized void removeCanceled(Job job) {
        cancelled.remove(job);
    }

    public synchronized boolean isCanceled(Job job) {
        return cancelled.contains(job);
    }

    public synchronized Long getTimeout(Job job) {
        return timeouts.get(job);
    }
}

