/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.cache;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.internal.core.model.ModelInfo;
import org.eclipse.rcptt.internal.core.model.cache.ElementCache;

public class ModelCache {
    public static final int DEFAULT_PROJECT_SIZE = 5;
    public static final int DEFAULT_OPENABLE_SIZE = 100;
    public static final int DEFAULT_CHILDREN_SIZE = 2000;
    protected ModelInfo modelInfo;
    protected ElementCache openableCache;
    protected HashMap projectCache;
    protected Map childrenCache;

    public ModelCache() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        double ratio = maxMemory == Long.MAX_VALUE ? 4.0 : (double)(maxMemory / 64000000L);
        this.projectCache = new HashMap(5);
        this.openableCache = new ElementCache((int)(100.0 * ratio));
        this.childrenCache = new HashMap((int)(2000.0 * ratio));
    }

    public Object getInfo(IQ7Element element) {
        switch (element.getElementType()) {
            case Model: {
                return this.modelInfo;
            }
            case Project: {
                return this.projectCache.get(element);
            }
            case TestCase: 
            case Context: 
            case TestSuite: 
            case Verification: {
                return this.openableCache.get(element);
            }
        }
        return this.childrenCache.get(element);
    }

    public Object peekAtInfo(IQ7Element element) {
        switch (element.getElementType()) {
            case Model: {
                return this.modelInfo;
            }
            case Project: {
                return this.projectCache.get(element);
            }
            case TestCase: 
            case Context: 
            case TestSuite: 
            case Verification: {
                return this.openableCache.peek(element);
            }
        }
        return this.childrenCache.get(element);
    }

    public void putInfo(IQ7Element element, Object info) {
        switch (element.getElementType()) {
            case Model: {
                this.modelInfo = (ModelInfo)info;
                break;
            }
            case Project: {
                this.projectCache.put(element, info);
                break;
            }
            case TestCase: 
            case Context: 
            case TestSuite: 
            case Verification: {
                this.openableCache.put(element, info);
                break;
            }
            default: {
                this.childrenCache.put(element, info);
            }
        }
    }

    public void removeInfo(IQ7Element element) {
        switch (element.getElementType()) {
            case Model: {
                this.modelInfo = null;
                break;
            }
            case Project: {
                this.projectCache.remove(element);
                break;
            }
            case TestCase: 
            case Context: 
            case TestSuite: 
            case Verification: {
                this.openableCache.remove(element);
                break;
            }
            default: {
                this.childrenCache.remove(element);
            }
        }
    }
}

