/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.lib.Repository;

abstract class BaseOperation
implements IEGitOperation {
    protected final Repository repository;
    protected Collection<IEGitOperation.PreExecuteTask> preTasks;
    protected Collection<IEGitOperation.PostExecuteTask> postTasks;

    BaseOperation(Repository repository) {
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preExecute(IProgressMonitor monitor) throws CoreException {
        BaseOperation baseOperation = this;
        synchronized (baseOperation) {
            if (this.preTasks != null) {
                for (IEGitOperation.PreExecuteTask task : this.preTasks) {
                    task.preExecute(this.repository, monitor);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postExecute(IProgressMonitor monitor) throws CoreException {
        BaseOperation baseOperation = this;
        synchronized (baseOperation) {
            if (this.postTasks != null) {
                for (IEGitOperation.PostExecuteTask task : this.postTasks) {
                    task.postExecute(this.repository, monitor);
                }
            }
        }
    }

    public synchronized void addPreExecuteTask(IEGitOperation.PreExecuteTask task) {
        if (this.preTasks == null) {
            this.preTasks = new ArrayList<IEGitOperation.PreExecuteTask>();
        }
        this.preTasks.add(task);
    }

    public synchronized void addPostExecuteTask(IEGitOperation.PostExecuteTask task) {
        if (this.postTasks == null) {
            this.postTasks = new ArrayList<IEGitOperation.PostExecuteTask>();
        }
        this.postTasks.add(task);
    }
}

