/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchManager;
import org.eclipse.help.internal.search.SearchProgressMonitor;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResults;
import org.eclipse.help.internal.util.ProductPreferences;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.data.ActivitiesData;
import org.eclipse.help.internal.webapp.data.RequestScope;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.TocData;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.WebappWorkingSetManager;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableSelectedToc;
import org.eclipse.help.internal.workingset.AdaptableSelectedTopic;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.AdaptableTopic;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.search.AbstractSearchProcessor;
import org.eclipse.help.search.ISearchEngineResult;
import org.eclipse.help.search.ISearchResult;
import org.eclipse.help.search.SearchProcessorInfo;
import org.eclipse.osgi.util.NLS;

public class SearchData
extends ActivitiesData {
    private static final String SHOW_CATEGORIES = "showSearchCategories";
    private WebappWorkingSetManager wsmgr;
    private String topicHref;
    private String selectedTopicId = "";
    private String searchWord;
    private String workingSetName;
    SearchHit[] hits;
    private int indexCompletion = 100;
    private QueryTooComplexException queryException = null;
    private List<String> altList = new ArrayList<String>();
    private boolean showCategories = false;

    public SearchData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.wsmgr = new WebappWorkingSetManager(request, response, this.getLocale());
        this.topicHref = request.getParameter("topic");
        if (this.topicHref != null && this.topicHref.length() == 0) {
            this.topicHref = null;
        }
        this.searchWord = request.getParameter("searchWord");
        this.readDisplayFlags(request, response);
        if (this.isScopeRequest()) {
            this.workingSetName = request.getParameter("workingSet");
            if (this.canSaveScope()) {
                this.saveWorkingSet(this.workingSetName);
            }
        }
        this.readSearchResults();
    }

    protected boolean canSaveScope() {
        return false;
    }

    private void readDisplayFlags(HttpServletRequest request, HttpServletResponse response) {
        String showCategoriesParam = request.getParameter(SHOW_CATEGORIES);
        if (showCategoriesParam != null) {
            this.showCategories = "true".equalsIgnoreCase(showCategoriesParam);
            RequestScope.setFlag(request, response, SHOW_CATEGORIES, this.showCategories);
        } else {
            this.showCategories = RequestScope.getFlag(request, SHOW_CATEGORIES);
        }
    }

    public void readSearchResults() {
        if (this.isSearchRequest() && !this.isScopeRequest()) {
            AbstractSearchProcessor[] processors;
            this.altList.clear();
            AbstractSearchProcessor[] abstractSearchProcessorArray = processors = SearchManager.getSearchProcessors();
            int n = processors.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractSearchProcessor processor = abstractSearchProcessorArray[n2];
                SearchProcessorInfo result = processor.preSearch(this.searchWord);
                if (result != null) {
                    String query;
                    String[] alternates = result.getAlternateTerms();
                    if (alternates != null) {
                        String[] stringArray = alternates;
                        int n3 = alternates.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String alternate = stringArray[n4];
                            String div = "<div><a target=\"_self\" href=\"./searchView.jsp?searchWord=" + alternate + "\">" + alternate + "</a></div>";
                            if (!this.altList.contains(div)) {
                                this.altList.add(div);
                            }
                            ++n4;
                        }
                    }
                    if ((query = result.getQuery()) != null) {
                        this.searchWord = query;
                    }
                }
                ++n2;
            }
            Collections.sort(this.altList);
            this.loadSearchResults();
            if (this.queryException != null) {
                return;
            }
            if (!this.isProgressRequest()) {
                int i = 0;
                while (i < this.hits.length) {
                    if (this.hits[i].getHref().equals(this.topicHref)) {
                        this.selectedTopicId = "a" + i;
                        break;
                    }
                    ++i;
                }
                ISearchResult[] results = SearchManager.convertHitsToResults((SearchHit[])this.hits);
                boolean reset = false;
                AbstractSearchProcessor[] abstractSearchProcessorArray2 = processors;
                int n5 = processors.length;
                int n6 = 0;
                while (n6 < n5) {
                    AbstractSearchProcessor processor = abstractSearchProcessorArray2[n6];
                    ISearchResult[] tmp = processor.postSearch(this.searchWord, results);
                    if (tmp != null) {
                        reset = true;
                        results = tmp;
                    }
                    ++n6;
                }
                if (reset) {
                    this.hits = SearchManager.convertResultsToHits((ISearchResult[])results);
                }
                if (this.isShowCategories()) {
                    SearchData.primallySortByCategory((ISearchEngineResult[])this.hits);
                }
            }
        }
    }

    public boolean isSearchRequest() {
        String searchWordParam = this.request.getParameter("searchWord");
        return searchWordParam != null && searchWordParam.length() > 0;
    }

    public boolean isProgressRequest() {
        return this.hits == null && this.indexCompletion != 100;
    }

    public boolean isScopeRequest() {
        return this.request.getParameter("workingSet") != null;
    }

    protected boolean isQuickSearch() {
        return this.request.getParameterValues("quickSearch") != null;
    }

    public boolean isSelectedTopicQuickSearchRequest() {
        String quickSearchType = this.request.getParameter("quickSearchType");
        return quickSearchType != null && "QuickSearchTopic".equalsIgnoreCase(quickSearchType);
    }

    public String getCategoryLabel(int i) {
        IHelpResource cat = this.hits[i].getCategory();
        if (cat != null) {
            return cat.getLabel();
        }
        return null;
    }

    public String getCategoryHref(int i) {
        IHelpResource cat = this.hits[i].getCategory();
        if (cat != null) {
            String tocHref = cat.getHref();
            IToc[] tocs = HelpSystem.getTocs();
            int j = 0;
            while (j < tocs.length) {
                if (tocHref.equals(tocs[j].getHref())) {
                    ITopic topic = tocs[j].getTopic(null);
                    String topicHref = topic.getHref();
                    if (topicHref != null) {
                        return UrlUtil.getHelpURL(topicHref);
                    }
                    return "../nav/" + j;
                }
                ++j;
            }
        }
        return null;
    }

    public int getResultsCount() {
        return this.hits.length;
    }

    public SearchHit[] getResults() {
        return this.hits;
    }

    public String getSelectedTopicId() {
        return this.selectedTopicId;
    }

    public String getTopicHref(int i) {
        return UrlUtil.getHelpURL(this.hits[i].getHref());
    }

    public String getTopicLabel(int i) {
        return UrlUtil.htmlEncode(this.hits[i].getLabel());
    }

    public String getTopicTocLabel(int i) {
        if (this.hits[i].getToc() != null) {
            return UrlUtil.htmlEncode(this.hits[i].getToc().getLabel());
        }
        return "";
    }

    public String getTopicDescription(int i) {
        String description = this.hits[i].getDescription();
        if (description != null) {
            return UrlUtil.htmlEncode(description);
        }
        return "";
    }

    public boolean isEnabled(int i) {
        String href = this.hits[i].getHref();
        return HelpBasePlugin.getActivitySupport().isEnabledTopic(href, this.getLocale());
    }

    public boolean isPotentialHit(int i) {
        return this.getMode() != 1 && this.hits[i].isPotentialHit();
    }

    public boolean isShowCategories() {
        return this.showCategories;
    }

    public boolean isShowDescriptions() {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if ("showDescriptions".equals(cookie.getName())) {
                    return String.valueOf(true).equals(cookie.getValue());
                }
                ++n2;
            }
        }
        return Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "showSearchDescription", true, null);
    }

    public String getIndexedPercentage() {
        return String.valueOf(this.indexCompletion);
    }

    public String getSearchWord() {
        if (this.searchWord == null) {
            return "";
        }
        return this.searchWord;
    }

    public String[] getSelectedTocs() {
        String[] books = this.request.getParameterValues("scope");
        if (books == null) {
            TocData tocData = new TocData(this.context, this.request, this.response);
            books = new String[tocData.getTocCount()];
            int i = 0;
            while (i < books.length) {
                books[i] = tocData.getTocHref(i);
                ++i;
            }
        }
        return books;
    }

    public boolean isTocSelected(int toc) {
        TocData tocData = new TocData(this.context, this.request, this.response);
        String href = tocData.getTocHref(toc);
        String[] books = this.request.getParameterValues("scope");
        if (books == null) {
            return false;
        }
        String[] stringArray = books;
        int n = books.length;
        int n2 = 0;
        while (n2 < n) {
            String book = stringArray[n2];
            if (book.equals(href)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getScope() {
        if (this.workingSetName != null && this.workingSetName.length() != 0) {
            return this.workingSetName;
        }
        if (this.isSearchRequest()) {
            this.workingSetName = this.request.getParameter("scope");
            if (this.workingSetName == null) {
                this.workingSetName = this.request.getParameter("workingSet");
            }
        } else {
            this.workingSetName = this.wsmgr.getCurrentWorkingSet();
        }
        if (this.workingSetName == null || this.workingSetName.length() == 0 || this.getMode() == 1 && this.wsmgr.getWorkingSet(this.workingSetName) == null) {
            this.workingSetName = ServletResources.getString("All", this.request);
        }
        return this.workingSetName;
    }

    private void saveWorkingSet(String workingSet) {
        String lastWS = this.wsmgr.getCurrentWorkingSet();
        if (workingSet != null && !workingSet.equals(lastWS)) {
            this.wsmgr.setCurrentWorkingSet(workingSet);
        } else if (workingSet == null && lastWS != null && lastWS.length() > 0) {
            this.wsmgr.setCurrentWorkingSet("");
        }
    }

    private void loadSearchResults() {
        try {
            SearchProgressMonitor pm = SearchProgressMonitor.getProgressMonitor((String)this.getLocale());
            if (pm.isDone()) {
                this.indexCompletion = 100;
                SearchResults results = this.createHitCollector();
                BaseHelpSystem.getSearchManager().search(this.createSearchQuery(), (ISearchHitCollector)results, (IProgressMonitor)pm);
                this.hits = results.getSearchHits();
                if (this.hits == null) {
                    HelpWebappPlugin.logWarning("No search results returned.  Help index is in use.");
                }
                return;
            }
            this.indexCompletion = pm.getPercentage();
            if (this.indexCompletion >= 100) {
                this.indexCompletion = 99;
            }
            return;
        }
        catch (QueryTooComplexException qe) {
            this.queryException = qe;
        }
        catch (Exception exception) {
            this.indexCompletion = 0;
        }
    }

    private ISearchQuery createSearchQuery() {
        String fieldSearchStr = this.request.getParameter("fieldSearch");
        boolean fieldSearch = fieldSearchStr != null ? new Boolean(fieldSearchStr) : false;
        return new SearchQuery(this.searchWord == null ? "" : this.searchWord, fieldSearch, new ArrayList(), this.getLocale());
    }

    private SearchResults createHitCollector() {
        WorkingSet[] workingSets;
        boolean isSearchSelectedAndChildren = false;
        if (this.request.getParameterValues("scopedSearch") != null) {
            workingSets = this.createTempWorkingSets();
        } else if (this.isQuickSearch()) {
            if (this.isSelectedTopicQuickSearchRequest()) {
                workingSets = this.createQuickSearchWorkingSetOnSelectedTopic();
            } else {
                workingSets = this.createQuickSearchWorkingSet();
                isSearchSelectedAndChildren = true;
            }
        } else {
            workingSets = this.getWorkingSets();
        }
        AbstractHelpScope filter = RequestScope.getScope(this.request, this.response, !isSearchSelectedAndChildren);
        int maxHits = 500;
        String maxHitsStr = this.request.getParameter("maxHits");
        if (maxHitsStr != null) {
            try {
                int clientmaxHits = Integer.parseInt(maxHitsStr);
                if (clientmaxHits > 0 && clientmaxHits < 500) {
                    maxHits = clientmaxHits;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new SearchResultFilter(workingSets, maxHits, this.getLocale(), filter, this.isQuickSearch());
    }

    private WorkingSet[] getWorkingSets() {
        String[] scopes = this.request.getParameterValues("scope");
        if (scopes == null) {
            return null;
        }
        ArrayList<WorkingSet> workingSetCol = new ArrayList<WorkingSet>(scopes.length);
        String[] stringArray = scopes;
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            String scope = stringArray[n2];
            WorkingSet ws = this.wsmgr.getWorkingSet(scope);
            if (ws != null) {
                workingSetCol.add(ws);
            }
            ++n2;
        }
        if (workingSetCol.size() == 0) {
            return null;
        }
        return workingSetCol.toArray(new WorkingSet[workingSetCol.size()]);
    }

    private WorkingSet[] createTempWorkingSets() {
        String[] scopes = this.request.getParameterValues("scope");
        if (scopes == null) {
            return new WorkingSet[0];
        }
        if (scopes.length == HelpPlugin.getTocManager().getTocs(this.getLocale()).length) {
            return null;
        }
        ArrayList<AdaptableToc> tocs = new ArrayList<AdaptableToc>(scopes.length);
        String[] stringArray = scopes;
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            String scope = stringArray[n2];
            AdaptableToc toc = this.wsmgr.getAdaptableToc(scope);
            if (toc != null) {
                tocs.add(toc);
            }
            ++n2;
        }
        AdaptableToc[] adaptableTocs = tocs.toArray(new AdaptableToc[tocs.size()]);
        WorkingSet[] workingSets = new WorkingSet[]{this.wsmgr.createWorkingSet("temp", (AdaptableHelpResource[])adaptableTocs)};
        return workingSets;
    }

    private WorkingSet[] createQuickSearchWorkingSet() {
        WorkingSet[] workingSets = new WorkingSet[1];
        TocData tocData = new TocData(this.context, this.request, this.response);
        int selectedToc = tocData.getSelectedToc();
        if (selectedToc < 0) {
            return new WorkingSet[0];
        }
        IToc toc = tocData.getTocs()[selectedToc];
        ITopic[] topics = tocData.getTopicPathFromRootPath(toc);
        ArrayList<Object> resources = new ArrayList<Object>();
        AdaptableToc adaptableToc = new AdaptableToc(toc);
        if (topics != null) {
            ITopic selectedTopic = topics[topics.length - 1];
            AdaptableTopic adaptableTopic = new AdaptableTopic(selectedTopic);
            resources.add(adaptableTopic);
            adaptableTopic.setParent((IAdaptable)adaptableToc);
        } else {
            resources.add(adaptableToc);
        }
        workingSets[0] = new WorkingSet("quickSearch", resources);
        return workingSets;
    }

    private WorkingSet[] createQuickSearchWorkingSetOnSelectedTopic() {
        WorkingSet[] workingSets = new WorkingSet[1];
        TocData tocData = new TocData(this.context, this.request, this.response);
        int selectedToc = tocData.getSelectedToc();
        if (selectedToc < 0) {
            return new WorkingSet[0];
        }
        IToc toc = tocData.getTocs()[selectedToc];
        ITopic[] topics = tocData.getTopicPathFromRootPath(toc);
        ArrayList<Object> resources = new ArrayList<Object>();
        AdaptableSelectedToc adaptableSelectedToc = new AdaptableSelectedToc(toc);
        if (topics != null) {
            ITopic selectedTopic = topics[topics.length - 1];
            AdaptableSelectedTopic adaptableSelectedTopic = new AdaptableSelectedTopic(selectedTopic);
            resources.add(adaptableSelectedTopic);
            adaptableSelectedTopic.setParent((IAdaptable)adaptableSelectedToc);
        } else {
            resources.add(adaptableSelectedToc);
        }
        workingSets[0] = new WorkingSet("quickSearch", resources);
        return workingSets;
    }

    public String getQueryExceptionMessage() {
        if (this.queryException == null) {
            return null;
        }
        return ServletResources.getString("searchTooComplex", this.request);
    }

    public boolean isScopeActive() {
        return !this.getScope().equals(ServletResources.getString("All", this.request));
    }

    public String getNotFoundMessage() {
        String scope = this.getScope();
        if (scope.equals(ServletResources.getString("All", this.request))) {
            return ServletResources.getString("Nothing_found", this.request);
        }
        return NLS.bind((String)ServletResources.getString("Nothing_found_in_scope", this.request), (Object)scope);
    }

    public String getScopeActiveMessage() {
        String scope = this.getScope();
        return NLS.bind((String)ServletResources.getString("activeScope", this.request), (Object)scope);
    }

    public String getMatchesInScopeMessage() {
        String scope = this.getScope();
        return NLS.bind((String)ServletResources.getString("matchesInScope", this.request), (Object)("" + this.getResultsCount()), (Object)scope);
    }

    public String getPreProcessorResults() {
        if (this.altList == null || this.altList.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        result.append(ServletResources.getString("AlternateSearchQueries", this.request));
        result.append("<ul>");
        int a = 0;
        while (a < this.altList.size()) {
            result.append("<li>" + this.altList.get(a) + "</li>");
            ++a;
        }
        result.append("</ul>");
        return result.toString();
    }

    private static void primallySortByCategory(ISearchEngineResult[] toSort) {
        HashMap<String, String> nameIdMap = new HashMap<String, String>();
        ArrayList<String> itemsToOrder = new ArrayList<String>();
        int i = 0;
        while (i < toSort.length) {
            IHelpResource cat = toSort[i].getCategory();
            if (cat != null) {
                String href = cat.getHref();
                String label = cat.getLabel();
                if (href != null && label != null) {
                    nameIdMap.put(href, label);
                    if (!itemsToOrder.contains(href)) {
                        itemsToOrder.add(href);
                    }
                }
            }
            ++i;
        }
        List order = ProductPreferences.getTocOrder(itemsToOrder, nameIdMap);
        final HashMap catOrder = new HashMap();
        int i2 = 0;
        while (i2 < order.size()) {
            catOrder.put(order.get(i2), i2);
            ++i2;
        }
        Arrays.sort(toSort, new Comparator<ISearchEngineResult>(){

            @Override
            public int compare(ISearchEngineResult c1, ISearchEngineResult c2) {
                if (c1 == null && c2 == null) {
                    return 0;
                }
                if (c1 == null) {
                    return 1;
                }
                if (c2 == null) {
                    return -1;
                }
                if (catOrder.containsKey(c1.getHref()) && catOrder.containsKey(c2.getHref())) {
                    return (Integer)catOrder.get(c1.getHref()) - (Integer)catOrder.get(c2.getHref());
                }
                String l1 = c1.getLabel();
                String l2 = c2.getLabel();
                if (l1 == null && l2 == null) {
                    return 0;
                }
                if (l1 == null) {
                    return 1;
                }
                if (l2 == null) {
                    return -1;
                }
                if (l1.length() == 0 && l2.length() == 0) {
                    return 0;
                }
                if (l1.length() == 0) {
                    return 1;
                }
                if (l2.length() == 0) {
                    return -1;
                }
                return l1.compareToIgnoreCase(l2);
            }
        });
    }

    private static class SearchResultFilter
    extends SearchResults {
        public SearchResultFilter(WorkingSet[] workingSets, int maxHits, String locale, AbstractHelpScope filter, boolean isQuickSearch) {
            super(workingSets, maxHits, locale, isQuickSearch);
            this.setFilter(filter);
        }

        public void addHits(List<SearchHit> hits, String highlightTerms) {
            ArrayList<SearchHit> filtered = new ArrayList<SearchHit>();
            for (SearchHit obj : hits) {
                if (obj != null && obj.canOpen()) continue;
                filtered.add(obj);
            }
            super.addHits(filtered, highlightTerms);
        }
    }
}

