/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner.util;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformInitializer;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.launching.injection.InjectionConfiguration;
import org.eclipse.rcptt.launching.injection.InjectionFactory;
import org.eclipse.rcptt.launching.injection.UpdateSite;
import org.eclipse.rcptt.launching.internal.target.PDEHelper;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.target.TargetPlatformManager;
import org.eclipse.rcptt.runner.PrintStreamMonitor;
import org.eclipse.rcptt.runner.Q7PluginValidator;
import org.eclipse.rcptt.runner.RunnerConfiguration;

public class TargetPlatformChecker {
    private final RunnerConfiguration conf;
    private ITargetPlatformHelper targetPlatform;

    public TargetPlatformChecker(RunnerConfiguration conf) {
        this.conf = conf;
    }

    public ITargetPlatformHelper getTargetPlatform() {
        return this.targetPlatform;
    }

    public boolean initAndCheckTargetPlatform() throws CoreException {
        if (this.conf.location == null) {
            System.out.println("AUT location is not set");
            return false;
        }
        File file = new File(this.conf.location);
        if (!file.exists()) {
            System.out.println("AUT location doesn't exist: " + file);
            return false;
        }
        System.out.println("Initializing target platform...");
        this.initializeTargetPlatform();
        System.out.println("Target platform is valid.");
        return true;
    }

    private void initializeTargetPlatform() throws CoreException {
        this.targetPlatform = null;
        if (this.conf.config != null) {
            this.targetPlatform = TargetPlatformManager.createTargetPlatform((String)this.conf.location, (IProgressMonitor)new PrintStreamMonitor());
            Map versions = this.targetPlatform.getVersions();
            Q7TargetPlatformInitializer.Q7Info q7Info = Q7TargetPlatformInitializer.getInfo((ITargetPlatformHelper)this.targetPlatform, (Map)versions);
            if (!this.conf.onlySpecified) {
                InjectionConfiguration configuration;
                IMetadataRepository repository = PDEHelper.safeLoadRepository((URI)q7Info.q7, (IProgressMonitor)new PrintStreamMonitor());
                if (repository != null && (configuration = Q7TargetPlatformInitializer.createInjectionConfiguration((IProgressMonitor)new PrintStreamMonitor(), (Q7TargetPlatformInitializer.Q7Info)q7Info, (Map)versions)) != null) {
                    this.conf.config.getEntries().addAll((Collection)configuration.getEntries());
                }
            } else if (q7Info.aspectj != null) {
                UpdateSite aspectsSite = InjectionFactory.eINSTANCE.createUpdateSite();
                aspectsSite.setUri(q7Info.aspectj.toString());
                this.conf.config.getEntries().add((Object)aspectsSite);
            }
            this.targetPlatform.setTargetName("AUT");
            IStatus rv = this.targetPlatform.applyInjection(this.conf.config, (IProgressMonitor)new PrintStreamMonitor());
            if (!rv.isOK()) {
                throw new CoreException(rv);
            }
            if (this.targetPlatform.getWeavingHook() == null) {
                throw new CoreException(RcpttPlugin.createStatus((String)"No org.eclipse.weaving hook plugin in target platform"));
            }
        } else {
            this.targetPlatform = Q7TargetPlatformManager.createTargetPlatform((String)this.conf.location, (IProgressMonitor)new PrintStreamMonitor());
            this.targetPlatform.setTargetName("AUT");
        }
        this.targetPlatform.save();
        if (!Q7PluginValidator.validate(this.targetPlatform)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.runner", "Target platform doesn't contain RCPTT runtime injected..."));
        }
    }
}

