/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.formatter.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rcptt.core.ecl.formatter.EclFormatterOptions;
import org.eclipse.rcptt.core.ecl.formatter.internal.SourceBuilder;
import org.eclipse.rcptt.core.ecl.scanner.EclScanner;
import org.eclipse.rcptt.core.ecl.scanner.EclToken;

public class ParsingFormatter {
    private SourceBuilder builder;
    private EclScanner scanner;
    private List<EclToken> buffer = new ArrayList<EclToken>();

    public ParsingFormatter(EclFormatterOptions options) {
        this.builder = new SourceBuilder(options);
    }

    public String format(EclScanner scanner) {
        this.scanner = scanner;
        this.script();
        return this.builder.toString();
    }

    private void script() {
        this.emptyLines(true);
        while (!this.typeIs(EclToken.Type.Eof)) {
            this.line(false, false);
        }
    }

    private void line(boolean curly, boolean square) {
        this.emptyLines(false);
        switch (this.type()) {
            case Eof: {
                break;
            }
            case Invalid: {
                this.invalid();
                break;
            }
            case SlComment: {
                this.builder.standaloneSlComment(this.eat(String.class));
                break;
            }
            case MlComment: {
                String comment = this.eat(String.class);
                if (this.typeIs(EclToken.Type.Linebreak, EclToken.Type.Eof)) {
                    this.builder.standaloneMlComment(comment);
                    break;
                }
                this.builder.mlCommentAtLineStart(comment);
                while (this.typeIs(EclToken.Type.MlComment)) {
                    comment = this.eat(String.class);
                    if (this.typeIs(EclToken.Type.Linebreak, EclToken.Type.Eof)) {
                        this.builder.mlCommentAtLineEnd(comment);
                        continue;
                    }
                    this.builder.inlineMlComment(comment);
                }
                if (this.typeIs(EclToken.Type.SlComment)) {
                    this.builder.slCommentAtLineEnd(this.eat(String.class));
                    break;
                }
                if (this.typeIs(EclToken.Type.Linebreak, EclToken.Type.Eof)) break;
                this.sequence(curly, square);
                break;
            }
            default: {
                this.sequence(curly, square);
            }
        }
    }

    private void sequence(boolean curly, boolean square) {
        while (true) {
            this.pipeline(curly, square);
            if (!this.typeIs(EclToken.Type.Semicolon)) break;
            this.eat();
            this.builder.semicolon();
        }
        if (!this.typeIs(EclToken.Type.Eof) && !square) {
            this.builder.linebreak();
        }
    }

    private void pipeline(boolean curly, boolean square) {
        boolean first = true;
        while (true) {
            this.command(curly, square, !first);
            if (!this.typeIs(EclToken.Type.Pipe)) break;
            this.eat();
            this.builder.pipe();
            first = false;
        }
    }

    private void command(boolean curly, boolean square, boolean pipe) {
        boolean atStart = true;
        boolean seenPlus = false;
        boolean seenNonWhitespace = false;
        ArrayList<SourceBuilder.Part> strings = new ArrayList<SourceBuilder.Part>();
        String lastCommandName = null;
        block25: while (true) {
            block0 : switch (this.type()) {
                case Pipe: 
                case Semicolon: {
                    break block25;
                }
                case SlComment: {
                    if (this.isCommandContinued(pipe)) {
                        this.builder.softSlCommentAtLineEnd(this.eat(String.class));
                        seenNonWhitespace = false;
                        break;
                    }
                    this.builder.slCommentAtSequenceEnd(this.eat(String.class));
                    break block25;
                }
                case MlComment: {
                    this.builder.softInlineMlComment(this.eat(String.class));
                    break;
                }
                case Linebreak: {
                    if (!this.isSequenceContinued(pipe)) break block25;
                    this.eat();
                    break;
                }
                case Identifier: {
                    seenNonWhitespace = true;
                    if (seenPlus) {
                        seenPlus = this.setQuoteAlways(strings);
                    }
                    if (atStart || pipe) {
                        lastCommandName = this.eat(String.class);
                        this.builder.commandName(lastCommandName);
                    } else {
                        this.builder.positionalLiteralArg(this.eat(String.class), ParsingFormatter.isWrappableLiteral(lastCommandName));
                        lastCommandName = null;
                    }
                    pipe = false;
                    break;
                }
                case String: {
                    if (seenNonWhitespace) {
                        strings.add(this.builder.positionalLiteralArg(this.String(), ParsingFormatter.isWrappableLiteral(lastCommandName)));
                    } else {
                        this.builder.positionalQuotedLiteralArg(this.String(), ParsingFormatter.isWrappableLiteral(lastCommandName));
                    }
                    seenNonWhitespace = true;
                    lastCommandName = null;
                    if (!seenPlus) break;
                    seenPlus = this.setQuoteAlways(strings);
                    break;
                }
                case Plus: {
                    seenPlus = true;
                    seenNonWhitespace = true;
                    lastCommandName = null;
                    this.eat();
                    this.builder.plus();
                    break;
                }
                case Number: {
                    if (seenPlus) {
                        seenPlus = this.setQuoteAlways(strings);
                    }
                    seenNonWhitespace = true;
                    this.builder.positionalLiteralArg(this.eat().text, ParsingFormatter.isWrappableLiteral(lastCommandName));
                    lastCommandName = null;
                    break;
                }
                case Variable: {
                    if (seenPlus) {
                        seenPlus = this.setQuoteAlways(strings);
                    }
                    seenNonWhitespace = true;
                    lastCommandName = null;
                    if (atStart || pipe) {
                        this.builder.variableEmit(this.eat(String.class));
                        break;
                    }
                    this.builder.positionalVariableArg(this.eat(String.class));
                    break;
                }
                case Option: {
                    if (seenPlus) {
                        seenPlus = this.setQuoteAlways(strings);
                    }
                    seenNonWhitespace = true;
                    lastCommandName = null;
                    String option = this.eat(String.class);
                    switch (this.type()) {
                        case Identifier: {
                            this.builder.namedLiteralArg(option, this.eat(String.class));
                            break block0;
                        }
                        case Number: {
                            this.builder.namedLiteralArg(option, this.eat().text);
                            break block0;
                        }
                        case String: {
                            strings.add(this.builder.namedLiteralArg(option, this.String()));
                            break block0;
                        }
                        case Variable: {
                            this.builder.namedVariableArg(option, this.eat(String.class));
                            break block0;
                        }
                        case CurlyOpen: {
                            this.builder.scriptArgName(option);
                            this.block();
                            break block0;
                        }
                        case SquareOpen: {
                            this.builder.pipelineArgName(option);
                            this.pipeline();
                            break block0;
                        }
                    }
                    this.builder.boolArg(option);
                    break;
                }
                case CurlyOpen: {
                    seenNonWhitespace = true;
                    lastCommandName = null;
                    this.block();
                    break;
                }
                case CurlyClose: {
                    seenNonWhitespace = true;
                    lastCommandName = null;
                    if (curly) break block25;
                    this.eat();
                    this.builder.scriptArgClose();
                    break;
                }
                case SquareOpen: {
                    seenNonWhitespace = true;
                    lastCommandName = null;
                    this.pipeline();
                    break;
                }
                case SquareClose: {
                    seenNonWhitespace = true;
                    lastCommandName = null;
                    if (square) break block25;
                    this.eat();
                    this.builder.pipelineArgClose();
                    break;
                }
                case Eof: {
                    break block25;
                }
                default: {
                    seenNonWhitespace = true;
                    lastCommandName = null;
                    this.invalid();
                }
            }
            atStart = false;
        }
        if (seenPlus) {
            this.setQuoteAlways(strings);
        }
    }

    private String String() {
        StringBuilder result = new StringBuilder();
        result.append(this.eat(String.class));
        EclToken plus = null;
        int i = 0;
        block5: while (true) {
            EclToken token = this.peek(i);
            switch (token.type) {
                case Linebreak: {
                    break;
                }
                case Plus: {
                    if (plus != null) break block5;
                    plus = token;
                    break;
                }
                case String: {
                    if (plus == null) break block5;
                    result.append((String)token.value);
                    while (i-- >= 0) {
                        this.eat();
                    }
                    i = -1;
                    plus = null;
                    break;
                }
                default: {
                    break block5;
                }
            }
            ++i;
        }
        return result.toString();
    }

    private boolean setQuoteAlways(List<SourceBuilder.Part> parts) {
        for (SourceBuilder.Part p : parts) {
            p.setQuoting(SourceBuilder.Quote.Always);
        }
        parts.clear();
        return false;
    }

    private void pipeline() {
        this.builder.pipelineArgOpen();
        this.eat();
        this.emptyLines(false);
        while (!this.typeIs(EclToken.Type.Eof, EclToken.Type.SquareClose)) {
            this.line(false, true);
        }
        if (this.typeIs(EclToken.Type.SquareClose)) {
            this.eat();
            this.builder.pipelineArgClose();
        }
    }

    private void block() {
        this.builder.scriptArgOpen();
        this.eat();
        this.emptyLines(false);
        while (!this.typeIs(EclToken.Type.Eof, EclToken.Type.CurlyClose)) {
            this.line(true, false);
        }
        if (this.typeIs(EclToken.Type.CurlyClose)) {
            this.eat();
            this.builder.scriptArgClose();
        }
    }

    private void invalid() {
        this.builder.invalid(this.eat().text);
    }

    private boolean isSequenceContinued(boolean pipe) {
        EclToken token = this.nextNon(EclToken.Type.Linebreak, EclToken.Type.SlComment, EclToken.Type.MlComment);
        if (pipe && token.type == EclToken.Type.Identifier) {
            return true;
        }
        return this.typeIs(token, EclToken.Type.CurlyOpen, EclToken.Type.Number, EclToken.Type.Option, EclToken.Type.Plus, EclToken.Type.SquareOpen, EclToken.Type.String, EclToken.Type.Pipe, EclToken.Type.Semicolon);
    }

    private boolean isCommandContinued(boolean pipe) {
        return this.isSequenceContinued(pipe);
    }

    private static boolean isWrappableLiteral(String lastCommandName) {
        if (lastCommandName == null) {
            return false;
        }
        return !SourceBuilder.NO_WRAP_COMMANDS.contains(lastCommandName = lastCommandName.toLowerCase());
    }

    private void emptyLines(boolean removeLines) {
        int linebreaks = 0;
        while (this.typeIs(EclToken.Type.Linebreak)) {
            this.eat();
            ++linebreaks;
        }
        if (!removeLines && linebreaks > 1) {
            this.builder.linebreak();
        }
    }

    private EclToken nextNon(EclToken.Type ... types) {
        int i = 0;
        EclToken token;
        while (this.typeIs(token = this.peek(i), types)) {
            ++i;
        }
        return token;
    }

    private EclToken.Type type() {
        return this.peek().type;
    }

    private boolean typeIs(EclToken.Type type) {
        return this.peek().type == type;
    }

    private boolean typeIs(EclToken.Type ... types) {
        return this.typeIs(this.peek(), types);
    }

    private boolean typeIs(EclToken token, EclToken.Type ... types) {
        EclToken.Type type = token.type;
        EclToken.Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            EclToken.Type t = typeArray[n2];
            if (type == t) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private EclToken peek() {
        return this.peek(0);
    }

    private EclToken peek(int offset) {
        while (this.buffer.size() < offset + 1) {
            EclToken token = this.scanner.next();
            if (token.type == EclToken.Type.Spacing) continue;
            this.buffer.add(token);
        }
        return this.buffer.get(offset);
    }

    private EclToken eat() {
        this.peek();
        return this.buffer.remove(0);
    }

    private <T> T eat(Class<T> class_) {
        return class_.cast(this.eat().value);
    }
}

