/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.help.AbstractTocProvider;
import org.eclipse.help.ITocContribution;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.remote.HttpsUtility;
import org.eclipse.help.internal.base.remote.PreferenceFileHandler;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.base.remote.RemoteTocParser;
import org.eclipse.help.internal.base.util.ProxyUtil;

public class RemoteTocProvider
extends AbstractTocProvider {
    private static final String PATH_TOC = "/toc";
    private static final String PROTOCOL = "http";
    private static final String PARAM_LANG = "lang";
    private static final String PROTOCOL_HTTPS = "https";

    public RemoteTocProvider() {
        RemoteHelp.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                RemoteTocProvider.this.contentChanged();
            }
        });
    }

    public ITocContribution[] getTocContributions(String locale) {
        if (RemoteHelp.isEnabled()) {
            InputStream in = null;
            PreferenceFileHandler prefHandler = new PreferenceFileHandler();
            RemoteTocParser parser = new RemoteTocParser();
            String[] host = prefHandler.getHostEntries();
            String[] port = prefHandler.getPortEntries();
            String[] path = prefHandler.getPathEntries();
            String[] protocol = prefHandler.getProtocolEntries();
            String[] isEnabled = prefHandler.isEnabled();
            ITocContribution[] currentContributions = new ITocContribution[]{};
            ITocContribution[] temp = new ITocContribution[]{};
            ITocContribution[] totalContributions = new ITocContribution[]{};
            int numICs = host.length;
            if (numICs == 0) {
                return new ITocContribution[0];
            }
            URL url = null;
            String urlStr = "";
            int i = numICs - 1;
            while (i >= 0) {
                block21: {
                    if (isEnabled[i].equalsIgnoreCase("true")) {
                        try {
                            try {
                                if (protocol[i].equalsIgnoreCase(PROTOCOL)) {
                                    url = new URL(protocol[i], host[i], new Integer(port[i]), String.valueOf(path[i]) + PATH_TOC + '?' + PARAM_LANG + '=' + locale);
                                    in = ProxyUtil.getStream(url);
                                    urlStr = "http://" + host[i] + ":" + port[i] + path[i];
                                } else {
                                    in = HttpsUtility.getHttpsInputStream(protocol[i], host[i], port[i], path[i], locale);
                                    urlStr = "https://" + host[i] + ":" + port[i] + path[i];
                                }
                                if (in != null) {
                                    currentContributions = parser.parse(in, urlStr);
                                    temp = new ITocContribution[totalContributions.length];
                                    System.arraycopy(totalContributions, 0, temp, 0, totalContributions.length);
                                    totalContributions = new ITocContribution[temp.length + currentContributions.length];
                                    System.arraycopy(temp, 0, totalContributions, 0, temp.length);
                                    System.arraycopy(currentContributions, 0, totalContributions, temp.length, currentContributions.length);
                                }
                            }
                            catch (Throwable t) {
                                String msg = "Internal error while reading TOC contents from remote server";
                                HelpBasePlugin.logError(msg, t);
                                RemoteHelp.setError(t);
                                if (in != null) {
                                    try {
                                        in.close();
                                        in = null;
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block21;
                            }
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    in.close();
                                    in = null;
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (in != null) {
                            try {
                                in.close();
                                in = null;
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                --i;
            }
            return totalContributions;
        }
        return new ITocContribution[0];
    }

    public int getPriority() {
        int helpOption = PreferenceFileHandler.getEmbeddedHelpOption();
        if (helpOption == 0 || helpOption == 1) {
            return 21;
        }
        return 9;
    }
}

