/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureURL;
import org.eclipse.pde.internal.core.ifeature.IFeatureURLElement;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class URLDetailsSection
extends PDESection
implements IPartSelectionListener {
    private FormEntry fNameText;
    private FormEntry fUrlText;
    private IFeatureURLElement fInput;

    public URLDetailsSection(PDEFormPage page, Composite parent) {
        super(page, parent, 4224, false);
        this.getSection().setDescription(PDEUIMessages.FeatureEditor_URLDetailsSection_desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void commit(boolean onSave) {
        this.fUrlText.commit();
        this.fNameText.commit();
        super.commit(onSave);
    }

    private void commitSiteUrl(String value) {
        if (this.fInput == null) {
            return;
        }
        try {
            if (value.length() > 0) {
                URL siteUrl = new URL(value);
                this.fInput.setURL(siteUrl);
            } else {
                this.fInput.setURL(null);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        catch (MalformedURLException e) {
            PDEPlugin.logException(e);
        }
    }

    private void commitSiteName(String value) {
        if (this.fInput == null) {
            return;
        }
        try {
            this.fInput.setLabel(value);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        final IFeature feature = model.getFeature();
        this.fUrlText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_URLDetailsSection_updateUrl, null, false);
        this.fUrlText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                String url;
                String string = url = text.getValue() != null ? text.getValue() : "";
                if (url.length() > 0 && !URLDetailsSection.this.verifySiteUrl(feature, url)) {
                    URLDetailsSection.this.warnBadUrl(url);
                    URLDetailsSection.this.setUrlText();
                } else {
                    URLDetailsSection.this.commitSiteUrl(url);
                }
            }
        });
        this.fNameText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_URLDetailsSection_updateUrlLabel, null, false);
        this.fNameText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                String name = text.getValue() != null ? text.getValue() : "";
                URLDetailsSection.this.commitSiteName(name);
            }
        });
        GridData gd = (GridData)this.fUrlText.getText().getLayoutData();
        gd.widthHint = 150;
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    private boolean verifySiteUrl(IFeature feature, String value) {
        try {
            new URL(value);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    private void warnBadUrl(String text) {
        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.FeatureEditor_URLDetailsSection_badUrlTitle, (String)PDEUIMessages.FeatureEditor_URLDetailsSection_badUrlMessage);
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.refresh();
        if (!model.isEditable()) {
            this.fUrlText.getText().setEditable(false);
            this.fNameText.getText().setEditable(false);
        }
        model.addModelChangedListener((IModelChangedListener)this);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        Object[] objs;
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        if (e.getChangeType() == 3 && (objs = e.getChangedObjects()).length > 0 && objs[0] instanceof IFeatureURL) {
            this.markStale();
        }
        if ((objs = e.getChangedObjects()).length > 0 && objs[0] instanceof IFeatureURLElement) {
            this.markStale();
        }
    }

    public void setFocus() {
        if (this.fUrlText != null) {
            this.fUrlText.getText().setFocus();
        }
    }

    public void refresh() {
        this.update();
        super.refresh();
    }

    private void setUrlText() {
        String updateSiteUrl = "";
        if (this.fInput != null && this.fInput.getURL() != null) {
            updateSiteUrl = this.fInput.getURL().toExternalForm();
        }
        this.fUrlText.setValue(updateSiteUrl != null ? updateSiteUrl : "", true);
    }

    private void update() {
        this.fUrlText.setEditable(this.fInput != null && this.fInput.getModel().isEditable());
        this.fNameText.setEditable(this.fInput != null && this.fInput.getModel().isEditable());
        this.setUrlText();
        this.setNameText();
    }

    private void setNameText() {
        String updateSiteLabel = "";
        if (this.fInput != null) {
            updateSiteLabel = this.fInput.getLabel();
        }
        this.fNameText.setValue(updateSiteLabel != null ? updateSiteLabel : "", true);
    }

    @Override
    public void cancelEdit() {
        this.fNameText.cancelEdit();
        this.fUrlText.cancelEdit();
        super.cancelEdit();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object o;
        this.fInput = selection instanceof IStructuredSelection && !selection.isEmpty() ? ((o = ((IStructuredSelection)selection).getFirstElement()) instanceof IFeatureURLElement && ((IFeatureURLElement)o).getElementType() == 2 ? (IFeatureURLElement)o : null) : null;
        this.update();
    }
}

