/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;

public final class Cursor
extends Resource {
    public int handle;
    static final byte[] APPSTARTING_SRC;
    static final byte[] APPSTARTING_MASK;

    static {
        byte[] byArray = new byte[128];
        byArray[8] = 4;
        byArray[12] = 12;
        byArray[16] = 28;
        byArray[20] = 60;
        byArray[24] = 124;
        byArray[28] = -4;
        byArray[32] = -4;
        byArray[33] = 1;
        byArray[36] = -4;
        byArray[37] = 59;
        byArray[40] = 124;
        byArray[41] = 56;
        byArray[44] = 108;
        byArray[45] = 84;
        byArray[48] = -60;
        byArray[49] = -36;
        byArray[52] = -64;
        byArray[53] = 68;
        byArray[56] = -128;
        byArray[57] = 57;
        byArray[60] = -128;
        byArray[61] = 57;
        APPSTARTING_SRC = byArray;
        byte[] byArray2 = new byte[128];
        byArray2[4] = 6;
        byArray2[8] = 14;
        byArray2[12] = 30;
        byArray2[16] = 62;
        byArray2[20] = 126;
        byArray2[24] = -2;
        byArray2[28] = -2;
        byArray2[29] = 1;
        byArray2[32] = -2;
        byArray2[33] = 59;
        byArray2[36] = -2;
        byArray2[37] = 127;
        byArray2[40] = -2;
        byArray2[41] = 127;
        byArray2[44] = -2;
        byArray2[45] = -2;
        byArray2[48] = -18;
        byArray2[49] = -1;
        byArray2[50] = 1;
        byArray2[52] = -28;
        byArray2[53] = -1;
        byArray2[56] = -64;
        byArray2[57] = 127;
        byArray2[60] = -64;
        byArray2[61] = 127;
        byArray2[64] = -128;
        byArray2[65] = 57;
        APPSTARTING_MASK = byArray2;
    }

    Cursor(Device device) {
        super(device);
    }

    public Cursor(Device device, int style) {
        super(device);
        int shape = 0;
        switch (style) {
            case 3: {
                break;
            }
            case 0: {
                shape = 68;
                break;
            }
            case 1: {
                shape = 150;
                break;
            }
            case 2: {
                shape = 30;
                break;
            }
            case 21: {
                shape = 60;
                break;
            }
            case 4: {
                shape = 92;
                break;
            }
            case 5: {
                shape = 52;
                break;
            }
            case 6: {
                shape = 120;
                break;
            }
            case 7: {
                shape = 42;
                break;
            }
            case 8: {
                shape = 120;
                break;
            }
            case 9: {
                shape = 108;
                break;
            }
            case 10: {
                shape = 138;
                break;
            }
            case 11: {
                shape = 16;
                break;
            }
            case 12: {
                shape = 96;
                break;
            }
            case 13: {
                shape = 70;
                break;
            }
            case 14: {
                shape = 136;
                break;
            }
            case 15: {
                shape = 14;
                break;
            }
            case 16: {
                shape = 12;
                break;
            }
            case 17: {
                shape = 134;
                break;
            }
            case 18: {
                shape = 114;
                break;
            }
            case 19: {
                shape = 152;
                break;
            }
            case 20: {
                shape = 0;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        if (shape == 0 && style == 3) {
            byte[] src = new byte[APPSTARTING_SRC.length];
            System.arraycopy(APPSTARTING_SRC, 0, src, 0, src.length);
            byte[] mask = new byte[APPSTARTING_MASK.length];
            System.arraycopy(APPSTARTING_MASK, 0, mask, 0, mask.length);
            this.handle = this.createCursor(src, mask, 32, 32, 2, 2, true);
        } else {
            this.handle = OS.gdk_cursor_new(shape);
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData source, ImageData mask, int hotspotX, int hotspotY) {
        super(device);
        byte s;
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            if (source.getTransparencyType() != 2) {
                SWT.error(4);
            }
            mask = source.getTransparencyMask();
        }
        if (mask.width != source.width || mask.height != source.height) {
            SWT.error(5);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        source = ImageData.convertMask(source);
        mask = ImageData.convertMask(mask);
        byte[] sourceData = new byte[source.data.length];
        byte[] maskData = new byte[mask.data.length];
        byte[] data = source.data;
        int i = 0;
        while (i < data.length) {
            s = data[i];
            sourceData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            sourceData[i] = ~sourceData[i];
            ++i;
        }
        sourceData = ImageData.convertPad(sourceData, source.width, source.height, source.depth, source.scanlinePad, 1);
        data = mask.data;
        i = 0;
        while (i < data.length) {
            s = data[i];
            maskData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            maskData[i] = ~maskData[i];
            ++i;
        }
        maskData = ImageData.convertPad(maskData, mask.width, mask.height, mask.depth, mask.scanlinePad, 1);
        this.handle = this.createCursor(maskData, sourceData, source.width, source.height, hotspotX, hotspotY, true);
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData source, int hotspotX, int hotspotY) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        int display = 0;
        display = OS.gdk_display_get_default();
        if (OS.gdk_display_supports_cursor_color(display)) {
            int width = source.width;
            int height = source.height;
            PaletteData palette = source.palette;
            int pixbuf = OS.gdk_pixbuf_new(0, true, 8, width, height);
            if (pixbuf == 0) {
                SWT.error(2);
            }
            int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
            int data = OS.gdk_pixbuf_get_pixels(pixbuf);
            byte[] buffer = source.data;
            if (!palette.isDirect || source.depth != 24 || stride != source.bytesPerLine || palette.redMask != -16777216 || palette.greenMask != 0xFF0000 || palette.blueMask != 65280) {
                int i;
                buffer = new byte[source.width * source.height * 4];
                if (palette.isDirect) {
                    ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, buffer, 32, source.width * 4, 1, 0, 0, source.width, source.height, -16777216, 0xFF0000, 65280, false, false);
                } else {
                    RGB[] rgbs = palette.getRGBs();
                    int length = rgbs.length;
                    byte[] srcReds = new byte[length];
                    byte[] srcGreens = new byte[length];
                    byte[] srcBlues = new byte[length];
                    int i2 = 0;
                    while (i2 < rgbs.length) {
                        RGB rgb = rgbs[i2];
                        if (rgb != null) {
                            srcReds[i2] = (byte)rgb.red;
                            srcGreens[i2] = (byte)rgb.green;
                            srcBlues[i2] = (byte)rgb.blue;
                        }
                        ++i2;
                    }
                    ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, buffer, 32, source.width * 4, 1, 0, 0, source.width, source.height, -16777216, 0xFF0000, 65280, false, false);
                }
                if (source.maskData != null || source.transparentPixel != -1) {
                    ImageData mask = source.getTransparencyMask();
                    byte[] maskData = mask.data;
                    int maskBpl = mask.bytesPerLine;
                    int offset = 3;
                    int maskOffset = 0;
                    int y = 0;
                    while (y < source.height) {
                        int x = 0;
                        while (x < source.width) {
                            buffer[offset] = (maskData[maskOffset + (x >> 3)] & 1 << 7 - (x & 7)) != 0 ? -1 : 0;
                            offset += 4;
                            ++x;
                        }
                        maskOffset += maskBpl;
                        ++y;
                    }
                } else if (source.alpha != -1) {
                    byte alpha = (byte)source.alpha;
                    i = 3;
                    while (i < buffer.length) {
                        buffer[i] = alpha;
                        i += 4;
                    }
                } else if (source.alphaData != null) {
                    byte[] alphaData = source.alphaData;
                    i = 3;
                    while (i < buffer.length) {
                        buffer[i] = alphaData[i / 4];
                        i += 4;
                    }
                }
            }
            OS.memmove(data, buffer, stride * height);
            this.handle = OS.gdk_cursor_new_from_pixbuf(display, pixbuf, hotspotX, hotspotY);
            OS.g_object_unref(pixbuf);
        } else {
            ImageData mask = source.getTransparencyMask();
            if (source.depth > 1) {
                byte[] newReds;
                ImageData newSource = new ImageData(source.width, source.height, 1, ImageData.bwPalette(), 1, null, 0, null, null, -1, -1, 0, 0, 0, 0, 0);
                byte[] byArray = new byte[2];
                byArray[1] = -1;
                byte[] newGreens = newReds = byArray;
                byte[] newBlues = newReds;
                PaletteData palette = source.palette;
                if (palette.isDirect) {
                    ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newSource.width, newSource.height, newReds, newGreens, newBlues, false, false);
                } else {
                    RGB[] rgbs = palette.getRGBs();
                    int length = rgbs.length;
                    byte[] srcReds = new byte[length];
                    byte[] srcGreens = new byte[length];
                    byte[] srcBlues = new byte[length];
                    int i = 0;
                    while (i < rgbs.length) {
                        RGB rgb = rgbs[i];
                        if (rgb != null) {
                            srcReds[i] = (byte)rgb.red;
                            srcGreens[i] = (byte)rgb.green;
                            srcBlues[i] = (byte)rgb.blue;
                        }
                        ++i;
                    }
                    ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newSource.width, newSource.height, newReds, newGreens, newBlues, false, false);
                }
                source = newSource;
            }
            byte[] sourceData = new byte[source.data.length];
            byte[] maskData = new byte[mask.data.length];
            byte[] data = source.data;
            int i = 0;
            while (i < data.length) {
                byte s = data[i];
                sourceData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
                ++i;
            }
            sourceData = ImageData.convertPad(sourceData, source.width, source.height, source.depth, source.scanlinePad, 1);
            data = mask.data;
            i = 0;
            while (i < data.length) {
                byte s = data[i];
                maskData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
                ++i;
            }
            maskData = ImageData.convertPad(maskData, mask.width, mask.height, mask.depth, mask.scanlinePad, 1);
            this.handle = this.createCursor(sourceData, maskData, source.width, source.height, hotspotX, hotspotY, false);
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    int createCursor(byte[] sourceData, byte[] maskData, int width, int height, int hotspotX, int hotspotY, boolean reverse) {
        if (OS.GTK3) {
            byte s;
            int i = 0;
            while (i < sourceData.length) {
                s = sourceData[i];
                sourceData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
                sourceData[i] = ~sourceData[i];
                ++i;
            }
            i = 0;
            while (i < maskData.length) {
                s = maskData[i];
                maskData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
                maskData[i] = ~maskData[i];
                ++i;
            }
            PaletteData palette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
            ImageData source = new ImageData(width, height, 1, palette, 1, sourceData);
            ImageData mask = new ImageData(width, height, 1, palette, 1, maskData);
            byte[] data = new byte[source.width * source.height * 4];
            int y = 0;
            while (y < source.height) {
                int offset = y * source.width * 4;
                int x = 0;
                while (x < source.width) {
                    int pixel = source.getPixel(x, y);
                    int maskPixel = mask.getPixel(x, y);
                    if (pixel == 0 && maskPixel == 0) {
                        data[offset + 3] = -1;
                    } else if (pixel == 0 && maskPixel == 1) {
                        data[offset + 3] = -1;
                        data[offset + 2] = -1;
                        data[offset + 1] = -1;
                        data[offset] = -1;
                    } else if (pixel == 1) {
                        // empty if block
                    }
                    offset += 4;
                    ++x;
                }
                ++y;
            }
            int pixbuf = OS.gdk_pixbuf_new(0, true, 8, width, height);
            if (pixbuf == 0) {
                SWT.error(2);
            }
            int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
            int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
            OS.memmove(pixels, data, stride * height);
            int cursor = OS.gdk_cursor_new_from_pixbuf(OS.gdk_display_get_default(), pixbuf, hotspotX, hotspotY);
            OS.g_object_unref(pixbuf);
            return cursor;
        }
        int sourcePixmap = OS.gdk_bitmap_create_from_data(0, sourceData, width, height);
        int maskPixmap = OS.gdk_bitmap_create_from_data(0, maskData, width, height);
        int cursor = 0;
        if (sourcePixmap != 0 && maskPixmap != 0) {
            GdkColor foreground = new GdkColor();
            if (!reverse) {
                foreground.blue = (short)-1;
                foreground.green = (short)-1;
                foreground.red = (short)-1;
            }
            GdkColor background = new GdkColor();
            if (reverse) {
                background.blue = (short)-1;
                background.green = (short)-1;
                background.red = (short)-1;
            }
            cursor = OS.gdk_cursor_new_from_pixmap(sourcePixmap, maskPixmap, foreground, background, hotspotX, hotspotY);
        }
        if (sourcePixmap != 0) {
            OS.g_object_unref(sourcePixmap);
        }
        if (maskPixmap != 0) {
            OS.g_object_unref(maskPixmap);
        }
        return cursor;
    }

    void destroy() {
        this.gdk_cursor_unref(this.handle);
        this.handle = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public static Cursor gtk_new(Device device, int handle) {
        Cursor cursor = new Cursor(device);
        cursor.handle = handle;
        return cursor;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }

    void gdk_cursor_unref(int cursor) {
        if (OS.GTK3) {
            OS.g_object_unref(cursor);
        } else {
            OS.gdk_cursor_unref(cursor);
        }
    }
}

