/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaLogicalStructure;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaLogicalStructures;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaStructureErrorValue;
import org.eclipse.jdt.internal.debug.ui.EditLogicalStructureDialog;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class EditVariableLogicalStructureAction
extends ActionDelegate
implements IObjectActionDelegate {
    private JavaLogicalStructure fStructure = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        EditLogicalStructureDialog dialog;
        if (this.fStructure == null) {
            return;
        }
        Shell shell = JDIDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null && (dialog = new EditLogicalStructureDialog(shell, this.fStructure)).open() == 0) {
            JavaLogicalStructures.saveUserDefinedJavaLogicalStructures();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fStructure = null;
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element instanceof IJavaVariable) {
            try {
                JavaLogicalStructure javaStructure;
                ILogicalStructureType type;
                IValue value = ((IJavaVariable)element).getValue();
                if (value instanceof JavaStructureErrorValue) {
                    value = ((JavaStructureErrorValue)value).getParentValue();
                }
                if ((type = EditVariableLogicalStructureAction.getLogicalStructure(value)) instanceof JavaLogicalStructure && !(javaStructure = (JavaLogicalStructure)type).isContributed()) {
                    this.fStructure = javaStructure;
                }
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.log(e.getStatus());
            }
        }
        action.setEnabled(this.fStructure != null);
    }

    public static ILogicalStructureType getLogicalStructure(IValue value) {
        ILogicalStructureType type = null;
        ILogicalStructureType[] types = DebugPlugin.getLogicalStructureTypes((IValue)value);
        if (types.length > 0) {
            type = DebugPlugin.getDefaultStructureType((ILogicalStructureType[])types);
        }
        return type;
    }
}

