/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.actions.ActionMessages;
import org.eclipse.pde.api.tools.ui.internal.actions.TreeViewerNavigator;
import org.eclipse.pde.api.tools.ui.internal.views.APIToolingView;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.actions.ActionFactory;

public class NavigateAction
extends Action {
    private final boolean next;
    private IViewSite site;
    private TreeViewer viewer;

    public NavigateAction(APIToolingView view, boolean next) {
        this.site = view.getViewSite();
        this.viewer = view.viewer;
        this.next = next;
        IActionBars bars = this.site.getActionBars();
        if (next) {
            this.setText(ActionMessages.NextAction_label);
            this.setToolTipText(ActionMessages.NextAction_tooltip);
            ImageDescriptor enabledImageDescriptor = ApiUIPlugin.getImageDescriptor("IMG_ELCL_NEXT_NAV");
            this.setImageDescriptor(enabledImageDescriptor);
            ImageDescriptor disabledImageDescriptor = ApiUIPlugin.getImageDescriptor("IMG_DLCL_NEXT_NAV");
            this.setDisabledImageDescriptor(disabledImageDescriptor);
            this.setActionDefinitionId(ActionFactory.NEXT.getCommandId());
            if (bars != null) {
                bars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this);
            }
        } else {
            this.setText(ActionMessages.PreviousAction_label);
            this.setToolTipText(ActionMessages.PreviousAction_tooltip);
            ImageDescriptor enabledImageDescriptor = ApiUIPlugin.getImageDescriptor("IMG_ELCL_PREV_NAV");
            this.setImageDescriptor(enabledImageDescriptor);
            ImageDescriptor disabledImageDescriptor = ApiUIPlugin.getImageDescriptor("IMG_DLCL_PREV_NAV");
            this.setDisabledImageDescriptor(disabledImageDescriptor);
            this.setActionDefinitionId(ActionFactory.PREVIOUS.getCommandId());
            if (bars != null) {
                bars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this);
            }
        }
    }

    public void run() {
        TreeViewerNavigator navigator = new TreeViewerNavigator(this.viewer);
        navigator.navigateNext(this.next);
    }
}

