/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.team.core.synchronize.ISyncInfoTreeChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProviderDescriptor;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElementSorter;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.UnchangedResourceModelElement;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class HierarchicalModelProvider
extends SynchronizeModelProvider {
    private static final HierarchicalModelProviderDescriptor hierarchicalDescriptor = new HierarchicalModelProviderDescriptor();

    public HierarchicalModelProvider(ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        super(configuration, set);
    }

    public HierarchicalModelProvider(AbstractSynchronizeModelProvider parentProvider, ISynchronizeModelElement modelRoot, ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        super(parentProvider, modelRoot, configuration, set);
    }

    public ISynchronizeModelProviderDescriptor getDescriptor() {
        return hierarchicalDescriptor;
    }

    public ViewerSorter getViewerSorter() {
        return new SynchronizeModelElementSorter();
    }

    protected SyncInfoTree getSyncInfoTree() {
        return (SyncInfoTree)this.getSyncInfoSet();
    }

    protected IDiffElement[] createModelObjects(ISynchronizeModelElement container) {
        Object resource = null;
        resource = container == this.getModelRoot() ? ResourcesPlugin.getWorkspace().getRoot() : container.getResource();
        if (resource != null) {
            SyncInfoTree infoTree = this.getSyncInfoTree();
            IResource[] children = infoTree.members((IResource)resource);
            ISynchronizeModelElement[] nodes = new ISynchronizeModelElement[children.length];
            int i = 0;
            while (i < children.length) {
                nodes[i] = this.createModelObject(container, children[i]);
                ++i;
            }
            return nodes;
        }
        return new IDiffElement[0];
    }

    protected ISynchronizeModelElement createModelObject(ISynchronizeModelElement parent, IResource resource) {
        SyncInfo info = this.getSyncInfoTree().getSyncInfo(resource);
        SynchronizeModelElement newNode = info != null ? new SyncInfoModelElement(parent, info) : new UnchangedResourceModelElement(parent, resource);
        this.addToViewer(newNode);
        return newNode;
    }

    protected Object[] getModelObjects(IResource[] resources) {
        Object[] result = new Object[resources.length];
        int i = 0;
        while (i < resources.length) {
            result[i] = this.getModelObject(resources[i]);
            ++i;
        }
        return result;
    }

    protected void addResources(IResource[] added) {
        int i = 0;
        while (i < added.length) {
            IResource resource = added[i];
            this.addResource(resource);
            ++i;
        }
    }

    private void addResource(IResource resource) {
        ISynchronizeModelElement parent;
        ISynchronizeModelElement node = this.getModelObject(resource);
        if (node != null) {
            this.removeFromViewer(resource);
        }
        if ((parent = this.getModelObject((IResource)resource.getParent())) != null) {
            node = this.createModelObject(parent, resource);
            this.buildModelObjects(node);
        }
    }

    protected IDiffElement[] buildModelObjects(ISynchronizeModelElement node) {
        IDiffElement[] children = this.createModelObjects(node);
        int i = 0;
        while (i < children.length) {
            IDiffElement element = children[i];
            if (element instanceof ISynchronizeModelElement) {
                this.buildModelObjects((ISynchronizeModelElement)element);
            }
            ++i;
        }
        return children;
    }

    protected void handleResourceAdditions(ISyncInfoTreeChangeEvent event) {
        SyncInfo[] infos = event.getAddedResources();
        HashSet<IProject> set = new HashSet<IProject>();
        int i = 0;
        while (i < infos.length) {
            SyncInfo info = infos[i];
            set.add(info.getLocal().getProject());
            ++i;
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            this.addResource((IResource)it.next());
        }
    }

    protected void handleResourceRemovals(ISyncInfoTreeChangeEvent event) {
        IResource[] removedRoots = event.getRemovedSubtreeRoots();
        this.removeFromViewer(removedRoots);
        IResource[] removedResources = event.getRemovedResources();
        int i = 0;
        while (i < removedResources.length) {
            ISynchronizeModelElement node;
            IResource resource = removedResources[i];
            if (resource.getType() != 1 && (node = this.getModelObject(resource)) != null) {
                this.removeFromViewer(resource);
            }
            ++i;
        }
    }

    protected ISynchronizeModelElement createModelObject(ISynchronizeModelElement parent, SyncInfo info) {
        return this.createModelObject(parent, info.getLocal());
    }

    protected void addResource(SyncInfo info) {
        this.addResource(info.getLocal());
    }

    public static class HierarchicalModelProviderDescriptor
    implements ISynchronizeModelProviderDescriptor {
        public static final String ID = "org.eclipse.team.ui.modelprovider_hierarchical";

        public String getId() {
            return ID;
        }

        public String getName() {
            return TeamUIMessages.HierarchicalModelProvider_0;
        }

        public ImageDescriptor getImageDescriptor() {
            return TeamImages.getImageDescriptor("elcl16/hierarchicalLayout.gif");
        }
    }
}

