/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.plugins;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.project.BundleProjectService;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizard;
import org.eclipse.pde.internal.ui.wizards.imports.RepositoryImportWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ScmUrlImportDescription;
import org.eclipse.team.core.importing.provisional.IBundleImporter;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;

public class ImportActionGroup
extends ActionGroup {
    public void fillContextMenu(IMenuManager menu) {
        ActionContext context = this.getContext();
        ISelection selection = context.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            String menuName = null;
            menuName = sSelection.getFirstElement() instanceof IPluginExtension || sSelection.getFirstElement() instanceof IPluginExtensionPoint ? PDEUIMessages.ImportActionGroup_importContributingPlugin : PDEUIMessages.PluginsView_import;
            MenuManager importMenu = new MenuManager(menuName);
            importMenu.add((IAction)new ImportAction(1, sSelection));
            importMenu.add((IAction)new ImportAction(2, sSelection));
            importMenu.add((IAction)new ImportAction(3, sSelection));
            importMenu.add((IAction)new ImportAction(4, sSelection));
            menu.add((IContributionItem)importMenu);
        }
    }

    static void handleImport(int importType, IStructuredSelection selection) {
        ArrayList<IPluginModelBase> externalModels = new ArrayList<IPluginModelBase>();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IPluginModelBase model = ImportActionGroup.getModel(iter.next());
            if (model == null || model.getUnderlyingResource() != null) continue;
            externalModels.add(model);
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        IPluginModelBase[] models = externalModels.toArray(new IPluginModelBase[externalModels.size()]);
        if (importType == 4) {
            Map<IBundleImporter, ScmUrlImportDescription[]> importMap = ImportActionGroup.getImportDescriptions(display.getActiveShell(), models);
            if (importMap != null) {
                RepositoryImportWizard wizard = new RepositoryImportWizard(importMap);
                WizardDialog dialog = new WizardDialog(display.getActiveShell(), (IWizard)wizard);
                dialog.open();
            }
        } else {
            PluginImportWizard.doImportOperation(display.getActiveShell(), importType, models, false);
        }
    }

    private static Map<IBundleImporter, ScmUrlImportDescription[]> getImportDescriptions(Shell shell, IPluginModelBase[] models) {
        BundleProjectService service = (BundleProjectService)BundleProjectService.getDefault();
        try {
            Map descriptions = service.getImportDescriptions(models);
            if (!descriptions.isEmpty()) {
                return descriptions;
            }
            MessageDialog.openInformation((Shell)shell, (String)PDEUIMessages.ImportWizard_title, (String)PDEUIMessages.ImportActionGroup_cannot_import);
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
            MessageDialog.openError((Shell)shell, (String)PDEUIMessages.ImportWizard_title, (String)e.getMessage());
        }
        return null;
    }

    public static boolean canImport(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IPluginModelBase model = ImportActionGroup.getModel(iter.next());
            if (model == null || model.getUnderlyingResource() != null) continue;
            return true;
        }
        return false;
    }

    private static IPluginModelBase getModel(Object next) {
        IPackageFragmentRoot root;
        IPluginModelBase model = null;
        if (next instanceof IPluginModelBase) {
            model = (IPluginModelBase)next;
        } else if (next instanceof IPluginBase) {
            model = ((IPluginBase)next).getPluginModel();
        } else if (next instanceof IPluginExtension) {
            model = ((IPluginExtension)next).getPluginModel();
        } else if (next instanceof IPluginExtensionPoint) {
            model = ((IPluginExtensionPoint)next).getPluginModel();
        } else if (next instanceof BundleDescription) {
            model = PDECore.getDefault().getModelManager().findModel((BundleDescription)next);
        } else if (next instanceof BundleSpecification) {
            BundleDescription desc = (BundleDescription)((BundleSpecification)next).getSupplier();
            if (desc != null) {
                model = PDECore.getDefault().getModelManager().findModel(desc);
            }
        } else if (next instanceof IPackageFragmentRoot && (root = (IPackageFragmentRoot)next).isExternal()) {
            String path = root.getPath().toOSString();
            IPluginModelBase[] externalModels = PDECore.getDefault().getModelManager().getExternalModels();
            int i = 0;
            while (i < externalModels.length) {
                if (path.equals(externalModels[i].getInstallLocation())) {
                    return externalModels[i];
                }
                ++i;
            }
        }
        return model;
    }

    class ImportAction
    extends Action {
        IStructuredSelection fSel;
        int fImportType;

        ImportAction(int importType, IStructuredSelection selection) {
            this.fSel = selection;
            this.fImportType = importType;
            switch (this.fImportType) {
                case 1: {
                    this.setText(PDEUIMessages.PluginsView_asBinaryProject);
                    break;
                }
                case 2: {
                    this.setText(PDEUIMessages.ImportActionGroup_binaryWithLinkedContent);
                    break;
                }
                case 3: {
                    this.setText(PDEUIMessages.PluginsView_asSourceProject);
                    break;
                }
                case 4: {
                    this.setText(PDEUIMessages.ImportActionGroup_Repository_project);
                }
            }
        }

        public void run() {
            ImportActionGroup.handleImport(this.fImportType, this.fSel);
        }
    }
}

