/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.locale.AsciiUtil;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.UResourceBundleIterator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyTypeData {
    private static final Object[][] KEY_DATA = new Object[0][];
    private static final Map<String, KeyData> KEYMAP = new HashMap<String, KeyData>();

    static {
        KeyTypeData.initFromResourceBundle();
    }

    public static String toBcpKey(String key) {
        KeyData keyData = KEYMAP.get(key = AsciiUtil.toLowerString(key));
        if (keyData != null) {
            return keyData.bcpId;
        }
        return null;
    }

    public static String toLegacyKey(String key) {
        KeyData keyData = KEYMAP.get(key = AsciiUtil.toLowerString(key));
        if (keyData != null) {
            return keyData.legacyId;
        }
        return null;
    }

    public static String toBcpType(String key, String type, Output<Boolean> isKnownKey, Output<Boolean> isSpecialType) {
        if (isKnownKey != null) {
            isKnownKey.value = false;
        }
        if (isSpecialType != null) {
            isSpecialType.value = false;
        }
        key = AsciiUtil.toLowerString(key);
        type = AsciiUtil.toLowerString(type);
        KeyData keyData = KEYMAP.get(key);
        if (keyData != null) {
            Type t;
            if (isKnownKey != null) {
                isKnownKey.value = Boolean.TRUE;
            }
            if ((t = keyData.typeMap.get(type)) != null) {
                return t.bcpId;
            }
            if (keyData.specialTypes != null) {
                for (SpecialType st : keyData.specialTypes) {
                    if (!st.handler.isValid(type)) continue;
                    if (isSpecialType != null) {
                        isSpecialType.value = true;
                    }
                    return st.handler.canonicalize(type);
                }
            }
        }
        return null;
    }

    public static String toLegacyType(String key, String type, Output<Boolean> isKnownKey, Output<Boolean> isSpecialType) {
        if (isKnownKey != null) {
            isKnownKey.value = false;
        }
        if (isSpecialType != null) {
            isSpecialType.value = false;
        }
        key = AsciiUtil.toLowerString(key);
        type = AsciiUtil.toLowerString(type);
        KeyData keyData = KEYMAP.get(key);
        if (keyData != null) {
            Type t;
            if (isKnownKey != null) {
                isKnownKey.value = Boolean.TRUE;
            }
            if ((t = keyData.typeMap.get(type)) != null) {
                return t.legacyId;
            }
            if (keyData.specialTypes != null) {
                for (SpecialType st : keyData.specialTypes) {
                    if (!st.handler.isValid(type)) continue;
                    if (isSpecialType != null) {
                        isSpecialType.value = true;
                    }
                    return st.handler.canonicalize(type);
                }
            }
        }
        return null;
    }

    private static void initFromResourceBundle() {
        UResourceBundle keyTypeDataRes = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt54b", "keyTypeData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle keyMapRes = keyTypeDataRes.get("keyMap");
        UResourceBundle typeMapRes = keyTypeDataRes.get("typeMap");
        UResourceBundle typeAliasRes = null;
        UResourceBundle bcpTypeAliasRes = null;
        try {
            typeAliasRes = keyTypeDataRes.get("typeAlias");
        }
        catch (MissingResourceException missingResourceException) {}
        try {
            bcpTypeAliasRes = keyTypeDataRes.get("bcpTypeAlias");
        }
        catch (MissingResourceException missingResourceException) {}
        UResourceBundleIterator keyMapItr = keyMapRes.getIterator();
        while (keyMapItr.hasNext()) {
            UResourceBundle typeMapResByKey;
            HashSet<SpecialType> specialTypeSet;
            HashMap<String, Type> typeDataMap;
            HashMap<String, HashSet<String>> bcpTypeAliasMap;
            HashMap<String, HashSet<String>> typeAliasMap;
            boolean isTZ;
            boolean hasSameKey;
            String bcpKeyId;
            String legacyKeyId;
            block33: {
                UResourceBundle keyMapEntry = keyMapItr.next();
                legacyKeyId = keyMapEntry.getKey();
                bcpKeyId = keyMapEntry.getString();
                hasSameKey = false;
                if (bcpKeyId.length() == 0) {
                    bcpKeyId = legacyKeyId;
                    hasSameKey = true;
                }
                isTZ = legacyKeyId.equals("timezone");
                typeAliasMap = null;
                if (typeAliasRes != null) {
                    UResourceBundle typeAliasResByKey = null;
                    try {
                        typeAliasResByKey = typeAliasRes.get(legacyKeyId);
                    }
                    catch (MissingResourceException missingResourceException) {}
                    if (typeAliasResByKey != null) {
                        typeAliasMap = new HashMap<String, HashSet<String>>();
                        UResourceBundleIterator typeAliasResItr = typeAliasResByKey.getIterator();
                        while (typeAliasResItr.hasNext()) {
                            HashSet<String> aliasSet;
                            UResourceBundle typeAliasDataEntry = typeAliasResItr.next();
                            String from = typeAliasDataEntry.getKey();
                            String to = typeAliasDataEntry.getString();
                            if (isTZ) {
                                from = from.replace(':', '/');
                            }
                            if ((aliasSet = (HashSet<String>)typeAliasMap.get(to)) == null) {
                                aliasSet = new HashSet<String>();
                                typeAliasMap.put(to, aliasSet);
                            }
                            aliasSet.add(from);
                        }
                    }
                }
                bcpTypeAliasMap = null;
                if (bcpTypeAliasRes != null) {
                    UResourceBundle bcpTypeAliasResByKey = null;
                    try {
                        bcpTypeAliasResByKey = bcpTypeAliasRes.get(bcpKeyId);
                    }
                    catch (MissingResourceException missingResourceException) {}
                    if (bcpTypeAliasResByKey != null) {
                        bcpTypeAliasMap = new HashMap<String, HashSet<String>>();
                        UResourceBundleIterator bcpTypeAliasResItr = bcpTypeAliasResByKey.getIterator();
                        while (bcpTypeAliasResItr.hasNext()) {
                            UResourceBundle bcpTypeAliasDataEntry = bcpTypeAliasResItr.next();
                            String from = bcpTypeAliasDataEntry.getKey();
                            String to = bcpTypeAliasDataEntry.getString();
                            HashSet<String> aliasSet = (HashSet<String>)bcpTypeAliasMap.get(to);
                            if (aliasSet == null) {
                                aliasSet = new HashSet<String>();
                                bcpTypeAliasMap.put(to, aliasSet);
                            }
                            aliasSet.add(from);
                        }
                    }
                }
                typeDataMap = new HashMap<String, Type>();
                specialTypeSet = null;
                typeMapResByKey = null;
                try {
                    typeMapResByKey = typeMapRes.get(legacyKeyId);
                }
                catch (MissingResourceException missingResourceException) {
                    if ($assertionsDisabled) break block33;
                    throw new AssertionError();
                }
            }
            if (typeMapResByKey != null) {
                UResourceBundleIterator typeMapResByKeyItr = typeMapResByKey.getIterator();
                while (typeMapResByKeyItr.hasNext()) {
                    Set bcpTypeAliasSet;
                    Set typeAliasSet;
                    UResourceBundle typeMapEntry = typeMapResByKeyItr.next();
                    String legacyTypeId = typeMapEntry.getKey();
                    boolean isSpecialType = false;
                    SpecialType[] specialTypeArray = SpecialType.values();
                    int n = specialTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SpecialType st = specialTypeArray[n2];
                        if (legacyTypeId.equals(st.toString())) {
                            isSpecialType = true;
                            if (specialTypeSet == null) {
                                specialTypeSet = new HashSet<SpecialType>();
                            }
                            specialTypeSet.add(st);
                            break;
                        }
                        ++n2;
                    }
                    if (isSpecialType) continue;
                    if (isTZ) {
                        legacyTypeId = legacyTypeId.replace(':', '/');
                    }
                    String bcpTypeId = typeMapEntry.getString();
                    boolean hasSameType = false;
                    if (bcpTypeId.length() == 0) {
                        bcpTypeId = legacyTypeId;
                        hasSameType = true;
                    }
                    Type t = new Type(legacyTypeId, bcpTypeId);
                    typeDataMap.put(AsciiUtil.toLowerString(legacyTypeId), t);
                    if (!hasSameType) {
                        typeDataMap.put(AsciiUtil.toLowerString(bcpTypeId), t);
                    }
                    if (typeAliasMap != null && (typeAliasSet = (Set)typeAliasMap.get(legacyTypeId)) != null) {
                        for (String alias : typeAliasSet) {
                            typeDataMap.put(AsciiUtil.toLowerString(alias), t);
                        }
                    }
                    if (bcpTypeAliasMap == null || (bcpTypeAliasSet = (Set)bcpTypeAliasMap.get(bcpTypeId)) == null) continue;
                    for (String alias : bcpTypeAliasSet) {
                        typeDataMap.put(AsciiUtil.toLowerString(alias), t);
                    }
                }
            }
            EnumSet<SpecialType> specialTypes = null;
            if (specialTypeSet != null) {
                specialTypes = EnumSet.copyOf(specialTypeSet);
            }
            KeyData keyData = new KeyData(legacyKeyId, bcpKeyId, typeDataMap, specialTypes);
            KEYMAP.put(AsciiUtil.toLowerString(legacyKeyId), keyData);
            if (hasSameKey) continue;
            KEYMAP.put(AsciiUtil.toLowerString(bcpKeyId), keyData);
        }
    }

    private static void initFromTables() {
        Object[][] objectArray = KEY_DATA;
        int n = KEY_DATA.length;
        int n2 = 0;
        while (n2 < n) {
            Object from3;
            int n3;
            Object[] keyDataEntry = objectArray[n2];
            String legacyKeyId = (String)keyDataEntry[0];
            String bcpKeyId = (String)keyDataEntry[1];
            String[][] typeData = (String[][])keyDataEntry[2];
            String[][] typeAliasData = (String[][])keyDataEntry[3];
            String[][] bcpTypeAliasData = (String[][])keyDataEntry[4];
            boolean hasSameKey = false;
            if (bcpKeyId == null) {
                bcpKeyId = legacyKeyId;
                hasSameKey = true;
            }
            HashMap<String, HashSet<String[][]>> typeAliasMap = null;
            if (typeAliasData != null) {
                typeAliasMap = new HashMap<String, HashSet<String[][]>>();
                String[][] stringArray = typeAliasData;
                n3 = typeAliasData.length;
                int n4 = 0;
                while (n4 < n3) {
                    String[] typeAliasDataEntry = stringArray[n4];
                    from3 = typeAliasDataEntry[0];
                    String to = typeAliasDataEntry[1];
                    HashSet<String[][]> aliasSet = (HashSet<String[][]>)typeAliasMap.get(to);
                    if (aliasSet == null) {
                        aliasSet = new HashSet<String[][]>();
                        typeAliasMap.put(to, aliasSet);
                    }
                    aliasSet.add((String[][])from3);
                    ++n4;
                }
            }
            HashMap<String, HashSet<String>> bcpTypeAliasMap = null;
            if (bcpTypeAliasData != null) {
                bcpTypeAliasMap = new HashMap<String, HashSet<String>>();
                from3 = bcpTypeAliasData;
                int n5 = bcpTypeAliasData.length;
                n3 = 0;
                while (n3 < n5) {
                    String[] bcpTypeAliasDataEntry = from3[n3];
                    String from2 = bcpTypeAliasDataEntry[0];
                    String to = bcpTypeAliasDataEntry[1];
                    HashSet<String> aliasSet = (HashSet<String>)bcpTypeAliasMap.get(to);
                    if (aliasSet == null) {
                        aliasSet = new HashSet<String>();
                        bcpTypeAliasMap.put(to, aliasSet);
                    }
                    aliasSet.add(from2);
                    ++n3;
                }
            }
            assert (typeData != null);
            HashMap<String, Type> typeDataMap = new HashMap<String, Type>();
            HashSet<SpecialType> specialTypeSet = null;
            String[][] stringArray = typeData;
            int n6 = typeData.length;
            int from3 = 0;
            while (from3 < n6) {
                String[] typeDataEntry = stringArray[from3];
                String legacyTypeId = typeDataEntry[0];
                String bcpTypeId = typeDataEntry[1];
                boolean isSpecialType = false;
                SpecialType[] specialTypeArray = SpecialType.values();
                int n7 = specialTypeArray.length;
                int n8 = 0;
                while (n8 < n7) {
                    SpecialType st = specialTypeArray[n8];
                    if (legacyTypeId.equals(st.toString())) {
                        isSpecialType = true;
                        if (specialTypeSet == null) {
                            specialTypeSet = new HashSet<SpecialType>();
                        }
                        specialTypeSet.add(st);
                        break;
                    }
                    ++n8;
                }
                if (!isSpecialType) {
                    Set bcpTypeAliasSet;
                    Set typeAliasSet;
                    boolean hasSameType = false;
                    if (bcpTypeId == null) {
                        bcpTypeId = legacyTypeId;
                        hasSameType = true;
                    }
                    Type t = new Type(legacyTypeId, bcpTypeId);
                    typeDataMap.put(AsciiUtil.toLowerString(legacyTypeId), t);
                    if (!hasSameType) {
                        typeDataMap.put(AsciiUtil.toLowerString(bcpTypeId), t);
                    }
                    if ((typeAliasSet = (Set)typeAliasMap.get(legacyTypeId)) != null) {
                        for (String alias : typeAliasSet) {
                            typeDataMap.put(AsciiUtil.toLowerString(alias), t);
                        }
                    }
                    if ((bcpTypeAliasSet = (Set)bcpTypeAliasMap.get(bcpTypeId)) != null) {
                        for (String alias : bcpTypeAliasSet) {
                            typeDataMap.put(AsciiUtil.toLowerString(alias), t);
                        }
                    }
                }
                ++from3;
            }
            EnumSet<SpecialType> specialTypes = null;
            if (specialTypeSet != null) {
                specialTypes = EnumSet.copyOf(specialTypeSet);
            }
            KeyData keyData = new KeyData(legacyKeyId, bcpKeyId, typeDataMap, specialTypes);
            KEYMAP.put(AsciiUtil.toLowerString(legacyKeyId), keyData);
            if (!hasSameKey) {
                KEYMAP.put(AsciiUtil.toLowerString(bcpKeyId), keyData);
            }
            ++n2;
        }
    }

    private static class CodepointsTypeHandler
    extends SpecialTypeHandler {
        private static final Pattern pat = Pattern.compile("[0-9a-fA-F]{4,6}(-[0-9a-fA-F]{4,6})*");

        private CodepointsTypeHandler() {
        }

        boolean isValid(String value) {
            return pat.matcher(value).matches();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyData {
        String legacyId;
        String bcpId;
        Map<String, Type> typeMap;
        EnumSet<SpecialType> specialTypes;

        KeyData(String legacyId, String bcpId, Map<String, Type> typeMap, EnumSet<SpecialType> specialTypes) {
            this.legacyId = legacyId;
            this.bcpId = bcpId;
            this.typeMap = typeMap;
            this.specialTypes = specialTypes;
        }
    }

    private static class ReorderCodeTypeHandler
    extends SpecialTypeHandler {
        private static final Pattern pat = Pattern.compile("[a-zA-Z]{3,8}(-[a-zA-Z]{3,8})*");

        private ReorderCodeTypeHandler() {
        }

        boolean isValid(String value) {
            return pat.matcher(value).matches();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SpecialType {
        CODEPOINTS(new CodepointsTypeHandler()),
        REORDER_CODE(new ReorderCodeTypeHandler());

        SpecialTypeHandler handler;

        private SpecialType(SpecialTypeHandler handler) {
            this.handler = handler;
        }
    }

    private static abstract class SpecialTypeHandler {
        private SpecialTypeHandler() {
        }

        abstract boolean isValid(String var1);

        String canonicalize(String value) {
            return AsciiUtil.toLowerString(value);
        }
    }

    private static class Type {
        String legacyId;
        String bcpId;

        Type(String legacyId, String bcpId) {
            this.legacyId = legacyId;
            this.bcpId = bcpId;
        }
    }
}

