/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.search.JavaSearchPageScoreComputer;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.search.ui.ISearchPageScoreComputer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorInputAdapterFactory
implements IAdapterFactory {
    private static Class<?>[] PROPERTIES = new Class[]{IJavaElement.class};
    private Object fSearchPageScoreComputer;

    public Class<?>[] getAdapterList() {
        this.updateLazyLoadedAdapters();
        return PROPERTIES;
    }

    public <T> T getAdapter(Object element, Class<T> key) {
        this.updateLazyLoadedAdapters();
        if (this.fSearchPageScoreComputer != null && ISearchPageScoreComputer.class.equals(key) && element instanceof IEditorInput && JavaUI.getEditorInputJavaElement((IEditorInput)element) != null) {
            return (T)this.fSearchPageScoreComputer;
        }
        if (IJavaElement.class.equals(key) && element instanceof IEditorInput) {
            ICompilationUnit je = JavaUI.getWorkingCopyManager().getWorkingCopy((IEditorInput)element);
            if (je != null) {
                return (T)je;
            }
            if (element instanceof IStorageEditorInput) {
                try {
                    return (T)((IStorageEditorInput)element).getStorage().getAdapter(key);
                }
                catch (CoreException coreException) {}
            }
        }
        return null;
    }

    private void updateLazyLoadedAdapters() {
        if (this.fSearchPageScoreComputer == null && SearchUtil.isSearchPlugInActivated()) {
            this.createSearchPageScoreComputer();
        }
    }

    private void createSearchPageScoreComputer() {
        this.fSearchPageScoreComputer = new JavaSearchPageScoreComputer();
        PROPERTIES = new Class[]{ISearchPageScoreComputer.class, IJavaElement.class};
    }
}

