/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.remote.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.rcptt.internal.launching.remote.ui.Activator;
import org.eclipse.rcptt.internal.launching.remote.ui.RemoteAUTMainTab;
import org.eclipse.rcptt.launching.Q7LaunchUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class AUTArgumentsBlock {
    private RemoteAUTMainTab fTab;
    private Text eclPortField;
    private Text teslaPortField;
    private Text hostField;
    ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AUTArgumentsBlock.this.fTab.scheduleUpdateJob();
        }
    };

    public AUTArgumentsBlock(RemoteAUTMainTab tab) {
        this.fTab = tab;
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        String locationLabel = "&Remote Application Under Test (AUT)";
        group.setText(locationLabel);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        Label l = new Label((Composite)group, 64);
        l.setText("Host:");
        this.hostField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.hostField.setLayoutData((Object)gridData);
        this.hostField.addModifyListener(this.listener);
        l = new Label((Composite)group, 64);
        l.setText("ECL port:");
        this.eclPortField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.eclPortField.setLayoutData((Object)gridData);
        this.eclPortField.addModifyListener(this.listener);
        l = new Label((Composite)group, 64);
        l.setText("Tesla port:");
        this.teslaPortField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.teslaPortField.setLayoutData((Object)gridData);
        this.teslaPortField.addModifyListener(this.listener);
        VerifyListener verity = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                char[] cArray = e.text.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (!Character.isDigit(c)) {
                        e.doit = false;
                    }
                    ++n2;
                }
            }
        };
        this.eclPortField.addVerifyListener(verity);
        this.teslaPortField.addVerifyListener(verity);
    }

    public String validate() {
        final String[] hostName = new String[1];
        final int[] port = new int[1];
        if (this.hostField != null && !this.hostField.isDisposed()) {
            this.hostField.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    hostName[0] = AUTArgumentsBlock.this.getHostName();
                    port[0] = AUTArgumentsBlock.this.getECLPort();
                }
            });
            if (hostName[0] == null || hostName[0].trim().length() == 0) {
                return "Please specify Remote AUT host...";
            }
            try {
                Q7LaunchUtils.verifyConnection((String)hostName[0], (int)port[0]);
            }
            catch (CoreException coreException) {
                return "AUT connection is not available...";
            }
        }
        return null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        try {
            config.setAttribute("org.eclipse.rcptt.launching.HOST", this.hostField.getText());
            config.setAttribute("org.eclipse.rcptt.launching.TESLA_PORT_ATTR", Integer.valueOf(this.teslaPortField.getText()).intValue());
        }
        catch (NumberFormatException numberFormatException) {}
        config.setAttribute("org.eclipse.rcptt.launching.ECL_PORT_ATTR", this.getECLPort().intValue());
    }

    private Integer getECLPort() {
        try {
            return Integer.valueOf(this.eclPortField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private String getHostName() {
        return this.hostField.getText();
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.eclPortField.setText(this.getValue(config, "org.eclipse.rcptt.launching.ECL_PORT_ATTR"));
        this.teslaPortField.setText(this.getValue(config, "org.eclipse.rcptt.launching.TESLA_PORT_ATTR"));
        try {
            this.hostField.setText(config.getAttribute("org.eclipse.rcptt.launching.HOST", ""));
        }
        catch (CoreException coreException) {}
    }

    private String getValue(ILaunchConfiguration config, String attr) {
        String location = null;
        try {
            location = Integer.toString(config.getAttribute(attr, 0));
        }
        catch (CoreException e) {
            Activator.getDefault().log(e);
        }
        return location;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.rcptt.launching.TESLA_PORT_ATTR", 7926);
        config.setAttribute("org.eclipse.rcptt.launching.ECL_PORT_ATTR", 5378);
        config.setAttribute("org.eclipse.rcptt.launching.HOST", "localhost");
    }
}

