/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.jface.text;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.rcptt.util.WeakMap;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JFaceTextManager {
    private static WeakMap<StyledText, TextViewer> viewersMap = new WeakMap();
    private static WeakMap<Canvas, IVerticalRuler> rulersMap = new WeakMap();
    private static WeakMap<IVerticalRuler, ITextViewer> rulersViewerMap = new WeakMap();
    private static Set<WeakReference<AbstractHoverInformationControlManager>> hoverManagers = new HashSet<WeakReference<AbstractHoverInformationControlManager>>();
    private static final WeakReference<AbstractHoverInformationControlManager>[] EMPTY_MANAGERS = new WeakReference[0];

    private JFaceTextManager() {
    }

    public static void mapViewer(StyledText text, TextViewer viewer) {
        viewersMap.put((Object)text, (Object)viewer);
    }

    public static TextViewer getViewer(StyledText widget) {
        return (TextViewer)viewersMap.get((Object)widget);
    }

    public static void mapRuler(IVerticalRuler ruler, Control widget, ITextViewer viewer) {
        if (widget instanceof Canvas) {
            rulersMap.put((Object)((Canvas)widget), (Object)ruler);
            rulersViewerMap.put((Object)ruler, (Object)viewer);
        }
    }

    public static List<IVerticalRuler> getRulers() {
        return new ArrayList<IVerticalRuler>(rulersMap.values());
    }

    public static ITextViewer getViewer(IVerticalRuler ruler) {
        return (ITextViewer)rulersViewerMap.get((Object)ruler);
    }

    public static void registerHoverManager(AbstractHoverInformationControlManager manager) {
        hoverManagers.add(new WeakReference<AbstractHoverInformationControlManager>(manager));
    }

    public static List<AbstractHoverInformationControlManager> isSomeHoverManagerActive() {
        WeakReference<AbstractHoverInformationControlManager>[] managers = hoverManagers.toArray(EMPTY_MANAGERS);
        ArrayList<AbstractHoverInformationControlManager> results = new ArrayList<AbstractHoverInformationControlManager>();
        WeakReference<AbstractHoverInformationControlManager>[] weakReferenceArray = managers;
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            WeakReference<AbstractHoverInformationControlManager> r = weakReferenceArray[n2];
            AbstractHoverInformationControlManager m = (AbstractHoverInformationControlManager)r.get();
            if (m == null) {
                hoverManagers.remove(r);
            } else if (m.getClass().getName().equals("org.eclipse.jface.text.TextViewerHoverManager")) {
                try {
                    Thread thread;
                    Field field = m.getClass().getDeclaredField("fThread");
                    field.setAccessible(true);
                    Object value = field.get(m);
                    if (value instanceof Thread && (thread = (Thread)value).getState() != Thread.State.TERMINATED) {
                        results.add(m);
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return results;
    }
}

