/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.wizards;

import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.ui.discovery.util.GradientCanvas;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.AbstractDiscoveryItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryItem<T extends CatalogCategory>
extends AbstractDiscoveryItem<T> {
    public CategoryItem(Composite parent, int style, DiscoveryResources resources, T category) {
        super(parent, style, resources, category);
        this.createContent(category);
    }

    protected boolean hasTooltip(CatalogCategory category) {
        return category.getOverview() != null && category.getOverview().getSummary() != null && category.getOverview().getSummary().length() > 0;
    }

    private void createContent(T category) {
        this.setLayout((Layout)new FillLayout());
        GradientCanvas categoryHeaderContainer = new GradientCanvas(this, 0);
        categoryHeaderContainer.setSeparatorVisible(true);
        categoryHeaderContainer.setSeparatorAlignment(128);
        categoryHeaderContainer.setBackgroundGradient(new Color[]{this.resources.getGradientBeginColor(), this.resources.getGradientEndColor()}, new int[]{100}, true);
        categoryHeaderContainer.putColor(GradientCanvas.H_BOTTOM_KEYLINE1, this.resources.getGradientBeginColor());
        categoryHeaderContainer.putColor(GradientCanvas.H_BOTTOM_KEYLINE2, this.resources.getGradientEndColor());
        GridLayoutFactory.fillDefaults().numColumns(3).margins(5, 5).equalWidth(false).applyTo((Composite)categoryHeaderContainer);
        Label iconLabel = new Label((Composite)categoryHeaderContainer, 0);
        if (category.getIcon() != null) {
            iconLabel.setImage(this.resources.getIconImage(category.getSource(), category.getIcon(), 48, true));
        }
        iconLabel.setBackground(null);
        GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 2).applyTo((Control)iconLabel);
        Label nameLabel = new Label((Composite)categoryHeaderContainer, 0);
        nameLabel.setFont(this.resources.getHeaderFont());
        nameLabel.setText(category.getName());
        nameLabel.setBackground(null);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)nameLabel);
        if (this.hasTooltip((CatalogCategory)category)) {
            ToolBar toolBar = new ToolBar((Composite)categoryHeaderContainer, 0x800000);
            toolBar.setBackground(null);
            ToolItem infoButton = new ToolItem(toolBar, 8);
            infoButton.setImage(this.resources.getInfoImage());
            infoButton.setToolTipText(Messages.ConnectorDiscoveryWizardMainPage_tooltip_showOverview);
            this.hookTooltip((Control)toolBar, (Widget)infoButton, (Control)categoryHeaderContainer, (Control)nameLabel, category.getSource(), category.getOverview(), null);
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
        } else {
            new Label((Composite)categoryHeaderContainer, 0).setText(" ");
        }
        if (category.getDescription() != null) {
            Label description = new Label((Composite)categoryHeaderContainer, 64);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(100, -1).applyTo((Control)description);
            description.setBackground(null);
            description.setText(category.getDescription());
        }
    }

    @Override
    protected void refresh() {
    }
}

