/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.services;

import javax.inject.Inject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.adapter.Adapter;

public class EclipseAdapter
extends Adapter {
    private IAdapterManager adapterManager;
    private IEclipseContext context;

    @Inject
    public EclipseAdapter(IEclipseContext context) {
        this.context = context;
    }

    @Override
    public <T> T adapt(Object element, Class<T> adapterType) {
        IAdaptable adaptable;
        Object result;
        Assert.isNotNull(adapterType);
        if (element == null) {
            return null;
        }
        if (adapterType.isInstance(element)) {
            return (T)element;
        }
        if (element instanceof IAdaptable && (result = (adaptable = (IAdaptable)element).getAdapter(adapterType)) != null) {
            Assert.isTrue((boolean)adapterType.isInstance(result));
            return (T)result;
        }
        if (this.adapterManager == null) {
            this.adapterManager = this.lookupAdapterManager();
        }
        if (this.adapterManager == null) {
            return null;
        }
        Object result2 = this.adapterManager.loadAdapter(element, adapterType.getName());
        if (result2 != null) {
            Assert.isTrue((boolean)adapterType.isInstance(result2));
            return (T)result2;
        }
        return null;
    }

    private IAdapterManager lookupAdapterManager() {
        return (IAdapterManager)this.context.get(IAdapterManager.class.getName());
    }
}

