/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.internal.InternalPolicy;
import org.eclipse.jface.util.BaseTextDirectionSegmentListener;
import org.eclipse.jface.util.StructuredTextSegmentListener;
import org.eclipse.jface.util.VisualTextDirectionSegmentListener;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SegmentEvent;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public final class BidiUtils {
    public static final String LEFT_TO_RIGHT = "ltr";
    public static final String RIGHT_TO_LEFT = "rtl";
    public static final String AUTO = "auto";
    public static final String BTD_DEFAULT = "default";
    public static final String VISUAL_LEFT_TO_RIGHT = "visualltr";
    public static final String VISUAL_RIGHT_TO_LEFT = "visualrtl";
    private static final SegmentListener BASE_TEXT_DIRECTION_LTR = new BaseTextDirectionSegmentListener("ltr");
    private static final SegmentListener BASE_TEXT_DIRECTION_RTL = new BaseTextDirectionSegmentListener("rtl");
    private static final SegmentListener BASE_TEXT_DIRECTION_AUTO = new BaseTextDirectionSegmentListener("auto");
    private static final SegmentListener VISUAL_TEXT_DIRECTION_LTR = new VisualTextDirectionSegmentListener("visualltr");
    private static final SegmentListener VISUAL_TEXT_DIRECTION_RTL = new VisualTextDirectionSegmentListener("visualrtl");
    private static final Map<String, SegmentListener> structuredTextSegmentListeners = new HashMap<String, SegmentListener>();
    static final char LRE = '\u202a';
    static final char LRM = '\u200e';
    static final char PDF = '\u202c';
    static final char RLE = '\u202b';
    static final char LRO = '\u202d';
    static final char RLO = '\u202e';
    private static boolean bidiSupport = false;
    private static String textDirection = "";

    private BidiUtils() {
    }

    public static String getTextDirection() {
        return textDirection;
    }

    public static void setTextDirection(String direction) {
        if (!(direction == null || LEFT_TO_RIGHT.equals(direction) || RIGHT_TO_LEFT.equals(direction) || AUTO.equals(direction))) {
            throw new IllegalArgumentException(direction);
        }
        textDirection = direction;
    }

    public static boolean getBidiSupport() {
        return bidiSupport;
    }

    public static void setBidiSupport(boolean bidi) {
        bidiSupport = bidi;
    }

    public static void applyBidiProcessing(Text field, String handlingType) {
        SegmentListener listener = BidiUtils.getSegmentListener(handlingType);
        if (listener != null) {
            field.addSegmentListener(listener);
            if (InternalPolicy.DEBUG_BIDI_UTILS) {
                int color = 0;
                color = LEFT_TO_RIGHT.equals(handlingType) ? 3 : (RIGHT_TO_LEFT.equals(handlingType) ? 5 : (BTD_DEFAULT.equals(handlingType) ? 7 : (AUTO.equals(handlingType) ? 11 : 13)));
                field.setBackground(field.getDisplay().getSystemColor(color));
                if (field.getMessage().length() == 0) {
                    field.setMessage(String.valueOf('<') + handlingType + '>');
                }
                if (field.getToolTipText() == null) {
                    field.setToolTipText(String.valueOf('<') + handlingType + '>');
                }
            }
        }
    }

    public static void applyBidiProcessing(StyledText field, String handlingType) {
        final SegmentListener listener = BidiUtils.getSegmentListener(handlingType);
        if (listener != null) {
            field.addBidiSegmentListener(new BidiSegmentListener(){

                public void lineGetSegments(BidiSegmentEvent event) {
                    listener.getSegments((SegmentEvent)event);
                }
            });
        }
    }

    public static void applyBidiProcessing(Combo combo, String handlingType) {
        SegmentListener listener = BidiUtils.getSegmentListener(handlingType);
        if (listener != null) {
            combo.addSegmentListener(listener);
            if (InternalPolicy.DEBUG_BIDI_UTILS) {
                int color = 0;
                color = LEFT_TO_RIGHT.equals(handlingType) ? 3 : (RIGHT_TO_LEFT.equals(handlingType) ? 5 : (BTD_DEFAULT.equals(handlingType) ? 7 : (AUTO.equals(handlingType) ? 11 : 13)));
                combo.setBackground(combo.getDisplay().getSystemColor(color));
                if (combo.getToolTipText() == null) {
                    combo.setToolTipText(String.valueOf('<') + handlingType + '>');
                }
            }
        }
    }

    public static SegmentListener getSegmentListener(String handlingType) {
        SegmentListener listener = null;
        if (LEFT_TO_RIGHT.equals(handlingType)) {
            listener = BASE_TEXT_DIRECTION_LTR;
        } else if (RIGHT_TO_LEFT.equals(handlingType)) {
            listener = BASE_TEXT_DIRECTION_RTL;
        } else if (AUTO.equals(handlingType)) {
            listener = BASE_TEXT_DIRECTION_AUTO;
        } else if (BidiUtils.getBidiSupport()) {
            if (BTD_DEFAULT.equals(handlingType)) {
                if (LEFT_TO_RIGHT.equals(BidiUtils.getTextDirection())) {
                    listener = BASE_TEXT_DIRECTION_LTR;
                } else if (RIGHT_TO_LEFT.equals(BidiUtils.getTextDirection())) {
                    listener = BASE_TEXT_DIRECTION_RTL;
                } else if (AUTO.equals(BidiUtils.getTextDirection())) {
                    listener = BASE_TEXT_DIRECTION_AUTO;
                }
            } else if (VISUAL_LEFT_TO_RIGHT.equals(handlingType)) {
                listener = VISUAL_TEXT_DIRECTION_LTR;
            } else if (VISUAL_RIGHT_TO_LEFT.equals(handlingType)) {
                listener = VISUAL_TEXT_DIRECTION_RTL;
            } else {
                SegmentListener handler = structuredTextSegmentListeners.get(handlingType);
                if (handler != null) {
                    listener = handler;
                } else {
                    listener = new StructuredTextSegmentListener(handlingType);
                    structuredTextSegmentListeners.put(handlingType, listener);
                }
            }
        }
        return listener;
    }

    public static void applyTextDirection(Control control, String textDirection) {
        int textDir = 0;
        if (LEFT_TO_RIGHT.equals(textDirection)) {
            textDir = 0x2000000;
        } else if (RIGHT_TO_LEFT.equals(textDirection)) {
            textDir = 0x4000000;
        } else if (AUTO.equals(textDirection)) {
            textDir = 0x6000000;
        } else if (BidiUtils.getBidiSupport() && BTD_DEFAULT.equals(textDirection)) {
            if (LEFT_TO_RIGHT.equals(BidiUtils.getTextDirection())) {
                textDir = 0x2000000;
            } else if (RIGHT_TO_LEFT.equals(BidiUtils.getTextDirection())) {
                textDir = 0x4000000;
            } else if (AUTO.equals(BidiUtils.getTextDirection())) {
                textDir = 0x6000000;
            }
        }
        if (control instanceof Text && textDir != 0) {
            BidiUtils.applyBidiProcessing((Text)control, textDirection);
        } else if (control instanceof StyledText && textDir != 0) {
            BidiUtils.applyBidiProcessing((StyledText)control, textDirection);
        } else if (control instanceof Combo && textDir != 0) {
            BidiUtils.applyBidiProcessing((Combo)control, textDirection);
        } else if (textDir != 0) {
            control.setTextDirection(textDir);
        }
    }
}

