/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.SuperContext;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.core.workspace.WorkspaceFinder;
import org.eclipse.rcptt.internal.core.RcpttPlugin;

public class SuperContextSupport {
    public static List<ContextConfiguration> findContextVariants(List<IContext> superContexts, IContext[] orderedContexts) {
        ArrayList<ContextConfiguration> configs = new ArrayList<ContextConfiguration>();
        List<Variant> variants = SuperContextSupport.extractVariants(superContexts);
        ArrayList<IContext> orderedList = new ArrayList<IContext>(Arrays.asList(orderedContexts));
        int[] currentConfig = new int[variants.size()];
        int i = 0;
        while (i < currentConfig.length) {
            currentConfig[i] = 0;
            ++i;
        }
        do {
            try {
                ContextConfiguration cfg = new ContextConfiguration();
                cfg.contexts = new ArrayList<IContext>(orderedList);
                cfg.name = new ArrayList<String>();
                int i2 = 0;
                while (i2 < currentConfig.length) {
                    Variant var = variants.get(i2);
                    int ind = cfg.contexts.indexOf(var.context);
                    IContext varContext = var.childs.get(currentConfig[i2]);
                    cfg.contexts.set(ind, varContext);
                    cfg.name.add(varContext.getElementName());
                    ++i2;
                }
                configs.add(cfg);
            }
            catch (ModelException e) {
                RcpttPlugin.log((Throwable)((Object)e));
            }
        } while (SuperContextSupport.increaseConfig(currentConfig, variants));
        return configs;
    }

    public static boolean increaseConfig(int[] currentConfig, List<Variant> variants) {
        int i = 0;
        while (i < currentConfig.length) {
            if (currentConfig[i] + 1 < variants.get((int)i).childs.size()) {
                int n = i;
                currentConfig[n] = currentConfig[n] + 1;
                return true;
            }
            currentConfig[i] = 0;
            ++i;
        }
        return false;
    }

    private static List<Variant> extractVariants(List<IContext> superContexts) {
        ArrayList<Variant> variants = new ArrayList<Variant>();
        WorkspaceFinder finder = WorkspaceFinder.getInstance();
        for (IContext superCtx : superContexts) {
            try {
                SuperContext sElement = (SuperContext)superCtx.getNamedElement();
                EList list = sElement.getContextReferences();
                ArrayList<IContext> contextChilds = new ArrayList<IContext>();
                for (String s : list) {
                    IContext result = RcpttCore.getInstance().findContext(superCtx, false, s, finder);
                    if (result == null) continue;
                    contextChilds.add(result);
                }
                if (contextChilds.size() <= 0) continue;
                Variant var = new Variant();
                var.context = superCtx;
                var.childs = contextChilds;
                variants.add(var);
            }
            catch (ModelException e) {
                RcpttPlugin.log((Throwable)((Object)e));
            }
        }
        return variants;
    }

    public static List<IContext> findSuperContexts(IContext[] contexts) {
        ArrayList<IContext> ctxs = new ArrayList<IContext>();
        IContext[] iContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IContext iContext = iContextArray[n2];
            try {
                NamedElement element = iContext.getNamedElement();
                if (element instanceof SuperContext) {
                    ctxs.add(iContext);
                }
            }
            catch (Exception e) {
                RcpttPlugin.log(e);
            }
            ++n2;
        }
        return ctxs;
    }

    public static class ContextConfiguration {
        List<String> name;
        List<IContext> contexts;

        public IContext[] getContexts() {
            if (this.contexts == null) {
                return new IContext[0];
            }
            return this.contexts.toArray(new IContext[this.contexts.size()]);
        }

        public List<String> getVariantName() {
            return this.name;
        }
    }

    private static class Variant {
        IContext context;
        List<IContext> childs;

        private Variant() {
        }
    }
}

