/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.ui.handlers.HandlerUtil;

public class GeneratePomAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource[] resources = LaunchUtils.getContext(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (resources.length == 0) {
            return null;
        }
        IProject project = resources[0].getProject();
        IFile pomFile = project.getFile("pom.xml");
        try {
            pomFile.refreshLocal(0, null);
            if (!pomFile.exists()) {
                pomFile.create(((Object)((Object)this)).getClass().getResourceAsStream("pom.xml"), true, null);
            } else {
                MessageDialog.openError(null, (String)"Error generating POM file", (String)String.format("pom.xml already exists in project '%s'", project.getName()));
            }
        }
        catch (CoreException e) {
            throw new ExecutionException("Error creating pom.xml", (Throwable)e);
        }
        return null;
    }
}

