/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext;

import com.google.common.base.Strings;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public final class PDELocationUtils {
    private static final String CONFIGURATION_FOLDER = "configuration";
    private static final String PLUGINS_FOLDER = "plugins";
    private static final String PRODUCT_PATH_IN_E4_OSX = "Contents/Eclipse";

    public static File getPluginFolder(String location) throws CoreException {
        IStatus status;
        Path path = new Path(location);
        File plugin = null;
        plugin = PLUGINS_FOLDER.equals(path.lastSegment()) ? path.toFile() : path.append(PLUGINS_FOLDER).toFile();
        if (!plugin.exists() && Platform.getOS().equals("macosx")) {
            plugin = PDELocationUtils.getOSXProductE4Folder((IPath)path).append(PLUGINS_FOLDER).toFile();
        }
        if ((status = PDELocationUtils.validateDirectoryPath(plugin)).isOK()) {
            return plugin;
        }
        throw new CoreException(status);
    }

    public static File getProductLocation(String location) throws CoreException {
        IStatus status;
        Path path = new Path(location);
        File pluginDir = path.append(PLUGINS_FOLDER).toFile();
        if (!pluginDir.exists() && Platform.getOS().equals("macosx")) {
            path = PDELocationUtils.getOSXProductE4Folder((IPath)path);
        }
        if ((status = PDELocationUtils.validateProductLocation(path.toString())).isOK()) {
            return path.toFile();
        }
        throw new CoreException(status);
    }

    public static IStatus validateProductLocation(String location) {
        IStatus status;
        if (Strings.isNullOrEmpty((String)location) || location.trim().length() == 0) {
            return new Status(4, "org.eclipse.rcptt.launching.ext", "AUT instalation directory is not set.");
        }
        Path productPath = new Path(location);
        File pluginDir = productPath.append(PLUGINS_FOLDER).toFile();
        if (!pluginDir.exists() && Platform.getOS().equals("macosx")) {
            productPath = PDELocationUtils.getOSXProductE4Folder((IPath)productPath);
        }
        if (!(status = PDELocationUtils.validateDirectoryPath(productPath.toFile())).isOK()) {
            return status;
        }
        status = PDELocationUtils.validateDirectoryPath(productPath.append(PLUGINS_FOLDER).toFile());
        if (!status.isOK()) {
            return status;
        }
        status = PDELocationUtils.validateDirectoryPath(productPath.append(CONFIGURATION_FOLDER).toFile());
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    private static IStatus validateDirectoryPath(File file) {
        if (file == null || !file.exists()) {
            return new Status(4, "org.eclipse.rcptt.launching.ext", "Directory \"" + (file != null ? file.getPath() : "null") + "\" does not exist.");
        }
        if (!file.isDirectory()) {
            return new Status(4, "org.eclipse.rcptt.launching.ext", "The specified path \"" + file.getPath() + "\" is not a directory.");
        }
        if (!file.canRead()) {
            return new Status(4, "org.eclipse.rcptt.launching.ext", "Cannot read directory \"" + file.getPath() + "\": Permission denied");
        }
        return Status.OK_STATUS;
    }

    private static IPath getOSXProductE4Folder(IPath path) {
        IPath plugin = path.append(PRODUCT_PATH_IN_E4_OSX);
        return plugin;
    }
}

