/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.scanner.ScannerMessages;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SystemApiDescriptionProcessor {
    private SystemApiDescriptionProcessor() {
    }

    public static String serializeComponentXml(File location) {
        block18: {
            if (location.exists()) {
                try {
                    String extension = IPath.fromOSString((String)location.getName()).getFileExtension();
                    if (extension != null && extension.equals("jar") && location.isFile()) {
                        Throwable throwable = null;
                        Object var3_6 = null;
                        try (ZipFile jarFile = new ZipFile(location, 1);){
                            ZipEntry manifestEntry = jarFile.getEntry("system.api_description");
                            if (manifestEntry != null) {
                                byte[] allBytes = jarFile.getInputStream(manifestEntry).readAllBytes();
                                return new String(allBytes, StandardCharsets.UTF_8);
                            }
                            break block18;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    if (location.isDirectory()) {
                        File file = new File(location, "system.api_description");
                        if (file.exists()) {
                            return Files.readString(file.toPath());
                        }
                    } else if (location.isFile() && location.getName().equals("system.api_description")) {
                        return Files.readString(location.toPath());
                    }
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        return null;
    }

    private static void abort(String message, Throwable exception) throws CoreException {
        IStatus status = Status.error((String)message, (Throwable)exception);
        throw new CoreException(status);
    }

    public static void annotateApiSettings(IApiDescription settings, String xml) throws CoreException {
        Element root = null;
        try {
            root = Util.parseDocument(xml);
        }
        catch (CoreException ce) {
            SystemApiDescriptionProcessor.abort("Failed to parse API description xml file", ce);
        }
        if (!root.getNodeName().equals("component")) {
            SystemApiDescriptionProcessor.abort(ScannerMessages.ComponentXMLScanner_0, null);
        }
        NodeList packages = root.getElementsByTagName("package");
        NodeList types = null;
        IPackageDescriptor packdesc = null;
        Element type = null;
        int i = 0;
        while (i < packages.getLength()) {
            Element pkg = (Element)packages.item(i);
            String pkgName = pkg.getAttribute("name");
            packdesc = Factory.packageDescriptor(pkgName);
            SystemApiDescriptionProcessor.annotateDescriptor(settings, packdesc, pkg);
            types = pkg.getElementsByTagName("type");
            int j = 0;
            while (j < types.getLength()) {
                type = (Element)types.item(j);
                String name = type.getAttribute("name");
                if (name.length() == 0) {
                    SystemApiDescriptionProcessor.abort("Missing type name", null);
                }
                IReferenceTypeDescriptor typedesc = packdesc.getType(name);
                SystemApiDescriptionProcessor.annotateDescriptor(settings, typedesc, type);
                SystemApiDescriptionProcessor.annotateMethodSettings(settings, typedesc, type);
                SystemApiDescriptionProcessor.annotateFieldSettings(settings, typedesc, type);
                ++j;
            }
            ++i;
        }
    }

    private static void annotateDescriptor(IApiDescription settings, IElementDescriptor descriptor, Element element) {
        settings.setVisibility(descriptor, 1);
        settings.setRestrictions(descriptor, 0);
        settings.setAddedProfile(descriptor, SystemApiDescriptionProcessor.retrieveElementAttribute(element, "addedprofile"));
        settings.setRemovedProfile(descriptor, SystemApiDescriptionProcessor.retrieveElementAttribute(element, "removedprofile"));
        settings.setSuperclass(descriptor, SystemApiDescriptionProcessor.retrieveStringElementAttribute(element, "sc"));
        settings.setSuperinterfaces(descriptor, SystemApiDescriptionProcessor.retrieveStringElementAttribute(element, "sis"));
        settings.setInterface(descriptor, SystemApiDescriptionProcessor.retrieveBooleanElementAttribute(element, "int"));
    }

    private static int retrieveElementAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        if (value.length() > 0) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    private static String retrieveStringElementAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        if (value.length() > 0) {
            return value;
        }
        return null;
    }

    private static boolean retrieveBooleanElementAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        if (value.length() > 0) {
            return Boolean.toString(true).equals(value);
        }
        return false;
    }

    private static void annotateFieldSettings(IApiDescription settings, IReferenceTypeDescriptor typedesc, Element type) throws CoreException {
        NodeList fields = type.getElementsByTagName("field");
        Element field = null;
        IFieldDescriptor fielddesc = null;
        String name = null;
        int i = 0;
        while (i < fields.getLength()) {
            field = (Element)fields.item(i);
            name = field.getAttribute("name");
            if (name == null) {
                SystemApiDescriptionProcessor.abort(ScannerMessages.ComponentXMLScanner_1, null);
            }
            fielddesc = typedesc.getField(name);
            SystemApiDescriptionProcessor.annotateDescriptor(settings, fielddesc, field);
            ++i;
        }
    }

    private static void annotateMethodSettings(IApiDescription settings, IReferenceTypeDescriptor typedesc, Element type) throws CoreException {
        NodeList methods = type.getElementsByTagName("method");
        Element method = null;
        IMethodDescriptor methoddesc = null;
        int i = 0;
        while (i < methods.getLength()) {
            String signature;
            method = (Element)methods.item(i);
            String name = method.getAttribute("name");
            if (name == null) {
                SystemApiDescriptionProcessor.abort(ScannerMessages.ComponentXMLScanner_2, null);
            }
            if ((signature = method.getAttribute("signature")) == null) {
                SystemApiDescriptionProcessor.abort(ScannerMessages.ComponentXMLScanner_3, null);
            }
            methoddesc = typedesc.getMethod(name, signature);
            SystemApiDescriptionProcessor.annotateDescriptor(settings, methoddesc, method);
            ++i;
        }
    }
}

