/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.InterruptibleVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class SwitchFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit) {
        ArrayList<SwitchFixOperation> operations = new ArrayList<SwitchFixOperation>();
        SwitchStatementsFinder finder = new SwitchStatementsFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new SwitchFixCore(FixMessages.SwitchFix_convert_if_to_switch, compilationUnit, ops);
    }

    protected SwitchFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static final class SwitchCaseSection {
        private final List<Expression> literalExpressions;
        private final List<Statement> statements;

        private SwitchCaseSection(List<Expression> literalExpressions, List<Statement> statements) {
            this.literalExpressions = literalExpressions;
            this.statements = statements;
        }
    }

    public static class SwitchFixOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final List<IfStatement> ifStatements;
        private final Expression switchExpression;
        private final List<SwitchCaseSection> cases;
        private final Statement remainingStatement;

        public SwitchFixOperation(List<IfStatement> ifStatements, Expression switchExpression, List<SwitchCaseSection> cases, Statement remainingStatement) {
            this.ifStatements = ifStatements;
            this.switchExpression = switchExpression;
            this.cases = cases;
            this.remainingStatement = remainingStatement;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.CodeStyleCleanUp_Switch_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            SwitchStatement switchStatement = ast.newSwitchStatement();
            switchStatement.setExpression(ASTNodes.createMoveTarget(rewrite, this.switchExpression));
            for (SwitchCaseSection aCase : this.cases) {
                this.addCaseWithStatements(rewrite, ast, switchStatement, aCase.literalExpressions, aCase.statements);
            }
            if (this.remainingStatement != null) {
                this.addCaseWithStatements(rewrite, ast, switchStatement, null, ASTNodes.asList(this.remainingStatement));
            } else {
                this.addCaseWithStatements(rewrite, ast, switchStatement, null, Collections.emptyList());
            }
            int i = 0;
            while (i < this.ifStatements.size() - 1) {
                ASTNodes.removeButKeepComment(rewrite, (ASTNode)this.ifStatements.get(i), group);
                ++i;
            }
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.ifStatements.get(this.ifStatements.size() - 1), (ASTNode)switchStatement, group);
        }

        private void addCaseWithStatements(ASTRewrite rewrite, AST ast, SwitchStatement switchStatement, List<Expression> caseValuesOrNullForDefault, List<Statement> innerStatements) {
            List switchStatements = switchStatement.statements();
            if (caseValuesOrNullForDefault != null && !caseValuesOrNullForDefault.isEmpty()) {
                for (Expression caseValue : caseValuesOrNullForDefault) {
                    SwitchCase newSwitchCase = ast.newSwitchCase();
                    newSwitchCase.expressions().add(ASTNodes.createMoveTarget(rewrite, caseValue));
                    switchStatements.add(newSwitchCase);
                }
            } else {
                switchStatements.add(ast.newSwitchCase());
            }
            List statementsList = switchStatement.statements();
            boolean isBreakNeeded = true;
            boolean needBlock = this.checkForLocalDeclarations(innerStatements);
            Block block = null;
            if (needBlock) {
                block = ast.newBlock();
                statementsList = block.statements();
            }
            if (!innerStatements.isEmpty()) {
                for (Statement statement : innerStatements) {
                    statementsList.add(ASTNodes.createMoveTarget(rewrite, statement));
                }
                boolean bl = isBreakNeeded = !ASTNodes.fallsThrough(innerStatements.get(innerStatements.size() - 1));
            }
            if (isBreakNeeded) {
                statementsList.add(ast.newBreakStatement());
            }
            if (needBlock) {
                switchStatements.add(block);
            }
        }

        private boolean checkForLocalDeclarations(List<Statement> statements) {
            for (Statement statement : statements) {
                if (!(statement instanceof VariableDeclarationStatement)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class SwitchStatementsFinder
    extends ASTVisitor {
        private List<SwitchFixOperation> fResult;

        public SwitchStatementsFinder(List<SwitchFixOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(Block visited) {
            SeveralIfVisitor severalIfVisitor = new SeveralIfVisitor(visited);
            visited.accept((ASTVisitor)severalIfVisitor);
            return severalIfVisitor.result;
        }

        final class HasUnlabeledBreakVisitor
        extends InterruptibleVisitor {
            boolean hasUnlabeledBreak = false;

            HasUnlabeledBreakVisitor() {
            }

            public boolean visit(BreakStatement node) {
                if (node.getLabel() == null) {
                    this.hasUnlabeledBreak = true;
                    return this.interruptVisit();
                }
                return true;
            }

            public boolean visit(EnhancedForStatement visited) {
                return false;
            }

            public boolean visit(ForStatement visited) {
                return false;
            }

            public boolean visit(SwitchStatement visited) {
                return false;
            }

            public boolean visit(WhileStatement visited) {
                return false;
            }

            public boolean visit(DoStatement visited) {
                return false;
            }
        }

        final class SeveralIfVisitor
        extends ASTVisitor {
            private final Block startNode;
            private boolean result = true;

            public SeveralIfVisitor(Block startNode) {
                this.startNode = startNode;
            }

            public boolean visit(Block visited) {
                return this.startNode == visited;
            }

            public boolean visit(IfStatement visited) {
                if (!this.result || this.hasUnlabeledBreak(visited)) {
                    return true;
                }
                Variable variable = this.extractVariableAndValues((Statement)visited);
                if (variable == null) {
                    return true;
                }
                Expression switchExpression = variable.name;
                ArrayList<IfStatement> ifStatements = new ArrayList<IfStatement>();
                ArrayList<SwitchCaseSection> cases = new ArrayList<SwitchCaseSection>();
                Statement remainingStatement = null;
                IfStatement ifStatement = visited;
                boolean isFallingThrough = true;
                do {
                    IfStatement currentNode = ifStatement;
                    while (ASTNodes.isSameVariable((ASTNode)switchExpression, (ASTNode)variable.name)) {
                        cases.add(new SwitchCaseSection(variable.constantValues, ASTNodes.asList(currentNode.getThenStatement())));
                        if (!ASTNodes.fallsThrough(currentNode.getThenStatement())) {
                            isFallingThrough = false;
                        }
                        if ((remainingStatement = currentNode.getElseStatement()) == null || (variable = this.extractVariableAndValues(remainingStatement)) == null) break;
                        currentNode = (IfStatement)remainingStatement;
                    }
                    ifStatements.add(ifStatement);
                    ifStatement = ASTNodes.as(ASTNodes.getNextSibling((Statement)ifStatement), IfStatement.class);
                    variable = this.extractVariableAndValues((Statement)ifStatement);
                } while (isFallingThrough && ifStatement != null && !this.hasUnlabeledBreak(ifStatement) && remainingStatement == null && variable != null && ASTNodes.isSameVariable((ASTNode)switchExpression, (ASTNode)variable.name));
                List<SwitchCaseSection> filteredCases = this.filterDuplicateCaseValues(cases);
                return this.maybeReplaceWithSwitchStatement(ifStatements, switchExpression, filteredCases, remainingStatement);
            }

            private boolean maybeReplaceWithSwitchStatement(List<IfStatement> ifStatements, Expression switchExpression, List<SwitchCaseSection> cases, Statement remainingStatement) {
                if (switchExpression != null && cases.size() > 2) {
                    SwitchStatementsFinder.this.fResult.add(new SwitchFixOperation(ifStatements, switchExpression, cases, remainingStatement));
                    this.result = false;
                    return false;
                }
                return true;
            }

            private boolean hasUnlabeledBreak(IfStatement node) {
                HasUnlabeledBreakVisitor hasUnlabeledBreakVisitor = new HasUnlabeledBreakVisitor();
                hasUnlabeledBreakVisitor.traverseNodeInterruptibly((ASTNode)node);
                return hasUnlabeledBreakVisitor.hasUnlabeledBreak;
            }

            private List<SwitchCaseSection> filterDuplicateCaseValues(List<SwitchCaseSection> sourceCases) {
                ArrayList<SwitchCaseSection> results = new ArrayList<SwitchCaseSection>();
                HashSet<Object> alreadyProccessedValues = new HashSet<Object>();
                for (SwitchCaseSection sourceCase : sourceCases) {
                    ArrayList<Expression> filteredExprs = new ArrayList<Expression>();
                    for (Expression expression : sourceCase.literalExpressions) {
                        Object constantValue = expression.resolveConstantExpressionValue();
                        if (!alreadyProccessedValues.add(constantValue)) continue;
                        filteredExprs.add(expression);
                    }
                    if (filteredExprs.isEmpty()) continue;
                    results.add(new SwitchCaseSection(filteredExprs, sourceCase.statements));
                }
                return results;
            }

            private Variable extractVariableAndValues(Statement statement) {
                if (statement instanceof IfStatement) {
                    return this.extractVariableAndValues(((IfStatement)statement).getExpression());
                }
                return null;
            }

            private Variable extractVariableAndValues(Expression expression) {
                InfixExpression infixExpression = ASTNodes.as(expression, InfixExpression.class);
                if (infixExpression != null) {
                    return this.extractVariableAndValuesFromInfixExpression(infixExpression);
                }
                return null;
            }

            private Variable extractVariableAndValuesFromInfixExpression(InfixExpression infixExpression) {
                if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.CONDITIONAL_OR, InfixExpression.Operator.OR, InfixExpression.Operator.XOR)) {
                    List<Expression> operands = ASTNodes.allOperands(infixExpression);
                    Variable mergedVariable = null;
                    for (Expression operand : operands) {
                        Variable variable = this.extractVariableAndValues(operand);
                        if (variable == null) {
                            return null;
                        }
                        if (mergedVariable == null) {
                            mergedVariable = variable;
                            continue;
                        }
                        if (mergedVariable.isSameVariable(variable)) {
                            mergedVariable = mergedVariable.mergeValues(variable);
                            continue;
                        }
                        return null;
                    }
                    return mergedVariable;
                }
                if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.EQUALS, new InfixExpression.Operator[0]) && !infixExpression.hasExtendedOperands()) {
                    Expression rightOperand;
                    Expression leftOperand = infixExpression.getLeftOperand();
                    Variable variable = this.extractVariableWithConstantValue(leftOperand, rightOperand = infixExpression.getRightOperand());
                    return variable != null ? variable : this.extractVariableWithConstantValue(rightOperand, leftOperand);
                }
                return null;
            }

            private Variable extractVariableWithConstantValue(Expression variable, Expression constant) {
                if ((variable instanceof Name || variable instanceof FieldAccess || variable instanceof SuperFieldAccess) && ASTNodes.hasType(variable, Character.TYPE.getCanonicalName(), Byte.TYPE.getCanonicalName(), Short.TYPE.getCanonicalName(), Integer.TYPE.getCanonicalName()) && constant.resolveTypeBinding() != null && constant.resolveTypeBinding().isPrimitive() && constant.resolveConstantExpressionValue() != null) {
                    return new Variable(variable, Arrays.asList(constant));
                }
                return null;
            }
        }

        static final class Variable {
            private final Expression name;
            private final List<Expression> constantValues;

            private Variable(Expression firstOp, List<Expression> constantValues) {
                this.name = firstOp;
                this.constantValues = constantValues;
            }

            private boolean isSameVariable(Variable other) {
                return other != null && ASTNodes.isSameVariable((ASTNode)this.name, (ASTNode)other.name);
            }

            private Variable mergeValues(Variable other) {
                ArrayList<Expression> values = new ArrayList<Expression>(this.constantValues);
                values.addAll(other.constantValues);
                return new Variable(this.name, values);
            }
        }
    }
}

