/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.deltas;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rcptt.core.model.IParent;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementDelta;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7Status;
import org.eclipse.rcptt.internal.core.model.Openable;
import org.eclipse.rcptt.internal.core.model.Q7Element;
import org.eclipse.rcptt.internal.core.model.Q7ElementInfo;
import org.eclipse.rcptt.internal.core.model.Q7Model;
import org.eclipse.rcptt.internal.core.model.Q7ResourceInfo;
import org.eclipse.rcptt.internal.core.model.deltas.Q7ElementDelta;

public class Q7ElementDeltaBuilder {
    IQ7Element modelElement;
    int maxDepth = Integer.MAX_VALUE;
    Map infos;
    Map oldPositions;
    Map newPositions;
    public Q7ElementDelta delta;
    ArrayList added;
    ArrayList removed;

    public Q7ElementDeltaBuilder(IQ7Element modelElement) throws InterruptedException {
        this.modelElement = modelElement;
        this.initialize();
        this.recordElementInfo(modelElement, (Q7Model)this.modelElement.getModel(), 0);
    }

    public Q7ElementDeltaBuilder(IQ7Element modelElement, int maxDepth) throws InterruptedException {
        this.modelElement = modelElement;
        this.maxDepth = maxDepth;
        this.initialize();
        this.recordElementInfo(modelElement, (Q7Model)this.modelElement.getModel(), 0);
    }

    private void added(IQ7Element element) {
        this.added.add(element);
        ListItem current = this.getNewPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getNewPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getNewPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    public void buildDeltas() throws InterruptedException {
        this.delta = new Q7ElementDelta(this.modelElement);
        if (this.modelElement.getElementType().equals((Object)IQ7Element.HandleType.Context) || this.modelElement.getElementType().equals((Object)IQ7Element.HandleType.Verification) || this.modelElement.getElementType().equals((Object)IQ7Element.HandleType.TestCase) || this.modelElement.getElementType().equals((Object)IQ7Element.HandleType.TestSuite)) {
            this.delta.fineGrained();
        }
        this.recordNewPositions(this.modelElement, 0);
        this.findAdditions(this.modelElement, 0);
        this.findDeletions();
        this.findChangesInPositioning(this.modelElement, 0);
        this.trimDelta(this.delta);
        if (this.delta.getAffectedChildren().length == 0) {
            this.delta.contentChanged();
        }
    }

    private void findAdditions(IQ7Element newElement, int depth) throws InterruptedException {
        IQ7Element[] children;
        Q7ElementInfo newInfo;
        Q7ElementInfo oldInfo = this.getElementInfo(newElement);
        if (oldInfo == null && depth < this.maxDepth) {
            this.delta.added(newElement);
            this.added(newElement);
        } else {
            this.removeElementInfo(newElement);
        }
        if (depth >= this.maxDepth) {
            this.delta.changed(newElement, 1);
            return;
        }
        try {
            newInfo = this.leakInfo(newElement);
        }
        catch (FileNotFoundException e) {
            return;
        }
        this.findContentChange(oldInfo, newInfo, newElement);
        if (oldInfo != null && newElement instanceof IParent && (children = newInfo.getChildren()) != null) {
            int length = children.length;
            int i = 0;
            while (i < length) {
                this.findAdditions(children[i], depth + 1);
                ++i;
            }
        }
    }

    private Q7ElementInfo leakInfo(IQ7Element newElement) throws InterruptedException, FileNotFoundException {
        Q7ElementInfo newInfo;
        try {
            ((Openable)newElement.getOpenable()).openAndAccessInfo(parentInfo -> null, null);
            newInfo = ((Q7Element)newElement).accessInfo(info -> info);
        }
        catch (ModelException e) {
            if (e.getQ7Status().getStatusCode() == Q7Status.Q7StatusCode.NotPressent) {
                throw new FileNotFoundException();
            }
            throw new IllegalStateException((Throwable)((Object)e));
        }
        return newInfo;
    }

    private void findChangesInPositioning(IQ7Element element, int depth) throws InterruptedException {
        if (depth >= this.maxDepth || this.added.contains(element) || this.removed.contains(element)) {
            return;
        }
        if (!this.isPositionedCorrectly(element)) {
            this.delta.changed(element, 256);
        }
        if (element instanceof IParent) {
            Q7ElementInfo info;
            try {
                info = this.leakInfo(element);
            }
            catch (FileNotFoundException e) {
                return;
            }
            IQ7Element[] children = info.getChildren();
            if (children != null) {
                int length = children.length;
                int i = 0;
                while (i < length) {
                    this.findChangesInPositioning(children[i], depth + 1);
                    ++i;
                }
            }
        }
    }

    private void findContentChange(Q7ElementInfo oldInfo, Q7ElementInfo newInfo, IQ7Element newElement) {
        if (oldInfo instanceof Q7ResourceInfo && newInfo instanceof Q7ResourceInfo) {
            this.delta.changed(newElement, 1);
        }
    }

    private void findDeletions() {
        for (IQ7Element element : this.infos.keySet()) {
            this.delta.removed(element);
            this.removed(element);
        }
    }

    private Q7ElementInfo getElementInfo(IQ7Element element) {
        return (Q7ElementInfo)this.infos.get(element);
    }

    private ListItem getNewPosition(IQ7Element element) {
        return (ListItem)this.newPositions.get(element);
    }

    private ListItem getOldPosition(IQ7Element element) {
        return (ListItem)this.oldPositions.get(element);
    }

    private void initialize() {
        this.infos = new HashMap(20);
        this.oldPositions = new HashMap(20);
        this.newPositions = new HashMap(20);
        this.putOldPosition(this.modelElement, new ListItem(null, null));
        this.putNewPosition(this.modelElement, new ListItem(null, null));
        this.added = new ArrayList(5);
        this.removed = new ArrayList(5);
    }

    private void insertPositions(IQ7Element[] elements, boolean isNew) {
        int length = elements.length;
        IQ7Element previous = null;
        IQ7Element current = null;
        IQ7Element next = length > 0 ? elements[0] : null;
        int i = 0;
        while (i < length) {
            previous = current;
            current = next;
            IQ7Element iQ7Element = next = i + 1 < length ? elements[i + 1] : null;
            if (isNew) {
                this.putNewPosition(current, new ListItem(previous, next));
            } else {
                this.putOldPosition(current, new ListItem(previous, next));
            }
            ++i;
        }
    }

    private boolean isPositionedCorrectly(IQ7Element element) {
        ListItem oldListItem = this.getOldPosition(element);
        if (oldListItem == null) {
            return false;
        }
        ListItem newListItem = this.getNewPosition(element);
        if (newListItem == null) {
            return false;
        }
        IQ7Element oldPrevious = oldListItem.previous;
        IQ7Element newPrevious = newListItem.previous;
        if (oldPrevious == null) {
            return newPrevious == null;
        }
        return oldPrevious.equals(newPrevious);
    }

    private void putElementInfo(IQ7Element element, Q7ElementInfo info) {
        this.infos.put(element, info);
    }

    private void putNewPosition(IQ7Element element, ListItem position) {
        this.newPositions.put(element, position);
    }

    private void putOldPosition(IQ7Element element, ListItem position) {
        this.oldPositions.put(element, position);
    }

    private void recordElementInfo(IQ7Element element, Q7Model model, int depth) throws InterruptedException {
        IQ7Element[] children;
        Q7ElementInfo info;
        if (depth >= this.maxDepth) {
            return;
        }
        try {
            ((Openable)element.getOpenable()).openAndAccessInfo(parentInfo -> null, null);
            info = ((Q7Element)element).accessInfo(info1 -> info1);
            assert (info != null);
        }
        catch (ModelException e1) {
            if (e1.getStatus() instanceof Q7Status && ((Q7Status)e1.getStatus()).getStatusCode() == Q7Status.Q7StatusCode.NotPressent) {
                return;
            }
            throw new RuntimeException((Throwable)((Object)e1));
        }
        this.putElementInfo(element, info);
        if (element instanceof IParent && (children = info.getChildren()) != null) {
            this.insertPositions(children, false);
            int i = 0;
            int length = children.length;
            while (i < length) {
                this.recordElementInfo(children[i], model, depth + 1);
                ++i;
            }
        }
    }

    private void recordNewPositions(IQ7Element newElement, int depth) throws InterruptedException {
        if (depth < this.maxDepth && newElement instanceof IParent) {
            Q7ElementInfo info;
            try {
                info = this.leakInfo(newElement);
            }
            catch (FileNotFoundException e) {
                return;
            }
            IQ7Element[] children = info.getChildren();
            if (children != null) {
                this.insertPositions(children, true);
                int i = 0;
                int length = children.length;
                while (i < length) {
                    this.recordNewPositions(children[i], depth + 1);
                    ++i;
                }
            }
        }
    }

    private void removed(IQ7Element element) {
        this.removed.add(element);
        ListItem current = this.getOldPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getOldPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getOldPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    private void removeElementInfo(IQ7Element element) {
        this.infos.remove(element);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Built delta:\n");
        buffer.append(this.delta.toString());
        return buffer.toString();
    }

    private void trimDelta(Q7ElementDelta elementDelta) {
        if (elementDelta.getKind() == 2) {
            IQ7ElementDelta[] children = elementDelta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                elementDelta.removeAffectedChild((Q7ElementDelta)children[i]);
                ++i;
            }
        } else {
            IQ7ElementDelta[] children = elementDelta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                this.trimDelta((Q7ElementDelta)children[i]);
                ++i;
            }
        }
    }

    static class ListItem {
        public IQ7Element previous;
        public IQ7Element next;

        public ListItem(IQ7Element previous, IQ7Element next) {
            this.previous = previous;
            this.next = next;
        }
    }
}

