/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.resources;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rap.rwt.internal.resources.ResourceDirectory;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.internal.util.StreamUtil;
import org.eclipse.rap.rwt.service.ResourceLoader;
import org.eclipse.rap.rwt.service.ResourceManager;

public class ResourceManagerImpl
implements ResourceManager {
    private final ResourceDirectory resourceDirectory;
    private final Set<String> resources;

    public ResourceManagerImpl(ResourceDirectory resourceDirectory) {
        this.resourceDirectory = resourceDirectory;
        this.resources = Collections.synchronizedSet(new HashSet());
    }

    public void registerOnce(String resource, ResourceLoader loader) {
        ParamCheck.notNull(resource, "resource");
        ParamCheck.notNull(loader, "loader");
        if (!this.resources.contains(resource)) {
            ResourceManagerImpl.checkPath(resource);
            InputStream stream = null;
            try {
                try {
                    stream = loader.getResourceAsStream(resource);
                    this.internalRegister(resource, stream);
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Failed to register resource: " + resource, ioe);
                }
            }
            finally {
                if (stream != null) {
                    StreamUtil.close(stream);
                }
            }
        }
    }

    @Override
    public void register(String path, InputStream inputStream) {
        ParamCheck.notNull(path, "name");
        ParamCheck.notNull(inputStream, "inputStream");
        ResourceManagerImpl.checkPath(path);
        this.internalRegister(path, inputStream);
    }

    @Override
    public boolean unregister(String name) {
        ParamCheck.notNull(name, "name");
        boolean result = false;
        if (this.resources.remove(name)) {
            result = true;
            File file = this.getDiskLocation(name);
            file.delete();
        }
        return result;
    }

    @Override
    public boolean isRegistered(String name) {
        ParamCheck.notNull(name, "name");
        return this.resources.contains(name);
    }

    @Override
    public String getLocation(String name) {
        ParamCheck.notNull(name, "name");
        if (!this.resources.contains(name)) {
            throw new IllegalArgumentException("Resource does not exist: " + name);
        }
        return this.createRequestUrl(name);
    }

    @Override
    public InputStream getRegisteredContent(String name) {
        ParamCheck.notNull(name, "name");
        FileInputStream result = null;
        if (this.resources.contains(name)) {
            File file = this.getDiskLocation(name);
            try {
                result = new FileInputStream(file);
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException(fnfe);
            }
        }
        return result;
    }

    private String createRequestUrl(String resourceName) {
        String newFileName = resourceName.replace('\\', '/');
        StringBuilder url = new StringBuilder();
        url.append("rwt-resources");
        url.append("/");
        String escapedResourceNamea = ResourceManagerImpl.escapeResourceName(newFileName);
        url.append(escapedResourceNamea);
        return url.toString();
    }

    private void internalRegister(String name, InputStream inputStream) {
        File location = this.getDiskLocation(name);
        try {
            ResourceManagerImpl.createDirectories(location);
            ResourceManagerImpl.writeResource(inputStream, location);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to register resource: " + name, ioe);
        }
        this.resources.add(name);
    }

    private static void writeResource(InputStream inputStream, File location) throws IOException {
        BufferedInputStream bufferedStream = new BufferedInputStream(inputStream);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(location));){
            byte[] buffer = new byte[256];
            int read = bufferedStream.read(buffer);
            while (read != -1) {
                ((OutputStream)outputStream).write(buffer, 0, read);
                read = bufferedStream.read(buffer);
            }
        }
    }

    private static void createDirectories(File file) throws IOException {
        File dir = new File(file.getParent());
        if (!dir.mkdirs() && !dir.exists()) {
            throw new IOException("Could not create directory structure: " + dir.getAbsolutePath());
        }
    }

    private File getDiskLocation(String resourceName) {
        String escapedResourceName = ResourceManagerImpl.escapeResourceName(resourceName);
        return new File(this.resourceDirectory.getDirectory(), escapedResourceName);
    }

    private static void checkPath(String path) {
        if (path.length() == 0) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        if (path.endsWith("/") || path.endsWith("\\")) {
            throw new IllegalArgumentException("Path must not end with path separator");
        }
    }

    private static String escapeResourceName(String name) {
        String result = name;
        result = name.replaceAll("\\$", "\\$\\$");
        result = result.replaceAll(":", "\\$1");
        result = result.replaceAll("\\?", "\\$2");
        return result;
    }
}

