/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.internal;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExampleContribution;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.examples.internal.Examples;
import org.eclipse.rap.examples.internal.Navigation;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.application.AbstractEntryPoint;
import org.eclipse.rap.rwt.client.service.BrowserNavigation;
import org.eclipse.rap.rwt.client.service.BrowserNavigationEvent;
import org.eclipse.rap.rwt.client.service.BrowserNavigationListener;
import org.eclipse.rap.rwt.client.service.JavaScriptExecutor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public class MainUi
extends AbstractEntryPoint {
    private static final String RAP_PAGE_URL = "http://eclipse.org/rap/";
    private static final int CONTENT_MIN_HEIGHT = 800;
    private static final int HEADER_HEIGHT = 140;
    private static final int CENTER_AREA_WIDTH = 998;
    private Composite centerArea;
    private Navigation navigation;
    private Composite navBar;

    protected Shell createShell(Display display) {
        Shell shell = super.createShell(display);
        shell.setData("org.eclipse.rap.rwt.customVariant", (Object)"mainshell");
        return shell;
    }

    protected void createContents(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        ScrolledComposite scrolledArea = this.createScrolledArea(parent);
        Composite content = this.createContent(scrolledArea);
        scrolledArea.setContent((Control)content);
        this.attachHistoryListener();
        this.selectInitialContribution();
        this.removeSplash();
    }

    private void attachHistoryListener() {
        BrowserNavigation history = (BrowserNavigation)RWT.getClient().getService(BrowserNavigation.class);
        if (history != null) {
            history.addBrowserNavigationListener(new BrowserNavigationListener(){

                public void navigated(BrowserNavigationEvent event) {
                    Examples examples = Examples.getInstance();
                    IExampleContribution contribution = examples.getContribution(event.getState());
                    if (contribution != null) {
                        MainUi.this.selectContribution(contribution);
                    }
                }
            });
        }
    }

    private void selectInitialContribution() {
        IExampleContribution contribution = Examples.getInstance().findInitialContribution();
        if (contribution != null) {
            this.selectContribution(contribution);
        }
    }

    private void removeSplash() {
        JavaScriptExecutor executor = (JavaScriptExecutor)RWT.getClient().getService(JavaScriptExecutor.class);
        if (executor != null) {
            executor.execute("document.body.removeChild( document.getElementById( \"splash\" ) );");
        }
    }

    private ScrolledComposite createScrolledArea(Composite parent) {
        ScrolledComposite scrolledComp = new ScrolledComposite(parent, 768);
        scrolledComp.setMinHeight(800);
        scrolledComp.setMinWidth(998);
        scrolledComp.setExpandVertical(true);
        scrolledComp.setExpandHorizontal(true);
        return scrolledComp;
    }

    private Composite createContent(ScrolledComposite scrolledArea) {
        Composite comp = new Composite((Composite)scrolledArea, 0);
        comp.setLayout((Layout)new FormLayout());
        Composite header = this.createHeader(comp);
        header.setLayoutData((Object)this.createHeaderFormData());
        this.createContentBody(comp, header);
        return comp;
    }

    private Composite createHeader(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setData("org.eclipse.rap.rwt.customVariant", (Object)"header");
        comp.setBackgroundMode(1);
        comp.setLayout((Layout)new FormLayout());
        Composite headerCenterArea = this.createHeaderCenterArea(comp);
        this.createLogo(headerCenterArea);
        this.createTitle(headerCenterArea);
        return comp;
    }

    private FormData createHeaderFormData() {
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 140;
        return data;
    }

    private Composite createHeaderCenterArea(Composite parent) {
        Composite headerCenterArea = new Composite(parent, 0);
        headerCenterArea.setLayout((Layout)new FormLayout());
        headerCenterArea.setLayoutData((Object)this.createHeaderCenterAreaFormData());
        return headerCenterArea;
    }

    private FormData createHeaderCenterAreaFormData() {
        FormData data = new FormData();
        data.left = new FormAttachment(50, -499);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.width = 998;
        return data;
    }

    private void createLogo(Composite headerComp) {
        Label logoLabel = new Label(headerComp, 0);
        Image rapLogo = MainUi.getImage(headerComp.getDisplay(), "RAP-logo.png");
        logoLabel.setImage(rapLogo);
        logoLabel.setLayoutData((Object)MainUi.createLogoFormData(rapLogo));
        MainUi.makeLink(logoLabel, RAP_PAGE_URL);
    }

    private void createTitle(Composite headerComp) {
        Label title = new Label(headerComp, 0);
        title.setText("Demo");
        title.setLayoutData((Object)MainUi.createTitleFormData());
        title.setData("org.eclipse.rap.rwt.customVariant", (Object)"title");
    }

    private void createContentBody(Composite parent, Composite header) {
        Composite composite = new Composite(parent, 0);
        composite.setData("org.eclipse.rap.rwt.customVariant", (Object)"mainContentArea");
        composite.setLayout((Layout)new FormLayout());
        composite.setLayoutData((Object)this.createContentBodyFormData(header));
        this.navigation = this.createNavigation(composite);
        Composite footer = this.createFooter(composite);
        this.centerArea = this.createCenterArea(composite, footer);
    }

    private Composite createCenterArea(Composite parent, Composite footer) {
        Composite centerArea = new Composite(parent, 0);
        centerArea.setLayout((Layout)new FillLayout());
        centerArea.setLayoutData((Object)this.createCenterAreaFormData(footer));
        centerArea.setData("org.eclipse.rap.rwt.customVariant", (Object)"centerArea");
        return centerArea;
    }

    private FormData createCenterAreaFormData(Composite footer) {
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.navBar, 0, 1024);
        data.bottom = new FormAttachment((Control)footer, 0, 128);
        data.left = new FormAttachment(50, -509);
        data.width = 1008;
        return data;
    }

    private Composite createFooter(Composite contentComposite) {
        Composite footer = new Composite(contentComposite, 0);
        footer.setBackgroundMode(1);
        footer.setLayout((Layout)new FormLayout());
        footer.setData("org.eclipse.rap.rwt.customVariant", (Object)"footer");
        footer.setLayoutData((Object)this.createFooterFormData());
        Label label = new Label(footer, 0);
        label.setData("org.eclipse.rap.rwt.customVariant", (Object)"footerLabel");
        label.setText("RAP version: " + MainUi.getRapVersion());
        label.setLayoutData((Object)this.createFooterLabelFormData(footer));
        return footer;
    }

    private FormData createFooterFormData() {
        FormData data = new FormData();
        data.left = new FormAttachment(50, -499);
        data.top = new FormAttachment(100, -40);
        data.bottom = new FormAttachment(100);
        data.width = 986;
        return data;
    }

    private FormData createFooterLabelFormData(Composite footer) {
        FormData data = new FormData();
        data.top = new FormAttachment(50, -10);
        data.right = new FormAttachment(100, -15);
        return data;
    }

    private FormData createContentBodyFormData(Composite header) {
        FormData data = new FormData();
        data.top = new FormAttachment((Control)header, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    private Navigation createNavigation(Composite parent) {
        this.navBar = new Composite(parent, 0);
        this.navBar.setLayout((Layout)new FormLayout());
        this.navBar.setLayoutData((Object)MainUi.createNavBarFormData());
        this.navBar.setData("org.eclipse.rap.rwt.customVariant", (Object)"nav-bar");
        Navigation navigation = new Navigation(this.navBar){

            @Override
            protected void selectContribution(IExampleContribution contribution) {
                MainUi.this.selectContribution(contribution);
            }
        };
        Control navigationControl = navigation.getControl();
        navigationControl.setLayoutData((Object)MainUi.createNavigationFormData());
        navigationControl.setData("org.eclipse.rap.rwt.customVariant", (Object)"navigation");
        return navigation;
    }

    private void selectContribution(IExampleContribution contribution) {
        this.navigation.selectNavigationEntry(contribution);
        this.activate(contribution);
    }

    private void activate(IExampleContribution contribution) {
        IExamplePage examplePage = contribution.createPage();
        if (examplePage != null) {
            Control[] children;
            BrowserNavigation history = (BrowserNavigation)RWT.getClient().getService(BrowserNavigation.class);
            if (history != null) {
                history.pushState(contribution.getId(), contribution.getTitle());
            }
            Control[] controlArray = children = this.centerArea.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
            Composite contentComp = ExampleUtil.initPage(contribution.getTitle(), this.centerArea);
            examplePage.createControl(contentComp);
            this.centerArea.layout(true, true);
        }
    }

    private static FormData createLogoFormData(Image rapLogo) {
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        int logoHeight = rapLogo.getBounds().height;
        data.top = new FormAttachment(50, -(logoHeight / 2));
        return data;
    }

    private static FormData createTitleFormData() {
        FormData data = new FormData();
        data.bottom = new FormAttachment(100, -26);
        data.left = new FormAttachment(0, 250);
        return data;
    }

    private static FormData createNavBarFormData() {
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        return data;
    }

    private static FormData createNavigationFormData() {
        FormData data = new FormData();
        data.left = new FormAttachment(50, -506);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.width = 998;
        return data;
    }

    public static Image getImage(Display display, String path) {
        ClassLoader classLoader = MainUi.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("resources/" + path);
        Image result = null;
        if (inputStream != null) {
            try {
                result = new Image((Device)display, inputStream);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private static String getRapVersion() {
        Version version = FrameworkUtil.getBundle(RWT.class).getVersion();
        StringBuilder resultBuffer = new StringBuilder(20);
        resultBuffer.append(version.getMajor());
        resultBuffer.append('.');
        resultBuffer.append(version.getMinor());
        resultBuffer.append('.');
        resultBuffer.append(version.getMicro());
        resultBuffer.append(" (Build ");
        resultBuffer.append(version.getQualifier());
        resultBuffer.append(')');
        return resultBuffer.toString();
    }

    private static void makeLink(Label control, final String url) {
        control.setCursor(control.getDisplay().getSystemCursor(21));
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                JavaScriptExecutor executor = (JavaScriptExecutor)RWT.getClient().getService(JavaScriptExecutor.class);
                if (executor != null) {
                    executor.execute("window.location.href = '" + url + "'");
                }
            }
        });
    }
}

