/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.Util;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TreeTab
extends ExampleTab {
    private static final int INITIAL_COLUMNS = 5;
    private static final int INITIAL_ITEMS = 15;
    private boolean headerVisible = true;
    private boolean linesVisible;
    private boolean updateVirtualItemsDelayed;
    private Tree tree;
    private boolean showImages;
    private Image treeImage;
    private boolean columnImages;
    private Image columnImage;
    private boolean columnsMoveable;
    private boolean addMouseListener;

    public TreeTab() {
        super("Tree");
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.initializeImages();
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("CHECK", 32);
        this.createStyleButton("MULTI", 2);
        this.createStyleButton("VIRTUAL", 0x10000000);
        this.createStyleButton("FULL_SELECTION", 65536);
        this.createStyleButton("NO_SCROLL", 16);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createHeaderVisibleButton();
        this.createLinesVisibleButton();
        this.createColumnsMoveableButton();
        this.createColumnImagesButton();
        this.createImagesButton(parent);
        this.createAddNodeButton(parent);
        this.createDisposeNodeButton(parent);
        this.createSelectAllButton(parent);
        this.createDeselectAllButton(parent);
        this.createSelectButton(parent);
        this.createDeselectButton(parent);
        this.createSetSelectionButton(parent);
        this.createChangeItemCountControl();
        this.createClearButton();
        this.createShowColumnControl();
        this.createBgImageButton();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createFontChooser();
        this.createItemForegroundControl();
        this.createItemBackgroundControl();
        this.createItemFontControl();
        this.createCellForegroundControl();
        this.createCellBackgroundControl();
        this.createCellFontControl();
        this.createGrayOutButton();
        this.createColumnsAlignmentButton();
        this.createPackAllColumnsButton();
        this.createAddMouseListenerButton();
        this.createQueryTopItemButton();
        this.createSetSelectionAsTopItemButton();
    }

    @Override
    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        int style = this.getStyle();
        this.tree = new Tree(parent, style);
        if ((style & 0x10000000) != 0) {
            this.tree.addListener(36, new Listener(){

                public void handleEvent(Event event) {
                    final TreeItem item = (TreeItem)event.item;
                    if (TreeTab.this.updateVirtualItemsDelayed) {
                        final Display display = event.display;
                        final ServerPushSession pushSession = new ServerPushSession();
                        Job job = new Job("Delayed Tree Item Update"){

                            protected IStatus run(IProgressMonitor monitor) {
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        TreeTab.this.updateItem(item);
                                        pushSession.stop();
                                    }
                                });
                                return Status.OK_STATUS;
                            }
                        };
                        pushSession.start();
                        job.schedule(1000L);
                    } else {
                        TreeTab.this.updateItem(item);
                    }
                }
            });
        }
        this.tree.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < 5) {
            final TreeColumn column = new TreeColumn(this.tree, 0);
            column.setText("Column " + i);
            column.setToolTipText("Column " + i);
            if (this.columnImages) {
                column.setImage(this.columnImage);
            }
            column.setWidth(150);
            column.setMoveable(this.columnsMoveable);
            column.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Tree tree = column.getParent();
                    if (tree.getSortColumn() == column) {
                        if (tree.getSortDirection() == 128) {
                            tree.setSortDirection(1024);
                        } else {
                            tree.setSortDirection(128);
                        }
                    } else {
                        tree.setSortDirection(128);
                        tree.setSortColumn(column);
                    }
                }
            });
            ++i;
        }
        i = 0;
        while (i < 15) {
            TreeItem item = new TreeItem(this.tree, 0);
            int j = 0;
            while (j < 5) {
                item.setText(j, "Node_" + i + "." + j);
                ++j;
            }
            if (i % 2 == 0) {
                TreeItem subitem = new TreeItem(item, 0);
                int j2 = 0;
                while (j2 < 5) {
                    subitem.setText(j2, "Subnode_" + i + "." + j2);
                    ++j2;
                }
            }
            ++i;
        }
        if (this.showImages) {
            TreeTab.changeImage(this.tree, this.treeImage);
        }
        final Label lblTreeEvent = new Label(parent, 0);
        lblTreeEvent.setLayoutData((Object)new GridData(300, 22));
        Menu treeMenu = new Menu((Control)this.tree);
        MenuItem treeMenuItem = new MenuItem(treeMenu, 8);
        treeMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = TreeTab.this.tree.getSelection()[0];
                String itemText = "null";
                if (item != null) {
                    itemText = item.getText();
                }
                String message = "You requested a context menu for: " + itemText;
                MessageDialog.openInformation((Shell)TreeTab.this.tree.getShell(), (String)"Information", (String)message);
            }
        });
        treeMenuItem.setText("TreeContextMenuItem");
        this.tree.setMenu(treeMenu);
        this.tree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent event) {
                Item item = (Item)event.item;
                lblTreeEvent.setText("Collapsed: " + item.getText());
            }

            public void treeExpanded(TreeEvent event) {
                Item item = (Item)event.item;
                lblTreeEvent.setText("Expanded: " + item.getText());
            }
        });
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                String msg = "Selected: ";
                TreeItem item = (TreeItem)event.item;
                if ((TreeTab.this.getStyle() & 0x20) != 0) {
                    msg = String.valueOf(msg) + (item.getChecked() ? "[x] " : "[ ] ");
                }
                msg = String.valueOf(msg) + item.getText();
                switch (event.detail) {
                    case 0: {
                        msg = String.valueOf(msg) + ", detail: SWT.NONE";
                        break;
                    }
                    case 32: {
                        msg = String.valueOf(msg) + ", detail: SWT.CHECK";
                    }
                }
                lblTreeEvent.setText(msg);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                String title = "Widget Default Selected";
                Item item = (Item)event.item;
                String message = "Widget default selected on " + item.getText() + " received";
                MessageDialog.openInformation((Shell)TreeTab.this.getShell(), (String)title, (String)message);
            }
        });
        this.tree.setSelection(this.tree.getItem(0));
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(this.linesVisible);
        if (this.addMouseListener) {
            MouseListener listener = new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                    TreeTab.this.log("mouseDoubleClick: " + e);
                }

                public void mouseDown(MouseEvent e) {
                    TreeTab.this.log("mouseDown: " + e);
                }

                public void mouseUp(MouseEvent e) {
                    TreeTab.this.log("mouseUp: " + e);
                }
            };
            this.tree.addMouseListener(listener);
        }
        this.registerControl((Control)this.tree);
    }

    private void initializeImages() {
        this.treeImage = this.loadImage("resources/tree_item.gif");
        this.columnImage = this.loadImage("resources/shell.gif");
    }

    private void updateItem(TreeItem item) {
        if (!item.isDisposed()) {
            String text;
            int columns = item.getParent().getColumnCount();
            int index = -1;
            index = item.getParentItem() == null ? item.getParent().indexOf(item) : item.getParentItem().indexOf(item);
            String string = text = item.getParentItem() == null ? "Node_" : "Subnode_";
            if (columns == 0) {
                item.setText(String.valueOf(text) + index);
                if (this.showImages) {
                    item.setImage(this.treeImage);
                }
            } else {
                int i = 0;
                while (i < columns) {
                    item.setText(i, String.valueOf(text) + index + "." + i);
                    if (i < 2 && this.showImages) {
                        item.setImage(i, this.treeImage);
                    }
                    ++i;
                }
            }
        }
    }

    private void createHeaderVisibleButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("headerVisible");
        button.setSelection(this.headerVisible);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeTab.this.headerVisible = button.getSelection();
                TreeTab.this.tree.setHeaderVisible(TreeTab.this.headerVisible);
            }
        });
    }

    private void createLinesVisibleButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("linesVisible");
        button.setSelection(this.linesVisible);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeTab.this.linesVisible = button.getSelection();
                TreeTab.this.tree.setLinesVisible(TreeTab.this.linesVisible);
            }
        });
    }

    private void createImagesButton(Composite parent) {
        final Button button = new Button(parent, 2);
        button.setText("Show Images");
        button.setSelection(this.showImages);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeTab.this.showImages = button.getSelection();
                TreeTab.changeImage(TreeTab.this.tree, TreeTab.this.showImages ? TreeTab.this.treeImage : null);
            }
        });
    }

    private void createAddNodeButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Add child item");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TreeTab.this.tree.getSelectionCount() > 0) {
                    TreeItem selection = TreeTab.this.tree.getSelection()[0];
                    TreeItem treeItem = new TreeItem(selection, 0);
                    Object[] args = new Object[]{new Integer(selection.getItemCount()), selection.getText()};
                    String text = MessageFormat.format("SubItem {0} of {1}", args);
                    treeItem.setText(text);
                    treeItem.setChecked(true);
                    if (TreeTab.this.showImages) {
                        treeItem.setImage(TreeTab.this.treeImage);
                    }
                }
            }
        });
    }

    private void createDisposeNodeButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Dispose Selected Item");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TreeTab.this.tree.getSelectionCount() > 0) {
                    TreeItem selection = TreeTab.this.tree.getSelection()[0];
                    selection.dispose();
                }
            }
        });
    }

    private void createSelectAllButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Select All");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeTab.this.tree.selectAll();
            }
        });
    }

    private void createDeselectAllButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Deselect All");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeTab.this.tree.deselectAll();
            }
        });
    }

    private void createSelectButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Select second node");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TreeTab.this.tree.getItemCount() > 1) {
                    TreeTab.this.tree.select(TreeTab.this.tree.getItem(1));
                }
            }
        });
    }

    private void createDeselectButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Deselect second node");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TreeTab.this.tree.getItemCount() > 1) {
                    TreeTab.this.tree.deselect(TreeTab.this.tree.getItem(1));
                }
            }
        });
    }

    private void createSetSelectionButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Set selection to first node");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TreeTab.this.tree.getItemCount() > 0) {
                    TreeTab.this.tree.setSelection(TreeTab.this.tree.getItem(0));
                }
            }
        });
    }

    private void createShowColumnControl() {
        Composite composite = new Composite(this.styleComp, 0);
        RowLayout layout = new RowLayout(256);
        layout.center = true;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText("Column");
        final Text text = new Text(composite, 2048);
        Util.textSizeAdjustment(label, (Control)text);
        text.setText(String.valueOf(this.tree.getColumnCount() - 1));
        Button button = new Button(composite, 8);
        button.setText("Show");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    int index = Integer.parseInt(text.getText());
                    TreeTab.this.tree.showColumn(TreeTab.this.tree.getColumn(index));
                }
                catch (Exception exception) {}
            }
        });
    }

    private void createChangeItemCountControl() {
        Composite composite = new Composite(this.styleComp, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblItemCount = new Label(composite, 0);
        lblItemCount.setText("ItemCount");
        final Text txtItemCount = new Text(composite, 2048);
        Util.textSizeAdjustment(lblItemCount, (Control)txtItemCount);
        txtItemCount.setText(String.valueOf(this.tree.getItemCount()));
        Button btnChange = new Button(composite, 8);
        btnChange.setText("Change");
        btnChange.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int itemCount = -1;
                try {
                    itemCount = Integer.parseInt(txtItemCount.getText());
                }
                catch (NumberFormatException numberFormatException) {}
                TreeItem[] selectedItems = TreeTab.this.tree.getSelection();
                if (selectedItems.length > 0) {
                    selectedItems[0].setItemCount(itemCount);
                } else {
                    TreeTab.this.tree.setItemCount(itemCount);
                }
                TreeTab.this.tree.redraw();
            }
        });
        final Button cbDelayedUpdate = new Button(composite, 32);
        GridData gridData = new GridData(16384, 0x1000000, true, false, 3, -1);
        cbDelayedUpdate.setLayoutData((Object)gridData);
        cbDelayedUpdate.setText("Update virtual items delayed");
        cbDelayedUpdate.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeTab.this.updateVirtualItemsDelayed = cbDelayedUpdate.getSelection();
            }
        });
    }

    private void createClearButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("ClearAll");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeTab.this.tree.clearAll(true);
            }
        });
    }

    private static void changeImage(Tree tree, Image image) {
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            TreeTab.changeImage(item, image);
            ++n2;
        }
    }

    private static void changeImage(TreeItem item, Image image) {
        item.setImage(0, image);
        if (item.getParent().getColumnCount() > 1) {
            item.setImage(1, image);
        }
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem subItem = treeItemArray[n2];
            TreeTab.changeImage(subItem, image);
            ++n2;
        }
    }

    private void createSetSelectionAsTopItemButton() {
        Button button = this.createPropertyButton("Set selection as topItem", 8);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeItem[] item = TreeTab.this.tree.getSelection();
                if (item.length > 0) {
                    TreeTab.this.tree.setTopItem(item[0]);
                }
            }
        });
    }

    private void createQueryTopItemButton() {
        Button button = this.createPropertyButton("Query topItem", 8);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String message = "Current topItem: " + TreeTab.this.tree.getTopItem().toString();
                MessageDialog.openInformation((Shell)TreeTab.this.tree.getShell(), (String)"Information", (String)message);
            }
        });
    }

    private void createAddMouseListenerButton() {
        Button button = this.createPropertyButton("Attach MouseListener", 32);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeTab.this.addMouseListener = !TreeTab.this.addMouseListener;
                TreeTab.this.createNew();
            }
        });
    }

    private void createGrayOutButton() {
        final Button button = this.createPropertyButton("Gray out 2nd item", 32);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeTab.this.tree.getItem(1).setGrayed(button.getSelection());
            }
        });
    }

    private void createColumnsAlignmentButton() {
        Button button = this.createPropertyButton("Change columns alignment", 8);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeColumn col1 = TreeTab.this.tree.getColumn(1);
                if (col1.getAlignment() == 131072) {
                    col1.setAlignment(16384);
                } else {
                    col1.setAlignment(131072);
                }
                TreeColumn col2 = TreeTab.this.tree.getColumn(2);
                if (col2.getAlignment() == 0x1000000) {
                    col2.setAlignment(16384);
                } else {
                    col2.setAlignment(0x1000000);
                }
            }
        });
    }

    private void createPackAllColumnsButton() {
        Button button = this.createPropertyButton("Pack all columns", 8);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeColumn[] treeColumnArray = TreeTab.this.tree.getColumns();
                int n = treeColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn column = treeColumnArray[n2];
                    column.pack();
                    ++n2;
                }
            }
        });
    }

    private void createItemForegroundControl() {
        final Button button = this.createPropertyButton("Item 0 Foreground", 2);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TreeTab.this.tree.getItemCount() > 0) {
                    Color color = button.getSelection() ? TreeTab.this.fgColors[3] : null;
                    TreeTab.this.tree.getItem(0).setForeground(color);
                }
            }
        });
    }

    private void createItemBackgroundControl() {
        final Button button = this.createPropertyButton("Item 0 Background", 2);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TreeTab.this.tree.getItemCount() > 0) {
                    Color color = button.getSelection() ? TreeTab.this.bgColors[3] : null;
                    TreeTab.this.tree.getItem(0).setBackground(color);
                }
            }
        });
    }

    private void createItemFontControl() {
        final Button button = this.createPropertyButton("Item 0 Font", 2);
        final Font customFont = new Font((Device)button.getDisplay(), "Courier", 11, 1);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TreeTab.this.tree.getItemCount() > 0) {
                    Font font = button.getSelection() ? customFont : null;
                    TreeTab.this.tree.getItem(0).setFont(font);
                }
            }
        });
    }

    private void createCellForegroundControl() {
        final Button button = this.createPropertyButton("Cell 0,0 Foreground", 2);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TreeTab.this.tree.getItemCount() > 0) {
                    Color color = button.getSelection() ? TreeTab.this.fgColors[1] : null;
                    TreeTab.this.tree.getItem(0).setForeground(0, color);
                }
            }
        });
    }

    private void createCellBackgroundControl() {
        final Button button = this.createPropertyButton("Cell 0,0 Background", 2);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TreeTab.this.tree.getItemCount() > 0) {
                    Color color = button.getSelection() ? TreeTab.this.bgColors[1] : null;
                    TreeTab.this.tree.getItem(0).setBackground(0, color);
                }
            }
        });
    }

    private void createCellFontControl() {
        final Button button = this.createPropertyButton("Cell 0,0 Font", 2);
        final Font cellFont = new Font((Device)button.getDisplay(), "Times", 13, 2);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TreeTab.this.tree.getItemCount() > 0) {
                    Font font = button.getSelection() ? cellFont : null;
                    TreeTab.this.tree.getItem(0).setFont(0, font);
                }
            }
        });
    }

    private void createColumnsMoveableButton() {
        final Button button = this.createPropertyButton("Moveable Columns", 32);
        button.setSelection(this.columnsMoveable);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeTab.this.columnsMoveable = button.getSelection();
                TreeColumn[] treeColumnArray = TreeTab.this.tree.getColumns();
                int n = treeColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn column = treeColumnArray[n2];
                    column.setMoveable(TreeTab.this.columnsMoveable);
                    ++n2;
                }
            }
        });
    }

    private void createColumnImagesButton() {
        final Button button = this.createPropertyButton("Column images", 32);
        button.setSelection(this.columnImages);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeTab.this.columnImages = button.getSelection();
                TreeColumn[] columns = TreeTab.this.tree.getColumns();
                int i = 0;
                while (i < columns.length) {
                    columns[i].setImage(TreeTab.this.columnImages ? TreeTab.this.columnImage : null);
                    ++i;
                }
            }
        });
    }
}

