/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.fileupload.internal;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.eclipse.rap.fileupload.FileUploadHandler;
import org.eclipse.rap.fileupload.internal.FileUploadHandlerStore;
import org.eclipse.rap.fileupload.internal.FileUploadProcessor;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ServiceHandler;

public final class FileUploadServiceHandler
implements ServiceHandler {
    private static final String PARAMETER_TOKEN = "token";
    static final String SERVICE_HANDLER_ID = "org.eclipse.rap.fileupload";

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean hasSession;
        boolean bl = hasSession = request.getSession(false) != null;
        if (hasSession) {
            String token = request.getParameter(PARAMETER_TOKEN);
            FileUploadHandler registeredHandler = FileUploadHandlerStore.getInstance().getHandler(token);
            if (registeredHandler == null) {
                String message = "Invalid or missing token";
                response.sendError(403, message);
            } else if (!"POST".equals(request.getMethod().toUpperCase())) {
                String message = "Only POST requests allowed";
                response.sendError(405, message);
            } else if (!JakartaServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                String message = "Content must be in multipart type";
                response.sendError(415, message);
            } else {
                FileUploadProcessor processor = new FileUploadProcessor(registeredHandler);
                processor.handleFileUpload(request, response);
            }
        }
    }

    public static String getUrl(String token) {
        String serviceHandlerUrl = RWT.getServiceManager().getServiceHandlerUrl(SERVICE_HANDLER_ID);
        return serviceHandlerUrl + '&' + PARAMETER_TOKEN + '=' + token;
    }
}

