/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.apache.jxpath.ri;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.rap.e4.apache.jxpath.CompiledExpression;
import org.eclipse.rap.e4.apache.jxpath.Function;
import org.eclipse.rap.e4.apache.jxpath.Functions;
import org.eclipse.rap.e4.apache.jxpath.JXPathContext;
import org.eclipse.rap.e4.apache.jxpath.JXPathException;
import org.eclipse.rap.e4.apache.jxpath.JXPathFunctionNotFoundException;
import org.eclipse.rap.e4.apache.jxpath.JXPathInvalidSyntaxException;
import org.eclipse.rap.e4.apache.jxpath.JXPathNotFoundException;
import org.eclipse.rap.e4.apache.jxpath.JXPathTypeConversionException;
import org.eclipse.rap.e4.apache.jxpath.Pointer;
import org.eclipse.rap.e4.apache.jxpath.ri.Compiler;
import org.eclipse.rap.e4.apache.jxpath.ri.EvalContext;
import org.eclipse.rap.e4.apache.jxpath.ri.JXPathCompiledExpression;
import org.eclipse.rap.e4.apache.jxpath.ri.NamespaceResolver;
import org.eclipse.rap.e4.apache.jxpath.ri.Parser;
import org.eclipse.rap.e4.apache.jxpath.ri.QName;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.InitialContext;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.RootContext;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.Expression;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.LocationPath;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.Path;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.TreeCompiler;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodePointer;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodePointerFactory;
import org.eclipse.rap.e4.apache.jxpath.ri.model.VariablePointerFactory;
import org.eclipse.rap.e4.apache.jxpath.ri.model.beans.BeanPointerFactory;
import org.eclipse.rap.e4.apache.jxpath.ri.model.beans.CollectionPointerFactory;
import org.eclipse.rap.e4.apache.jxpath.ri.model.container.ContainerPointerFactory;
import org.eclipse.rap.e4.apache.jxpath.ri.model.dynamic.DynamicPointerFactory;
import org.eclipse.rap.e4.apache.jxpath.util.ReverseComparator;
import org.eclipse.rap.e4.apache.jxpath.util.TypeUtils;

public class JXPathContextReferenceImpl
extends JXPathContext {
    public static final boolean USE_SOFT_CACHE = true;
    private static final Compiler COMPILER;
    private static Map compiled;
    private static int cleanupCount;
    private static NodePointerFactory[] nodeFactoryArray;
    private static final int CLEANUP_THRESHOLD = 500;
    private static final Vector nodeFactories;
    protected NamespaceResolver namespaceResolver;
    private Pointer rootPointer;
    private Pointer contextPointer;

    static {
        Object dynaBeanFactory;
        Object jdomFactory;
        COMPILER = new TreeCompiler();
        compiled = new HashMap();
        cleanupCount = 0;
        nodeFactoryArray = null;
        nodeFactories = new Vector();
        nodeFactories.add(new CollectionPointerFactory());
        nodeFactories.add(new BeanPointerFactory());
        nodeFactories.add(new DynamicPointerFactory());
        nodeFactories.add(new VariablePointerFactory());
        Object domFactory = JXPathContextReferenceImpl.allocateConditionally("org.apache.commons.jxpath.ri.model.dom.DOMPointerFactory", "org.w3c.dom.Node");
        if (domFactory != null) {
            nodeFactories.add(domFactory);
        }
        if ((jdomFactory = JXPathContextReferenceImpl.allocateConditionally("org.apache.commons.jxpath.ri.model.jdom.JDOMPointerFactory", "org.jdom.Document")) != null) {
            nodeFactories.add(jdomFactory);
        }
        if ((dynaBeanFactory = JXPathContextReferenceImpl.allocateConditionally("org.apache.commons.jxpath.ri.model.dynabeans.DynaBeanPointerFactory", "org.apache.commons.beanutils.DynaBean")) != null) {
            nodeFactories.add(dynaBeanFactory);
        }
        nodeFactories.add(new ContainerPointerFactory());
        JXPathContextReferenceImpl.createNodeFactoryArray();
    }

    private static synchronized void createNodeFactoryArray() {
        if (nodeFactoryArray == null) {
            nodeFactoryArray = nodeFactories.toArray(new NodePointerFactory[nodeFactories.size()]);
            Arrays.sort(nodeFactoryArray, new Comparator(){

                public int compare(Object a, Object b) {
                    int orderA = ((NodePointerFactory)a).getOrder();
                    int orderB = ((NodePointerFactory)b).getOrder();
                    return orderA - orderB;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNodePointerFactory(NodePointerFactory factory) {
        Vector vector = nodeFactories;
        synchronized (vector) {
            nodeFactories.add(factory);
            nodeFactoryArray = null;
        }
    }

    public static NodePointerFactory[] getNodePointerFactories() {
        return nodeFactoryArray;
    }

    protected JXPathContextReferenceImpl(JXPathContext parentContext, Object contextBean) {
        this(parentContext, contextBean, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JXPathContextReferenceImpl(JXPathContext parentContext, Object contextBean, Pointer contextPointer) {
        super(parentContext, contextBean);
        Vector vector = nodeFactories;
        synchronized (vector) {
            JXPathContextReferenceImpl.createNodeFactoryArray();
        }
        if (contextPointer != null) {
            this.contextPointer = contextPointer;
            this.rootPointer = NodePointer.newNodePointer(new QName(null, "root"), contextPointer.getRootNode(), this.getLocale());
        } else {
            this.rootPointer = this.contextPointer = NodePointer.newNodePointer(new QName(null, "root"), contextBean, this.getLocale());
        }
        NamespaceResolver parentNR = null;
        if (parentContext instanceof JXPathContextReferenceImpl) {
            parentNR = ((JXPathContextReferenceImpl)parentContext).getNamespaceResolver();
        }
        this.namespaceResolver = new NamespaceResolver(parentNR);
        this.namespaceResolver.setNamespaceContextPointer((NodePointer)this.contextPointer);
    }

    protected Compiler getCompiler() {
        return COMPILER;
    }

    @Override
    protected CompiledExpression compilePath(String xpath) {
        return new JXPathCompiledExpression(xpath, this.compileExpression(xpath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression compileExpression(String xpath) {
        Expression expr;
        Map map = compiled;
        synchronized (map) {
            expr = null;
            SoftReference ref = (SoftReference)compiled.get(xpath);
            if (ref != null) {
                expr = (Expression)ref.get();
            }
        }
        if (expr != null) {
            return expr;
        }
        expr = (Expression)Parser.parseExpression(xpath, this.getCompiler());
        map = compiled;
        synchronized (map) {
            if (cleanupCount++ >= 500) {
                Iterator it = compiled.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry me = it.next();
                    if (((SoftReference)me.getValue()).get() != null) continue;
                    it.remove();
                }
                cleanupCount = 0;
            }
            compiled.put(xpath, new SoftReference<Expression>(expr));
        }
        return expr;
    }

    @Override
    public Object getValue(String xpath) {
        Expression expression = this.compileExpression(xpath);
        return this.getValue(xpath, expression);
    }

    public Object getValue(String xpath, Expression expr) {
        Object result = expr.computeValue(this.getEvalContext());
        if (result == null) {
            if (expr instanceof Path && !this.isLenient()) {
                throw new JXPathNotFoundException("No value for xpath: " + xpath);
            }
            return null;
        }
        if (result instanceof EvalContext) {
            EvalContext ctx = (EvalContext)result;
            result = ctx.getSingleNodePointer();
            if (!this.isLenient() && result == null) {
                throw new JXPathNotFoundException("No value for xpath: " + xpath);
            }
        }
        if (result instanceof NodePointer) {
            NodePointer parent;
            result = ((NodePointer)result).getValuePointer();
            if (!(this.isLenient() || ((NodePointer)result).isActual() || (parent = ((NodePointer)result).getImmediateParentPointer()) != null && parent.isContainer() && parent.isActual())) {
                throw new JXPathNotFoundException("No value for xpath: " + xpath);
            }
            result = ((NodePointer)result).getValue();
        }
        return result;
    }

    @Override
    public Object getValue(String xpath, Class requiredType) {
        Expression expr = this.compileExpression(xpath);
        return this.getValue(xpath, expr, requiredType);
    }

    public Object getValue(String xpath, Expression expr, Class requiredType) {
        Object value = this.getValue(xpath, expr);
        if (value != null && requiredType != null) {
            if (!TypeUtils.canConvert(value, requiredType)) {
                throw new JXPathTypeConversionException("Invalid expression type. '" + xpath + "' returns " + value.getClass().getName() + ". It cannot be converted to " + requiredType.getName());
            }
            value = TypeUtils.convert(value, requiredType);
        }
        return value;
    }

    @Override
    public Iterator iterate(String xpath) {
        return this.iterate(xpath, this.compileExpression(xpath));
    }

    public Iterator iterate(String xpath, Expression expr) {
        return expr.iterate(this.getEvalContext());
    }

    @Override
    public Pointer getPointer(String xpath) {
        return this.getPointer(xpath, this.compileExpression(xpath));
    }

    public Pointer getPointer(String xpath, Expression expr) {
        Object result = expr.computeValue(this.getEvalContext());
        if (result instanceof EvalContext) {
            result = ((EvalContext)result).getSingleNodePointer();
        }
        if (result instanceof Pointer) {
            if (!this.isLenient() && !((NodePointer)result).isActual()) {
                throw new JXPathNotFoundException("No pointer for xpath: " + xpath);
            }
            return (Pointer)result;
        }
        return NodePointer.newNodePointer(null, result, this.getLocale());
    }

    @Override
    public void setValue(String xpath, Object value) {
        this.setValue(xpath, this.compileExpression(xpath), value);
    }

    public void setValue(String xpath, Expression expr, Object value) {
        try {
            this.setValue(xpath, expr, value, false);
        }
        catch (Throwable ex) {
            throw new JXPathException("Exception trying to set value with xpath " + xpath, ex);
        }
    }

    @Override
    public Pointer createPath(String xpath) {
        return this.createPath(xpath, this.compileExpression(xpath));
    }

    public Pointer createPath(String xpath, Expression expr) {
        try {
            Object result = expr.computeValue(this.getEvalContext());
            Pointer pointer = null;
            if (result instanceof Pointer) {
                pointer = (Pointer)result;
            } else if (result instanceof EvalContext) {
                EvalContext ctx = (EvalContext)result;
                pointer = ctx.getSingleNodePointer();
            } else {
                this.checkSimplePath(expr);
                throw new JXPathException("Cannot create path:" + xpath);
            }
            return ((NodePointer)pointer).createPath(this);
        }
        catch (Throwable ex) {
            throw new JXPathException("Exception trying to create xpath " + xpath, ex);
        }
    }

    @Override
    public Pointer createPathAndSetValue(String xpath, Object value) {
        return this.createPathAndSetValue(xpath, this.compileExpression(xpath), value);
    }

    public Pointer createPathAndSetValue(String xpath, Expression expr, Object value) {
        try {
            return this.setValue(xpath, expr, value, true);
        }
        catch (Throwable ex) {
            throw new JXPathException("Exception trying to create xpath " + xpath, ex);
        }
    }

    private Pointer setValue(String xpath, Expression expr, Object value, boolean create) {
        Object result = expr.computeValue(this.getEvalContext());
        Pointer pointer = null;
        if (result instanceof Pointer) {
            pointer = (Pointer)result;
        } else if (result instanceof EvalContext) {
            EvalContext ctx = (EvalContext)result;
            pointer = ctx.getSingleNodePointer();
        } else {
            if (create) {
                this.checkSimplePath(expr);
            }
            throw new JXPathException("Cannot set value for xpath: " + xpath);
        }
        if (create) {
            pointer = ((NodePointer)pointer).createPath(this, value);
        } else {
            pointer.setValue(value);
        }
        return pointer;
    }

    private void checkSimplePath(Expression expr) {
        if (!(expr instanceof LocationPath) || !((LocationPath)expr).isSimplePath()) {
            throw new JXPathInvalidSyntaxException("JXPath can only create a path if it uses exclusively the child:: and attribute:: axes and has no context-dependent predicates");
        }
    }

    @Override
    public Iterator iteratePointers(String xpath) {
        return this.iteratePointers(xpath, this.compileExpression(xpath));
    }

    public Iterator iteratePointers(String xpath, Expression expr) {
        return expr.iteratePointers(this.getEvalContext());
    }

    @Override
    public void removePath(String xpath) {
        this.removePath(xpath, this.compileExpression(xpath));
    }

    public void removePath(String xpath, Expression expr) {
        try {
            NodePointer pointer = (NodePointer)this.getPointer(xpath, expr);
            if (pointer != null) {
                pointer.remove();
            }
        }
        catch (Throwable ex) {
            throw new JXPathException("Exception trying to remove xpath " + xpath, ex);
        }
    }

    @Override
    public void removeAll(String xpath) {
        this.removeAll(xpath, this.compileExpression(xpath));
    }

    public void removeAll(String xpath, Expression expr) {
        try {
            ArrayList list = new ArrayList();
            Iterator it = expr.iteratePointers(this.getEvalContext());
            while (it.hasNext()) {
                list.add(it.next());
            }
            Collections.sort(list, ReverseComparator.INSTANCE);
            it = list.iterator();
            if (it.hasNext()) {
                NodePointer pointer = (NodePointer)it.next();
                pointer.remove();
                while (it.hasNext()) {
                    this.removePath(((NodePointer)it.next()).asPath());
                }
            }
        }
        catch (Throwable ex) {
            throw new JXPathException("Exception trying to remove all for xpath " + xpath, ex);
        }
    }

    @Override
    public JXPathContext getRelativeContext(Pointer pointer) {
        Object contextBean = pointer.getNode();
        if (contextBean == null) {
            throw new JXPathException("Cannot create a relative context for a non-existent node: " + String.valueOf(pointer));
        }
        return new JXPathContextReferenceImpl(this, contextBean, pointer);
    }

    @Override
    public Pointer getContextPointer() {
        return this.contextPointer;
    }

    private NodePointer getAbsoluteRootPointer() {
        return (NodePointer)this.rootPointer;
    }

    private EvalContext getEvalContext() {
        return new InitialContext(new RootContext(this, (NodePointer)this.getContextPointer()));
    }

    public EvalContext getAbsoluteRootContext() {
        return new InitialContext(new RootContext(this, this.getAbsoluteRootPointer()));
    }

    public NodePointer getVariablePointer(QName name) {
        return NodePointer.newNodePointer(name, VariablePointerFactory.contextWrapper(this), this.getLocale());
    }

    public Function getFunction(QName functionName, Object[] parameters) {
        String namespace = functionName.getPrefix();
        String name = functionName.getName();
        JXPathContext funcCtx = this;
        Function func = null;
        while (funcCtx != null) {
            Functions funcs = funcCtx.getFunctions();
            if (funcs != null && (func = funcs.getFunction(namespace, name, parameters)) != null) {
                return func;
            }
            funcCtx = funcCtx.getParentContext();
        }
        throw new JXPathFunctionNotFoundException("Undefined function: " + functionName.toString());
    }

    @Override
    public void registerNamespace(String prefix, String namespaceURI) {
        if (this.namespaceResolver.isSealed()) {
            this.namespaceResolver = (NamespaceResolver)this.namespaceResolver.clone();
        }
        this.namespaceResolver.registerNamespace(prefix, namespaceURI);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.namespaceResolver.getNamespaceURI(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.namespaceResolver.getPrefix(namespaceURI);
    }

    @Override
    public void setNamespaceContextPointer(Pointer pointer) {
        if (this.namespaceResolver.isSealed()) {
            this.namespaceResolver = (NamespaceResolver)this.namespaceResolver.clone();
        }
        this.namespaceResolver.setNamespaceContextPointer((NodePointer)pointer);
    }

    @Override
    public Pointer getNamespaceContextPointer() {
        return this.namespaceResolver.getNamespaceContextPointer();
    }

    public NamespaceResolver getNamespaceResolver() {
        this.namespaceResolver.seal();
        return this.namespaceResolver;
    }

    public static Object allocateConditionally(String className, String existenceCheckClassName) {
        try {
            try {
                Class.forName(existenceCheckClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        catch (Exception ex) {
            throw new JXPathException("Cannot allocate " + className, ex);
        }
        Class<?> cls = Class.forName(className);
        return cls.newInstance();
    }
}

