/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.internal.Tracing;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryContentProvider;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.edit.TransientItemProvider;
import org.eclipse.sphinx.emf.explorer.ExtendedCommonNavigator;
import org.eclipse.sphinx.emf.explorer.IModelCommonContentProvider;
import org.eclipse.sphinx.emf.explorer.refresh.FullRefreshStrategy;
import org.eclipse.sphinx.emf.explorer.refresh.ModelObjectRefreshStrategy;
import org.eclipse.sphinx.emf.explorer.refresh.ModelResourceRefreshStrategy;
import org.eclipse.sphinx.emf.explorer.refresh.WorkspaceResourceRefreshStrategy;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.ITreeViewerState;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;

public class BasicExplorerContentProvider
implements IModelCommonContentProvider {
    protected static final int LIMIT_INDIVIDUAL_RESOURCES_REFRESH = 20;
    protected static final int LIMIT_INDIVIDUAL_OBJECTS_REFRESH = 100;
    protected Viewer viewer;
    protected INavigatorContentDescriptor contentDescriptor;
    protected Map<TransactionalEditingDomain, AdapterFactoryContentProvider> modelContentProviders = new WeakHashMap<TransactionalEditingDomain, AdapterFactoryContentProvider>();
    protected ResourceSetListener resourceChangedListener;
    protected ResourceSetListener resourceMovedListener;
    protected ResourceSetListener crossReferenceChangedListener;
    protected ResourceSetListener modelContentRootChangedListener;
    private IResourceChangeListener resourceMarkerChangeListener;

    public Viewer getViewer() {
        return this.viewer;
    }

    protected ExtendedCommonNavigator getCommonNavigator() {
        CommonViewer commonViewer;
        CommonNavigator commonNavigator;
        if (this.viewer instanceof CommonViewer && (commonNavigator = (commonViewer = (CommonViewer)this.viewer).getCommonNavigator()) instanceof ExtendedCommonNavigator) {
            return (ExtendedCommonNavigator)commonNavigator;
        }
        return null;
    }

    public ITreeViewerState recordViewerState() {
        ExtendedCommonNavigator navigator = this.getCommonNavigator();
        if (navigator != null) {
            return navigator.getViewerStateRecorder().recordState();
        }
        return null;
    }

    public void applyViewerState(ITreeViewerState state) {
        ExtendedCommonNavigator navigator = this.getCommonNavigator();
        if (navigator != null) {
            navigator.getViewerStateRecorder().applyState(state);
        }
    }

    public void init(ICommonContentExtensionSite config) {
        this.contentDescriptor = config.getExtension().getDescriptor();
        if (this.resourceMarkerChangeListener == null) {
            this.resourceMarkerChangeListener = this.createResourceMarkerChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceMarkerChangeListener, 1);
        }
    }

    public boolean isTriggerPoint(Object element) {
        return this.contentDescriptor.isTriggerPoint(element);
    }

    public boolean isPossibleChild(Object element) {
        return this.contentDescriptor.isPossibleChild(element);
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }

    @Override
    public Resource getModelResource(IResource workspaceResource) {
        IModelDescriptor modelDescriptor;
        if (workspaceResource instanceof IFile && (modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel((IFile)workspaceResource)) != null) {
            Resource modelResource = EcorePlatformUtil.getResource((IFile)((IFile)workspaceResource));
            if (modelResource != null) {
                return modelResource;
            }
            this.addTransactionalEditingDomainListeners(modelDescriptor.getEditingDomain());
            ModelLoadManager.INSTANCE.loadModel(modelDescriptor, true, null);
        }
        return null;
    }

    @Override
    public List<Object> getModelContentRoots(Resource modelResource) {
        if (modelResource != null) {
            Object deprecatedModelContentRoot;
            ArrayList<Object> modelContentRoots = new ArrayList<Object>(3);
            if (!modelResource.getContents().isEmpty() && (deprecatedModelContentRoot = this.getModelContentRoot((EObject)modelResource.getContents().get(0))) != null) {
                modelContentRoots.add(deprecatedModelContentRoot);
            }
            if (modelContentRoots.isEmpty()) {
                modelContentRoots.add(modelResource);
            }
            return modelContentRoots;
        }
        return Collections.emptyList();
    }

    @Override
    public IResource getWorkspaceResource(Resource modelResource) {
        return EcorePlatformUtil.getFile((Resource)modelResource);
    }

    @Deprecated
    protected Object getModelRoot(IResource resource) {
        IModelDescriptor modelDescriptor;
        if (resource instanceof IFile && (modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel((IFile)resource)) != null) {
            Object modelRoot = null;
            Resource modelResource = EcorePlatformUtil.getResource((IFile)((IFile)resource));
            if (modelResource != null && !modelResource.getContents().isEmpty()) {
                modelRoot = modelResource.getContents().get(0);
            }
            if (modelRoot == null) {
                this.addTransactionalEditingDomainListeners(modelDescriptor.getEditingDomain());
                ModelLoadManager.INSTANCE.loadModel(modelDescriptor, true, null);
            }
            return modelRoot;
        }
        return null;
    }

    @Deprecated
    protected EObject getModelRoot(TransactionalEditingDomain editingDomain, IFile file) {
        Object modelRoot = this.getModelRoot((IResource)file);
        return modelRoot instanceof EObject ? (EObject)modelRoot : null;
    }

    @Deprecated
    protected Object getModelContentRoot(Object object) {
        if (object instanceof EObject) {
            return this.getModelContentRoot((EObject)object);
        }
        if (object instanceof IWrapperItemProvider) {
            return this.getModelContentRoot((IWrapperItemProvider)object);
        }
        if (object instanceof FeatureMap.Entry) {
            return this.getModelContentRoot((FeatureMap.Entry)object);
        }
        if (object instanceof TransientItemProvider) {
            return this.getModelContentRoot((TransientItemProvider)object);
        }
        return null;
    }

    @Deprecated
    protected Object getModelContentRoot(EObject object) {
        Assert.isNotNull((Object)object);
        Object mappedModelRoot = this.getMappedModelRoot(object);
        if (mappedModelRoot != null) {
            return mappedModelRoot;
        }
        return object.eResource();
    }

    @Deprecated
    protected Object getMappedModelRoot(EObject object) {
        return null;
    }

    @Deprecated
    protected Object getModelContentRoot(IWrapperItemProvider wrapperItemProvider) {
        Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)wrapperItemProvider);
        return this.getModelContentRoot(unwrapped);
    }

    @Deprecated
    protected Object getModelContentRoot(FeatureMap.Entry entry) {
        Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)entry);
        return this.getModelContentRoot(unwrapped);
    }

    @Deprecated
    protected Object getModelContentRoot(TransientItemProvider transientItemProvider) {
        Notifier target = transientItemProvider.getTarget();
        return this.getModelContentRoot(target);
    }

    @Deprecated
    protected IResource getUnderlyingWorkspaceResource(Object modelContentRoot) {
        return EcorePlatformUtil.getFile((Object)modelContentRoot);
    }

    protected AdapterFactoryContentProvider getModelContentProvider(Object object) {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)object);
        if (editingDomain != null) {
            AdapterFactoryContentProvider modelContentProvider = this.modelContentProviders.get(editingDomain);
            if (modelContentProvider == null) {
                modelContentProvider = this.createModelContentProvider(editingDomain);
                this.modelContentProviders.put(editingDomain, modelContentProvider);
                this.addTransactionalEditingDomainListeners(editingDomain);
            }
            return modelContentProvider;
        }
        return null;
    }

    protected AdapterFactoryContentProvider createModelContentProvider(final TransactionalEditingDomain editingDomain) {
        Assert.isNotNull((Object)editingDomain);
        AdapterFactory adapterFactory = this.getAdapterFactory(editingDomain);
        return new TransactionalAdapterFactoryContentProvider(editingDomain, adapterFactory){

            protected <T> T run(RunnableWithResult<? extends T> run) {
                try {
                    return (T)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, run);
                }
                catch (Exception e) {
                    Tracing.catching(TransactionalAdapterFactoryLabelProvider.class, (String)"run", (Throwable)e);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
        };
    }

    protected AdapterFactory getAdapterFactory(TransactionalEditingDomain editingDomain) {
        AdapterFactory customAdapterFactory = this.getCustomAdapterFactory();
        if (customAdapterFactory != null) {
            return customAdapterFactory;
        }
        if (editingDomain != null) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    protected AdapterFactory getCustomAdapterFactory() {
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        try {
            if (parentElement instanceof IResource) {
                Resource modelResource = this.getModelResource((IResource)parentElement);
                AdapterFactoryContentProvider contentProvider = this.getModelContentProvider(modelResource);
                if (contentProvider != null) {
                    contentProvider.inputChanged(this.viewer, null, (Object)modelResource);
                    for (Object modelContentRoot : this.getModelContentRoots(modelResource)) {
                        children.addAll(Arrays.asList(contentProvider.getChildren(modelContentRoot)));
                    }
                }
            } else {
                AdapterFactoryContentProvider contentProvider = this.getModelContentProvider(parentElement);
                if (contentProvider != null) {
                    children.addAll(Arrays.asList(contentProvider.getChildren(parentElement)));
                }
            }
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
        }
        return children.toArray(new Object[children.size()]);
    }

    public Object getParent(Object element) {
        Resource modelResource;
        List<Object> modelContentRoots;
        Object parent = null;
        AdapterFactoryContentProvider contentProvider = this.getModelContentProvider(element);
        if (contentProvider != null) {
            parent = contentProvider.getParent(element);
        }
        if ((modelContentRoots = this.getModelContentRoots(modelResource = EcoreResourceUtil.getResource(parent))).contains(parent)) {
            return this.getWorkspaceResource(modelResource);
        }
        return parent;
    }

    public void dispose() {
        for (TransactionalEditingDomain editingDomain : this.modelContentProviders.keySet()) {
            this.removeTransactionalEditingDomainListeners(editingDomain);
            AdapterFactoryContentProvider modelContentProvider = this.modelContentProviders.get(editingDomain);
            modelContentProvider.dispose();
        }
        this.modelContentProviders.clear();
        if (this.resourceMarkerChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceMarkerChangeListener);
        }
        this.resourceMarkerChangeListener = null;
    }

    protected void addTransactionalEditingDomainListeners(TransactionalEditingDomain editingDomain) {
        Assert.isNotNull((Object)editingDomain);
        if (this.resourceChangedListener == null) {
            this.resourceChangedListener = this.createResourceChangedListener();
            Assert.isNotNull((Object)this.resourceChangedListener);
        }
        editingDomain.addResourceSetListener(this.resourceChangedListener);
        if (this.resourceMovedListener == null) {
            this.resourceMovedListener = this.createResourceMovedListener();
            Assert.isNotNull((Object)this.resourceMovedListener);
        }
        editingDomain.addResourceSetListener(this.resourceMovedListener);
        if (this.crossReferenceChangedListener == null) {
            this.crossReferenceChangedListener = this.createCrossReferenceChangedListener();
            Assert.isNotNull((Object)this.crossReferenceChangedListener);
        }
        editingDomain.addResourceSetListener(this.crossReferenceChangedListener);
        if (this.modelContentRootChangedListener == null) {
            this.modelContentRootChangedListener = this.createModelContentRootChangedListener();
            Assert.isNotNull((Object)this.modelContentRootChangedListener);
        }
        editingDomain.addResourceSetListener(this.modelContentRootChangedListener);
    }

    protected void removeTransactionalEditingDomainListeners(TransactionalEditingDomain editingDomain) {
        Assert.isNotNull((Object)editingDomain);
        if (this.resourceChangedListener != null) {
            editingDomain.removeResourceSetListener(this.resourceChangedListener);
        }
        if (this.resourceMovedListener != null) {
            editingDomain.removeResourceSetListener(this.resourceMovedListener);
        }
        if (this.crossReferenceChangedListener != null) {
            editingDomain.removeResourceSetListener(this.crossReferenceChangedListener);
        }
        if (this.modelContentRootChangedListener != null) {
            editingDomain.removeResourceSetListener(this.modelContentRootChangedListener);
        }
    }

    protected ResourceSetListener createResourceChangedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)4).or(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResourceSet(), (int)0))){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                HashSet<Resource> loadedResources = new HashSet<Resource>();
                HashSet<Resource> unloadedResources = new HashSet<Resource>();
                HashSet<Resource> addedResources = new HashSet<Resource>();
                HashSet<Resource> removedResources = new HashSet<Resource>();
                for (Notification notification : event.getNotifications()) {
                    Object newValue;
                    Object notifier = notification.getNotifier();
                    if (notifier instanceof Resource) {
                        Resource resource = (Resource)notifier;
                        newValue = (Boolean)notification.getNewValue();
                        if (((Boolean)newValue).booleanValue()) {
                            if (unloadedResources.contains(resource)) {
                                unloadedResources.remove(resource);
                                continue;
                            }
                            loadedResources.add(resource);
                            continue;
                        }
                        if (loadedResources.contains(resource)) {
                            loadedResources.remove(resource);
                            continue;
                        }
                        unloadedResources.add(resource);
                        continue;
                    }
                    if (!(notifier instanceof ResourceSet)) continue;
                    if (notification.getEventType() == 3 || notification.getEventType() == 5) {
                        ArrayList<Resource> newResources = new ArrayList<Resource>();
                        newValue = notification.getNewValue();
                        if (newValue instanceof List) {
                            List newResourcesValue = (List)newValue;
                            newResources.addAll(newResourcesValue);
                        } else if (newValue instanceof Resource) {
                            newResources.add((Resource)newValue);
                        }
                        for (Resource newResource : newResources) {
                            if (removedResources.contains(newResource)) {
                                removedResources.remove(newResource);
                                continue;
                            }
                            addedResources.add(newResource);
                        }
                        continue;
                    }
                    if (notification.getEventType() != 4 && notification.getEventType() != 6) continue;
                    ArrayList<Resource> oldResources = new ArrayList<Resource>();
                    Object oldValue = notification.getOldValue();
                    if (oldValue instanceof List) {
                        List oldResourcesValue = (List)oldValue;
                        oldResources.addAll(oldResourcesValue);
                    } else if (oldValue instanceof Resource) {
                        oldResources.add((Resource)oldValue);
                    }
                    for (Resource oldResource : oldResources) {
                        if (addedResources.contains(oldResource)) {
                            addedResources.remove(oldResource);
                            continue;
                        }
                        removedResources.add(oldResource);
                    }
                }
                ModelResourceRefreshStrategy refreshStrategy = new ModelResourceRefreshStrategy(BasicExplorerContentProvider.this, true);
                refreshStrategy.getModelResourcesToRefresh().addAll(loadedResources);
                refreshStrategy.getModelResourcesToRefresh().addAll(addedResources);
                refreshStrategy.getModelResourcesToRefresh().addAll(unloadedResources);
                refreshStrategy.getModelResourcesToRefresh().addAll(removedResources);
                refreshStrategy.run();
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected ResourceSetListener createResourceMovedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)1)){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                HashSet<Resource> movedResources = new HashSet<Resource>();
                for (Notification notification : event.getNotifications()) {
                    movedResources.add((Resource)notification.getNotifier());
                }
                ModelResourceRefreshStrategy refreshStrategy = new ModelResourceRefreshStrategy(BasicExplorerContentProvider.this, false);
                refreshStrategy.getModelResourcesToRefresh().addAll(movedResources);
                refreshStrategy.run();
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected ResourceSetListener createCrossReferenceChangedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createNotifierTypeFilter(EObject.class)){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                ModelObjectRefreshStrategy refreshStrategy = new ModelObjectRefreshStrategy(BasicExplorerContentProvider.this);
                for (Notification notification : event.getNotifications()) {
                    EReference reference;
                    EObject object = (EObject)notification.getNotifier();
                    if (!(notification.getFeature() instanceof EReference) || (reference = (EReference)notification.getFeature()).isContainment() || reference.isContainer() || !(reference.getEType() instanceof EClass)) continue;
                    refreshStrategy.getModelObjectsToRefresh().add(object);
                }
                refreshStrategy.run();
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected ResourceSetListener createModelContentRootChangedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)2).or(NotificationFilter.createNotifierTypeFilter(EObject.class))){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                HashSet<EObject> addedObjects = new HashSet<EObject>();
                HashSet<EObject> removedObjects = new HashSet<EObject>();
                HashSet<EObject> changedObjects = new HashSet<EObject>();
                for (Notification notification : event.getNotifications()) {
                    Object notifier = notification.getNotifier();
                    if (!(notifier instanceof Resource) && !(notification.getFeature() instanceof EReference)) continue;
                    if (notification.getEventType() == 1 || notification.getEventType() == 3 || notification.getEventType() == 5) {
                        ArrayList<EObject> newValues = new ArrayList<EObject>();
                        Object newValue = notification.getNewValue();
                        if (newValue instanceof List) {
                            List newValueList = (List)newValue;
                            newValues.addAll(newValueList);
                        } else if (newValue instanceof EObject) {
                            newValues.add((EObject)newValue);
                        }
                        for (EObject value : newValues) {
                            if (removedObjects.contains(value)) {
                                removedObjects.remove(value);
                                continue;
                            }
                            addedObjects.add(value);
                        }
                        continue;
                    }
                    if (notification.getEventType() != 2 && notification.getEventType() != 4 && notification.getEventType() != 6) continue;
                    ArrayList<EObject> oldValues = new ArrayList<EObject>();
                    Object oldValue = notification.getOldValue();
                    if (oldValue instanceof List) {
                        List oldValueList = (List)oldValue;
                        oldValues.addAll(oldValueList);
                    } else if (oldValue instanceof EObject) {
                        oldValues.add((EObject)oldValue);
                    }
                    for (EObject value : oldValues) {
                        if (addedObjects.contains(value)) {
                            addedObjects.remove(value);
                            continue;
                        }
                        removedObjects.add(value);
                    }
                }
                changedObjects.addAll(addedObjects);
                changedObjects.addAll(removedObjects);
                WorkspaceResourceRefreshStrategy refreshStrategy = new WorkspaceResourceRefreshStrategy(BasicExplorerContentProvider.this, true);
                for (EObject changedObject : changedObjects) {
                    Object changedObjectParent = BasicExplorerContentProvider.this.getParent(changedObject);
                    if (!(changedObjectParent instanceof IResource)) continue;
                    refreshStrategy.getWorkspaceResourcesToRefresh().add((IResource)changedObjectParent);
                }
                refreshStrategy.run();
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected IResourceChangeListener createResourceMarkerChangeListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IMarkerDelta[] markerDelta = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
                if (markerDelta != null && markerDelta.length > 0) {
                    FullRefreshStrategy refreshStrategy = new FullRefreshStrategy(BasicExplorerContentProvider.this, false);
                    refreshStrategy.run();
                }
            }
        };
    }
}

