/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;

public class WindowUtil {
    public static final int HWND_TOP = 0;
    public static final int HWND_TOPMOST = -1;
    public static final int HWND_NOTOPMOST = -2;
    public static final int HWND_BOTTOM = 1;
    public static final int SWP_NOSIZE = 1;
    public static final int SWP_NOMOVE = 2;
    public static final int WS_EX_LAYERED = 524288;
    public static final int LWA_COLORKEY = 1;
    public static final int LWA_ALPHA = 2;

    static {
        try {
            System.loadLibrary("AccessibiltyWin32Library");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String GetWindowText(int hWnd) {
        int size = OS.GetWindowTextLength((int)hWnd);
        if (size == 0) {
            return "";
        }
        TCHAR buffer = new TCHAR(0, size + 1);
        return buffer.toString(0, OS.GetWindowText((int)hWnd, (TCHAR)buffer, (int)buffer.length()));
    }

    public static String GetWindowClassName(int hWnd) {
        TCHAR buffer = new TCHAR(0, 256);
        return buffer.toString(0, OS.GetClassName((int)hWnd, (TCHAR)buffer, (int)buffer.length()));
    }

    public static Rectangle GetWindowRectangle(int hWnd) {
        RECT rect = new RECT();
        OS.GetWindowRect((int)hWnd, (RECT)rect);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public static boolean IsWindowVisible(int hWnd) {
        return OS.IsWindowVisible((int)hWnd);
    }

    public static int GetDesktopWindow() {
        return OS.GetDesktopWindow();
    }

    public static int GetChildWindow(int hWnd) {
        return OS.GetWindow((int)hWnd, (int)5);
    }

    public static int GetNextWindow(int hWnd) {
        return OS.GetWindow((int)hWnd, (int)2);
    }

    public static int GetOwnerWindow(int hWnd) {
        return OS.GetWindow((int)hWnd, (int)4);
    }

    public static int GetParentWindow(int hWnd) {
        return OS.GetParent((int)hWnd);
    }

    public static boolean isPopupMenu(int hwnd) {
        if ("#32768".equals(WindowUtil.GetWindowClassName(hwnd))) {
            return WindowUtil.GetOwnerWindow(hwnd) == 0;
        }
        return false;
    }

    public static int FindWindow(String windowClass, String windowName) {
        return OS.FindWindow((TCHAR)new TCHAR(0, windowClass, true), (TCHAR)new TCHAR(0, windowName, true));
    }

    public static boolean BringWindowToTop(int hWnd) {
        return OS.BringWindowToTop((int)hWnd);
    }

    public static boolean SetWindowPos(int hWnd, int hWndInsertAfter, int X, int Y, int cx, int cy, int uFlags) {
        return OS.SetWindowPos((int)hWnd, (int)hWndInsertAfter, (int)X, (int)Y, (int)cx, (int)cy, (int)uFlags);
    }

    protected static final native int SetLayeredWindowAttributes(int var0, int var1, char var2, int var3);
}

