/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ie;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.actf.model.internal.ui.editors.ie.WebBrowserIEControlSite;
import org.eclipse.actf.model.internal.ui.editors.ie.events.BeforeNavigate2Parameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.BrowserEventListener;
import org.eclipse.actf.model.internal.ui.editors.ie.events.DocumentCompleteParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.NavigateComplete2Parameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.NavigateErrorParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.NewWindow2Parameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.ProgressChangeParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.StatusTextChangeParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.TitleChangeParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.WindowClosingParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.impl.BeforeNavigate2ParametersImpl;
import org.eclipse.actf.model.internal.ui.editors.ie.events.impl.DocumentCompleteParametersImpl;
import org.eclipse.actf.model.internal.ui.editors.ie.events.impl.NavigateComplete2ParametersImpl;
import org.eclipse.actf.model.internal.ui.editors.ie.events.impl.NavigateErrorParametersImpl;
import org.eclipse.actf.model.internal.ui.editors.ie.events.impl.NewWindow2ParametersImpl;
import org.eclipse.actf.model.internal.ui.editors.ie.events.impl.ProgressChangeParametersImpl;
import org.eclipse.actf.model.internal.ui.editors.ie.events.impl.StatusTextChangeParametersImpl;
import org.eclipse.actf.model.internal.ui.editors.ie.events.impl.TitleChangeParametersImpl;
import org.eclipse.actf.model.internal.ui.editors.ie.events.impl.WindowClosingParametersImpl;
import org.eclipse.actf.model.internal.ui.editors.ie.win32.IPersistFile;
import org.eclipse.actf.model.ui.ImagePositionInfo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBrowserIEComposite
extends Composite {
    public static final int SCROLL_BY = 0;
    public static final int SCROLL_TO = 1;
    OleFrame frame;
    OleControlSite site;
    OleAutomation auto;
    boolean disposing = false;
    boolean bDisableScriptDebugger = false;
    private BrowserEventListener[] eventListeners = new BrowserEventListener[0];
    static final String BROWSER_PROGID = "Shell.Explorer";
    private int oldProc = 0;
    private boolean isClosed = false;
    private static final int EventID_BEFORENAVIGATE = 100;
    private static final int EventID_NAVIGATECOMPLETE = 101;
    private static final int EventID_STATUSTEXTCHANGE = 102;
    private static final int EventID_QUIT = 103;
    private static final int EventID_DOWNLOADCOMPLETE = 104;
    private static final int EventID_COMMANDSTATECHANGE = 105;
    private static final int EventID_DOWNLOADBEGIN = 106;
    private static final int EventID_NEWWINDOW = 107;
    private static final int EventID_PROGRESSCHANGE = 108;
    private static final int EventID_WINDOWMOVE = 109;
    private static final int EventID_WINDOWRESIZE = 110;
    private static final int EventID_WINDOWACTIVATE = 111;
    private static final int EventID_PROPERTYCHANGE = 112;
    private static final int EventID_TITLECHANGE = 113;
    private static final int EventID_TITLEICONCHANGE = 114;
    private static final int EventID_FRAMEBEFORENAVIGATE = 200;
    private static final int EventID_FRAMENAVIGATECOMPLETE = 201;
    private static final int EventID_FRAMENEWWINDOW = 204;
    private static final int EventID_BEFORENAVIGATE2 = 250;
    private static final int EventID_NEWWINDOW2 = 251;
    private static final int EventID_NAVIGATECOMPLETE2 = 252;
    private static final int EventID_ONQUIT = 253;
    private static final int EventID_ONVISIBLE = 254;
    private static final int EventID_ONTOOLBAR = 255;
    private static final int EventID_ONMENUBAR = 256;
    private static final int EventID_ONSTATUSBAR = 257;
    private static final int EventID_ONFULLSCREEN = 258;
    private static final int EventID_DOCUMENTCOMPLETE = 259;
    private static final int EventID_ONTHEATERMODE = 260;
    private static final int EventID_ONADDRESSBAR = 261;
    private static final int EventID_WINDOWSETRESIZABLE = 262;
    private static final int EventID_WINDOWCLOSING = 263;
    private static final int EventID_WINDOWSETLEFT = 264;
    private static final int EventID_WINDOWSETTOP = 265;
    private static final int EventID_WINDOWSETWIDTH = 266;
    private static final int EventID_WINDOWSETHEIGHT = 267;
    private static final int EventID_CLIENTTOHOSTWINDOW = 268;
    private static final int EventID_SETSECURELOCKICON = 269;
    private static final int EventID_FILEDOWNLOAD = 270;
    private static final int EventID_NAVIGATEERROR = 271;
    private static final int EventID_PRIVACYIMPACTEDSTATECHANGE = 272;
    private static final int EventID_NEWWINDOW3 = 273;

    public WebBrowserIEComposite(Composite parent, int style) {
        super(parent, style);
        try {
            this.frame = new OleFrame((Composite)this, 0);
            this.frame.setLayoutData((Object)new GridData(1808));
            this.site = new WebBrowserIEControlSite((Composite)this.frame, 0, BROWSER_PROGID);
            this.site.doVerb(-5);
            this.auto = new OleAutomation((OleClientSite)this.site);
        }
        catch (SWTException sWTException) {
            this.dispose();
            SWT.error((int)2);
        }
        this.setBrowserBoolean("RegisterAsBrowser", true);
        this.setBrowserBoolean("RegisterAsDropTarget", true);
        Listener swtListener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 12: {
                        if (WebBrowserIEComposite.this.disposing) break;
                        WebBrowserIEComposite.this.disposing = true;
                        WebBrowserIEComposite.this.notifyListeners(e.type, e);
                        e.type = 0;
                        if (WebBrowserIEComposite.this.auto == null) break;
                        WebBrowserIEComposite.this.auto.dispose();
                        WebBrowserIEComposite.this.auto = null;
                        break;
                    }
                    case 11: {
                        WebBrowserIEComposite.this.frame.setBounds(WebBrowserIEComposite.this.getClientArea());
                    }
                }
            }
        };
        this.addListener(12, swtListener);
        this.addListener(11, swtListener);
        Listener keyListener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 1: 
                    case 2: {
                        WebBrowserIEComposite.this.notifyListeners(e.type, e);
                    }
                }
            }
        };
        this.site.addListener(1, keyListener);
        this.site.addListener(2, keyListener);
        OleListener browserListener = new OleListener(){

            public void handleEvent(OleEvent event) {
                if (WebBrowserIEComposite.this.auto != null) {
                    try {
                        switch (event.type) {
                            case 250: {
                                WebBrowserIEComposite.this.onBeforeNavigate2(new BeforeNavigate2ParametersImpl(event));
                                break;
                            }
                            case 252: {
                                WebBrowserIEComposite.this.onNavigateComplete2(new NavigateComplete2ParametersImpl(event));
                                break;
                            }
                            case 271: {
                                WebBrowserIEComposite.this.onNavigateError(new NavigateErrorParametersImpl(event));
                                break;
                            }
                            case 259: {
                                WebBrowserIEComposite.this.onDocumentComplete(new DocumentCompleteParametersImpl(event));
                                break;
                            }
                            case 251: {
                                WebBrowserIEComposite.this.onNewWindow2(new NewWindow2ParametersImpl(event));
                                break;
                            }
                            case 263: {
                                WebBrowserIEComposite.this.onWindowClosing(new WindowClosingParametersImpl(event));
                                break;
                            }
                            case 102: {
                                WebBrowserIEComposite.this.onStatusTextChange(new StatusTextChangeParametersImpl(event));
                                break;
                            }
                            case 113: {
                                WebBrowserIEComposite.this.onTitleChange(new TitleChangeParametersImpl(event));
                                break;
                            }
                            case 108: {
                                WebBrowserIEComposite.this.onProgressChange(new ProgressChangeParametersImpl(event));
                                break;
                            }
                            default: {
                                System.out.println("event.type=" + event.type + " ,event.arguments=" + WebBrowserIEComposite.dumpArags(event.arguments));
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        System.err.println(WebBrowserIEComposite.dumpArags(event.arguments));
                        e.printStackTrace();
                    }
                }
            }
        };
        this.site.addEventListener(250, browserListener);
        this.site.addEventListener(259, browserListener);
        this.site.addEventListener(252, browserListener);
        this.site.addEventListener(271, browserListener);
        this.site.addEventListener(251, browserListener);
        this.site.addEventListener(108, browserListener);
        this.site.addEventListener(102, browserListener);
        this.site.addEventListener(113, browserListener);
        this.site.addEventListener(263, browserListener);
        Callback callback = new Callback((Object)this, "siteWindowProc", 4);
        int address = callback.getAddress();
        if (address != 0) {
            this.oldProc = OS.GetWindowLong((int)this.site.handle, (int)-4);
            OS.SetWindowLong((int)this.site.handle, (int)-4, (int)address);
        } else {
            callback.dispose();
        }
    }

    public void addBrowserEventListener(BrowserEventListener listener) {
        Set<BrowserEventListener> set = this.getEventListeners();
        set.add(listener);
        this.setEventListeners(set);
    }

    public void removeBrowserEventListener(BrowserEventListener listener) {
        Set<BrowserEventListener> set = this.getEventListeners();
        set.remove(listener);
        this.setEventListeners(set);
    }

    public int getLeft() {
        return this.getBrowserInteger("Left");
    }

    public int getTop() {
        return this.getBrowserInteger("Top");
    }

    public int getWidth() {
        return this.getBrowserInteger("Width");
    }

    public int getHeight() {
        return this.getBrowserInteger("Height");
    }

    public int getReadyState() {
        return this.getBrowserInteger("ReadyState");
    }

    public String getType() {
        return this.getBrowserString("Type");
    }

    public String getLocationURL() {
        return this.getBrowserString("LocationURL");
    }

    public String getLocationName() {
        return this.getBrowserString("LocationName");
    }

    public boolean getSilent() {
        return this.getBrowserBoolean("Silent");
    }

    public void setSilent(boolean silent) {
        this.setBrowserBoolean("Silent", silent);
    }

    public boolean getDisableScriptDebugger() {
        return this.bDisableScriptDebugger;
    }

    public void setDisableScriptDebugger(boolean bDisable) {
        this.bDisableScriptDebugger = bDisable;
    }

    public boolean goBack() {
        return this.invokeBrowserMethod("GoBack");
    }

    public boolean goForward() {
        return this.invokeBrowserMethod("GoForward");
    }

    public boolean stop() {
        return this.invokeBrowserMethod("Stop");
    }

    public boolean refresh() {
        return this.invokeBrowserMethod("Refresh");
    }

    public boolean navigate(String url) {
        int[] pIdNavigate = this.auto.getIDsOfNames(new String[]{"Navigate", "URL"});
        if (pIdNavigate != null) {
            Variant varUrl = new Variant(url);
            Variant varResult = this.auto.invoke(pIdNavigate[0], new Variant[]{varUrl}, new int[]{pIdNavigate[1]});
            varUrl.dispose();
            if (varResult != null) {
                boolean result = varResult.getType() == 0;
                varResult.dispose();
                return result;
            }
        }
        return false;
    }

    public boolean navigate2(String url, int flags, String targetFrameName, Object postData, String headers) {
        int[] pIdNavigate2 = this.auto.getIDsOfNames(new String[]{"Navigate2"});
        if (pIdNavigate2 != null) {
            Variant varHeaders;
            Variant varUrl = new Variant(url);
            Variant varFlags = new Variant(flags);
            Variant varTargetFrameName = targetFrameName == null ? new Variant() : new Variant(targetFrameName);
            Variant variant = varHeaders = headers == null ? new Variant() : new Variant(headers);
            if (!(postData instanceof Variant)) {
                postData = new Variant();
            }
            Variant varResult = this.auto.invoke(pIdNavigate2[0], new Variant[]{varUrl, varFlags, varTargetFrameName, (Variant)postData, varHeaders});
            varUrl.dispose();
            varFlags.dispose();
            varTargetFrameName.dispose();
            varHeaders.dispose();
            if (varResult != null) {
                boolean result = varResult.getType() == 0;
                varResult.dispose();
                return result;
            }
        }
        return false;
    }

    public boolean setFontSize(int nSize) {
        Variant varIn = new Variant(nSize);
        try {
            boolean bl = this.site.exec(19, 2, varIn, null) == 0;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            varIn.dispose();
        }
        return false;
    }

    public int getFontSize() {
        Variant varOut = new Variant();
        try {
            if (this.site.exec(19, 2, null, varOut) == 0 && 3 == varOut.getType()) {
                int n = varOut.getInt();
                return n;
            }
        }
        catch (Exception exception) {
        }
        finally {
            varOut.dispose();
        }
        return -1;
    }

    /*
     * Exception decompiling
     */
    public boolean saveLiveDom(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean save(String fileName) {
        Variant varDocument = this.getBrowserVariant("Document");
        if (varDocument != null) {
            try {
                boolean bl = WebBrowserIEComposite.saveDocument(varDocument, fileName);
                return bl;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                varDocument.dispose();
            }
        }
        return false;
    }

    public int getBrowserAddress() {
        Variant variant = new Variant(this.auto);
        return variant.getDispatch().getAddress();
    }

    public int[] getWholeSize() {
        int[] result = new int[]{-1, -1};
        Variant varDocument = this.getBrowserVariant("Document");
        if (varDocument != null) {
            try {
                try {
                    OleAutomation document;
                    block14: {
                        document = varDocument.getAutomation();
                        Variant varDocEle = this.getVariant(document, "documentElement");
                        if (varDocEle != null) {
                            try {
                                try {
                                    OleAutomation docEle = varDocEle.getAutomation();
                                    result[0] = this.getIntFromOleAutomation(docEle, "scrollWidth");
                                    result[1] = this.getIntFromOleAutomation(docEle, "scrollHeight");
                                    docEle.dispose();
                                    int[] bodySize = this.getBodySize(document);
                                    if (result[0] < bodySize[0]) {
                                        result[0] = bodySize[0];
                                    }
                                    if (result[1] < bodySize[1]) {
                                        result[1] = bodySize[1];
                                    }
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                    varDocEle.dispose();
                                    break block14;
                                }
                            }
                            catch (Throwable throwable) {
                                varDocEle.dispose();
                                throw throwable;
                            }
                            varDocEle.dispose();
                        }
                    }
                    document.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    varDocument.dispose();
                }
            }
            finally {
                varDocument.dispose();
            }
        }
        return result;
    }

    public ImagePositionInfo[] getAllImagePosition() {
        ImagePositionInfo[] result;
        block11: {
            result = new ImagePositionInfo[]{};
            Variant varDocument = this.getBrowserVariant("Document");
            if (varDocument != null) {
                try {
                    try {
                        OleAutomation document = varDocument.getAutomation();
                        Variant varImages = this.getVariant(document, "images");
                        document.dispose();
                        if (varImages == null) break block11;
                        try {
                            try {
                                OleAutomation images = varImages.getAutomation();
                                result = this.getAllImagePosition(images);
                                images.dispose();
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                varImages.dispose();
                            }
                        }
                        finally {
                            varImages.dispose();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        varDocument.dispose();
                    }
                }
                finally {
                    varDocument.dispose();
                }
            }
        }
        return result;
    }

    public boolean scroll(int x, int y, int type) {
        block14: {
            Variant varDocument;
            if ((type == 0 || type == 1) && (varDocument = this.getBrowserVariant("Document")) != null) {
                try {
                    OleAutomation window;
                    Variant varWindow;
                    block15: {
                        int[] idScroll;
                        OleAutomation document = varDocument.getAutomation();
                        varWindow = this.getVariant(document, "parentWindow");
                        document.dispose();
                        if (varWindow == null) break block14;
                        window = varWindow.getAutomation();
                        String scrollType = "scrollBy";
                        if (type == 1) {
                            scrollType = "scrollTo";
                        }
                        if ((idScroll = window.getIDsOfNames(new String[]{scrollType})) == null) break block15;
                        window.invoke(idScroll[0], new Variant[]{new Variant(x), new Variant(y)});
                        window.dispose();
                        varWindow.dispose();
                        return true;
                    }
                    try {
                        try {
                            try {
                                window.dispose();
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                varWindow.dispose();
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            varWindow.dispose();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    varDocument.dispose();
                }
            }
        }
        return false;
    }

    protected void onBeforeNavigate2(BeforeNavigate2Parameters param) {
        int i = 0;
        while (i < this.eventListeners.length) {
            this.eventListeners[i].beforeNavigate2(param);
            ++i;
        }
    }

    protected void onNavigateComplete2(NavigateComplete2Parameters param) {
        int i = 0;
        while (i < this.eventListeners.length) {
            this.eventListeners[i].navigateComplete2(param);
            ++i;
        }
    }

    protected void onNavigateError(NavigateErrorParameters param) {
        int i = 0;
        while (i < this.eventListeners.length) {
            this.eventListeners[i].navigateError(param);
            ++i;
        }
    }

    protected void onDocumentComplete(DocumentCompleteParameters param) {
        int i = 0;
        while (i < this.eventListeners.length) {
            this.eventListeners[i].documentComplete(param);
            ++i;
        }
    }

    protected void onNewWindow2(NewWindow2Parameters param) {
        int i = 0;
        while (i < this.eventListeners.length) {
            this.eventListeners[i].newWindow2(param);
            ++i;
        }
    }

    protected void onWindowClosing(WindowClosingParameters param) {
        int i = 0;
        while (i < this.eventListeners.length) {
            this.eventListeners[i].windowClosing(param);
            ++i;
        }
    }

    protected void onWindowClosed() {
        int i = 0;
        while (i < this.eventListeners.length) {
            this.eventListeners[i].windowClosed();
            ++i;
        }
    }

    protected void onStatusTextChange(StatusTextChangeParameters param) {
        int i = 0;
        while (i < this.eventListeners.length) {
            this.eventListeners[i].statusTextChange(param);
            ++i;
        }
    }

    protected void onTitleChange(TitleChangeParameters param) {
        int i = 0;
        while (i < this.eventListeners.length) {
            this.eventListeners[i].titleChange(param);
            ++i;
        }
    }

    protected void onProgressChange(ProgressChangeParameters param) {
        int i = 0;
        while (i < this.eventListeners.length) {
            this.eventListeners[i].progressChange(param);
            ++i;
        }
    }

    private Set<BrowserEventListener> getEventListeners() {
        return new LinkedHashSet<BrowserEventListener>(Arrays.asList(this.eventListeners));
    }

    private void setEventListeners(Set<BrowserEventListener> set) {
        this.eventListeners = set.toArray(new BrowserEventListener[set.size()]);
    }

    private static boolean saveDocument(Variant varDocument, String fileName) {
        block6: {
            if (9 == varDocument.getType()) {
                boolean bl;
                int[] pPersistFile = new int[1];
                if (varDocument.getDispatch().QueryInterface(COM.IIDIPersistFile, pPersistFile) != 0) break block6;
                int pStrAddress = COM.SysAllocString((char[])(String.valueOf(fileName) + "\u0000").toCharArray());
                try {
                    bl = new IPersistFile(pPersistFile[0]).Save(pStrAddress, false) == 0;
                }
                catch (Throwable throwable) {
                    try {
                        COM.SysFreeString((int)pStrAddress);
                        throw throwable;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                COM.SysFreeString((int)pStrAddress);
                return bl;
            }
        }
        return false;
    }

    private boolean invokeBrowserMethod(String name) {
        Variant varResult;
        int[] pIdName = this.auto.getIDsOfNames(new String[]{name});
        if (pIdName != null && (varResult = this.auto.invoke(pIdName[0])) != null) {
            try {
                boolean bl = varResult.getType() == 0;
                return bl;
            }
            finally {
                varResult.dispose();
            }
        }
        return false;
    }

    private Variant getBrowserVariant(String name) {
        int[] pIdName = this.auto.getIDsOfNames(new String[]{name});
        if (pIdName != null) {
            return this.auto.getProperty(pIdName[0]);
        }
        return null;
    }

    private int getBrowserInteger(String name) {
        Variant varResult = this.getBrowserVariant(name);
        if (varResult != null) {
            try {
                int n = varResult.getInt();
                return n;
            }
            finally {
                varResult.dispose();
            }
        }
        return 0;
    }

    private String getBrowserString(String name) {
        Variant varResult = this.getBrowserVariant(name);
        if (varResult != null) {
            try {
                String string = varResult.getString();
                return string;
            }
            finally {
                varResult.dispose();
            }
        }
        return null;
    }

    private boolean getBrowserBoolean(String name) {
        Variant varResult = this.getBrowserVariant(name);
        if (varResult != null) {
            try {
                boolean bl = varResult.getBoolean();
                return bl;
            }
            finally {
                varResult.dispose();
            }
        }
        return false;
    }

    private boolean setBrowserVariant(String name, Variant var) {
        int[] pIdName = this.auto.getIDsOfNames(new String[]{name});
        if (pIdName != null) {
            return this.auto.setProperty(pIdName[0], var);
        }
        return false;
    }

    private boolean setBrowserInteger(String name, int value) {
        return this.setBrowserVariant(name, new Variant(value));
    }

    private boolean setBrowserString(String name, String value) {
        return this.setBrowserVariant(name, new Variant(value));
    }

    private boolean setBrowserBoolean(String name, boolean value) {
        return this.setBrowserVariant(name, new Variant(value));
    }

    private int[] getBodySize(OleAutomation document) {
        int[] result = new int[]{-1, -1};
        Variant varBody = this.getVariant(document, "body");
        if (varBody != null) {
            try {
                try {
                    OleAutomation body = varBody.getAutomation();
                    int scrollWidth = this.getIntFromOleAutomation(body, "scrollWidth");
                    int offsetLeft = this.getIntFromOleAutomation(body, "offsetLeft");
                    int scrollHeight = this.getIntFromOleAutomation(body, "scrollHeight");
                    int offsetTop = this.getIntFromOleAutomation(body, "offsetTop");
                    result[0] = scrollWidth + offsetLeft * 2;
                    result[1] = scrollHeight + offsetTop * 2;
                    body.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    varBody.dispose();
                }
            }
            finally {
                varBody.dispose();
            }
        }
        return result;
    }

    private ImagePositionInfo[] getAllImagePosition(OleAutomation images) {
        ImagePositionInfo[] result = new ImagePositionInfo[]{};
        int size = this.getIntFromOleAutomation(images, "length");
        if (size > -1) {
            ImagePositionInfo[] tmp = new ImagePositionInfo[size];
            int[] idItem = images.getIDsOfNames(new String[]{"Item"});
            int i = 0;
            while (i < size) {
                Variant varImage = images.invoke(idItem[0], new Variant[]{new Variant(i)});
                if (varImage != null) {
                    try {
                        try {
                            OleAutomation image = varImage.getAutomation();
                            int[] bcr = this.getBoundingClientRect(image);
                            int width = this.getIntFromOleAutomation(image, "Width");
                            int height = this.getIntFromOleAutomation(image, "Height");
                            String url = this.getStringFromOleAutomation(image, "src");
                            image.dispose();
                            tmp[i] = new ImagePositionInfo(bcr[0], bcr[1], width, height, url);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                            ImagePositionInfo[] imagePositionInfoArray = result;
                            varImage.dispose();
                            return imagePositionInfoArray;
                        }
                    }
                    finally {
                        varImage.dispose();
                    }
                }
                ++i;
            }
            result = tmp;
        }
        return result;
    }

    private int[] getBoundingClientRect(OleAutomation image) {
        int[] idBCR;
        Variant varBCR;
        int[] result = new int[2];
        if (image != null && (varBCR = image.invoke((idBCR = image.getIDsOfNames(new String[]{"getBoundingClientRect"}))[0])) != null) {
            try {
                try {
                    OleAutomation bcr = varBCR.getAutomation();
                    result = new int[]{this.getIntFromOleAutomation(bcr, "Left"), this.getIntFromOleAutomation(bcr, "Top")};
                    bcr.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    varBCR.dispose();
                }
            }
            finally {
                varBCR.dispose();
            }
        }
        return result;
    }

    private Variant getVariant(OleAutomation target, String name) {
        int[] pIdName;
        if (target != null && (pIdName = target.getIDsOfNames(new String[]{name})) != null) {
            return target.getProperty(pIdName[0]);
        }
        return null;
    }

    private int getIntFromOleAutomation(OleAutomation target, String name) {
        Variant varResult = this.getVariant(target, name);
        if (varResult != null) {
            try {
                int n = varResult.getInt();
                return n;
            }
            finally {
                varResult.dispose();
            }
        }
        return -1;
    }

    private String getStringFromOleAutomation(OleAutomation target, String name) {
        Variant varResult = this.getVariant(target, name);
        if (varResult != null) {
            try {
                String string = varResult.getString();
                return string;
            }
            finally {
                varResult.dispose();
            }
        }
        return "";
    }

    int siteWindowProc(int hwnd, int msg, int wParam, int lParam) {
        block3: {
            try {
                if (this.isClosed || 528 != msg || wParam != 2) break block3;
                this.isClosed = true;
                this.onWindowClosed();
                return 0;
            }
            catch (Exception exception) {
                System.out.println("error: siteWindowProc");
                return 0;
            }
        }
        return OS.CallWindowProc((int)this.oldProc, (int)hwnd, (int)msg, (int)wParam, (int)lParam);
    }

    private static String dumpArags(Variant[] args) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(String.valueOf(i) + ":");
            if (16396 == args[i].getType()) {
                int byRef = args[i].getByRef();
                short[] dataType = new short[1];
                COM.MoveMemory((short[])dataType, (int)byRef, (int)2);
                String strType = "";
                int type = dataType[0];
                if ((type & 0x4000) != 0) {
                    strType = "VT_BYREF|";
                    type &= 0xFFFFBFFF;
                }
                switch (type) {
                    case 11: {
                        strType = String.valueOf(strType) + "VT_BOOL";
                        break;
                    }
                    case 2: {
                        strType = String.valueOf(strType) + "VT_I2";
                        break;
                    }
                    case 3: {
                        strType = String.valueOf(strType) + "VT_I4";
                        break;
                    }
                    case 20: {
                        strType = String.valueOf(strType) + "VT_I8";
                        break;
                    }
                    case 4: {
                        strType = String.valueOf(strType) + "VT_R4";
                        break;
                    }
                    case 5: {
                        strType = String.valueOf(strType) + "VT_R8";
                        break;
                    }
                    case 8: {
                        strType = String.valueOf(strType) + "VT_BSTR";
                        break;
                    }
                    case 9: {
                        strType = String.valueOf(strType) + "VT_DISPATCH";
                        break;
                    }
                    case 13: {
                        strType = String.valueOf(strType) + "VT_UNKNOWN";
                        break;
                    }
                    case 0: {
                        strType = String.valueOf(strType) + "VT_EMPTY";
                        break;
                    }
                    case 12: {
                        strType = String.valueOf(strType) + "VT_VARIANT";
                        break;
                    }
                    default: {
                        strType = String.valueOf(strType) + "type=" + type;
                    }
                }
                sb.append("REF_VARIANT(" + strType + ")");
            } else {
                sb.append(args[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    private Variant invokeWindowMethod(String method, Variant[] vars) {
        block13: {
            Variant varDocument = this.getBrowserVariant("Document");
            if (varDocument != null) {
                try {
                    OleAutomation window;
                    Variant varWindow;
                    block14: {
                        OleAutomation document = varDocument.getAutomation();
                        varWindow = this.getVariant(document, "parentWindow");
                        document.dispose();
                        if (varWindow == null) break block13;
                        window = varWindow.getAutomation();
                        int[] id = window.getIDsOfNames(new String[]{method});
                        if (id == null) break block14;
                        Variant result = window.invoke(id[0], vars);
                        window.dispose();
                        Variant variant = result;
                        varWindow.dispose();
                        return variant;
                    }
                    try {
                        try {
                            try {
                                window.dispose();
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                varWindow.dispose();
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            varWindow.dispose();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    varDocument.dispose();
                }
            }
        }
        return null;
    }

    public boolean clearInterval(int id) {
        Variant varResult = this.invokeWindowMethod("clearInterval", new Variant[]{new Variant(id)});
        return varResult != null;
    }

    public boolean clearTimeout(int id) {
        Variant varResult = this.invokeWindowMethod("clearTimeout", new Variant[]{new Variant(id)});
        return varResult != null;
    }

    public int setInterval(String script, int interval) {
        Variant[] vars = new Variant[]{new Variant(script), new Variant((long)interval), new Variant("JavaScript"), new Variant(0L)};
        Variant varResult = this.invokeWindowMethod("setInterval", vars);
        if (varResult != null) {
            return varResult.getInt();
        }
        return -1;
    }

    public int setTimeout(String script, int msec) {
        Variant[] vars = new Variant[]{new Variant(script), new Variant((long)msec), new Variant("JavaScript"), new Variant(0L)};
        Variant varResult = this.invokeWindowMethod("setTimeout", vars);
        if (varResult != null) {
            return varResult.getInt();
        }
        return -1;
    }
}

