/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.html;

import java.util.HashSet;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.html.ElementImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.TextImpl;
import org.eclipse.actf.util.vocab.AbstractTerms;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.Vocabulary;
import org.eclipse.actf.util.win32.comclutch.ComPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLTerms
extends AbstractTerms {
    private static HTMLTerms instance;
    private static HashSet<String> headingTags;
    private static HashSet<String> listItemTags;
    private static HashSet<String> blockTags;
    private static HashSet<String> listTopTags;
    private static final HashSet<String> reducibleElementNames;

    static {
        headingTags = new HashSet();
        headingTags.add("H1".intern());
        headingTags.add("H2".intern());
        headingTags.add("H3".intern());
        headingTags.add("H4".intern());
        headingTags.add("H5".intern());
        headingTags.add("H6".intern());
        listItemTags = new HashSet();
        listItemTags.add("LI".intern());
        listItemTags.add("DT".intern());
        listTopTags = new HashSet();
        listTopTags.add("UL".intern());
        listTopTags.add("OL".intern());
        listTopTags.add("DL".intern());
        blockTags = new HashSet();
        blockTags.add("H1".intern());
        blockTags.add("H2".intern());
        blockTags.add("H3".intern());
        blockTags.add("H4".intern());
        blockTags.add("H5".intern());
        blockTags.add("H6".intern());
        blockTags.add("B".intern());
        blockTags.add("STRONG".intern());
        blockTags.add("DIV".intern());
        blockTags.add("SPAN".intern());
        blockTags.add("P".intern());
        blockTags.add("FONT".intern());
        reducibleElementNames = new HashSet();
        reducibleElementNames.add("FONT".intern());
        reducibleElementNames.add("BASEFONT".intern());
        reducibleElementNames.add("S".intern());
        reducibleElementNames.add("STRIKE".intern());
        reducibleElementNames.add("U".intern());
        reducibleElementNames.add("EM".intern());
        reducibleElementNames.add("STRONG".intern());
        reducibleElementNames.add("SPAN".intern());
        reducibleElementNames.add("VAR".intern());
        reducibleElementNames.add("CODE".intern());
        reducibleElementNames.add("CITE".intern());
        reducibleElementNames.add("ABBR".intern());
        reducibleElementNames.add("ACRONYM".intern());
        reducibleElementNames.add("Q".intern());
        reducibleElementNames.add("B".intern());
        reducibleElementNames.add("BIG".intern());
        reducibleElementNames.add("I".intern());
        reducibleElementNames.add("SMALL".intern());
        reducibleElementNames.add("TT".intern());
        reducibleElementNames.add("SUB".intern());
        reducibleElementNames.add("SUP".intern());
        reducibleElementNames.add("WBR".intern());
    }

    public boolean isAlterable(IEvalTarget target) {
        return this.isImage(target);
    }

    public static HTMLTerms getInstance() {
        if (instance == null) {
            instance = new HTMLTerms();
        }
        return instance;
    }

    public boolean isValidNode(IEvalTarget target) {
        ElementImpl element;
        String name;
        return !(target instanceof ElementImpl) || !"HEAD".equals(name = (element = (ElementImpl)target).getLocalName()) && !"MAP".equals(name);
    }

    public boolean isVisibleNode(IEvalTarget target) {
        return true;
    }

    public boolean isMultilineEdit(IEvalTarget target) {
        TextImpl text;
        Node parent;
        if (target instanceof ElementImpl) {
            ElementImpl element = (ElementImpl)target;
            String name = element.getLocalName();
            if ("TEXTAREA".equals(name)) {
                return true;
            }
        } else if (target instanceof TextImpl && (parent = (text = (TextImpl)target).getParentNode()) instanceof IEvalTarget) {
            return this.isMultilineEdit((IEvalTarget)parent);
        }
        return false;
    }

    public boolean isSelectOption(IEvalTarget target) {
        TextImpl text;
        Node parent;
        if (target instanceof ElementImpl) {
            ElementImpl element = (ElementImpl)target;
            String name = element.getLocalName();
            if ("OPTION".equals(name)) {
                return true;
            }
        } else if (target instanceof TextImpl && (parent = (text = (TextImpl)target).getParentNode()) instanceof IEvalTarget) {
            return this.isSelectOption((IEvalTarget)parent);
        }
        return false;
    }

    public boolean isInputable(IEvalTarget target) {
        TextImpl text;
        Node parent;
        if (target instanceof ElementImpl) {
            ElementImpl element = (ElementImpl)target;
            String name = element.getLocalName();
            if ("INPUT".equals(name)) {
                ElementImpl.InputType type = element.getInputType();
                if (type == null) {
                    return false;
                }
                return type.isEdit() || type.isPassword() || type.isFileEdit() || type.isCheckBox() || type.isRadio();
            }
            if ("TEXTAREA".equals(name)) {
                return true;
            }
        } else if (target instanceof TextImpl && (parent = (text = (TextImpl)target).getParentNode()) instanceof IEvalTarget) {
            return Vocabulary.isInputable().eval((IEvalTarget)parent);
        }
        return false;
    }

    public boolean isCombobox(IEvalTarget target) {
        TextImpl text;
        Node parent;
        if (target instanceof ElementImpl) {
            ElementImpl element = (ElementImpl)target;
            String name = element.getLocalName();
            if ("SELECT".equals(name)) {
                return true;
            }
        } else if (target instanceof TextImpl && (parent = (text = (TextImpl)target).getParentNode()) instanceof IEvalTarget) {
            return Vocabulary.isSelectable().eval((IEvalTarget)parent);
        }
        return false;
    }

    public boolean isMultiSelectable(IEvalTarget target) {
        TextImpl text;
        Node parent;
        if (target instanceof ElementImpl) {
            ElementImpl element = (ElementImpl)target;
            String name = element.getLocalName();
            if ("SELECT".equals(name)) {
                return (Boolean)Helper.get(element.getINode(), "multiple");
            }
        } else if (target instanceof TextImpl && (parent = (text = (TextImpl)target).getParentNode()) instanceof IEvalTarget) {
            return Vocabulary.isMultiSelectable().eval((IEvalTarget)parent);
        }
        return false;
    }

    public boolean isClickable(IEvalTarget target) {
        Node node;
        Node p;
        TextImpl text;
        Node parent;
        if (target instanceof TextImpl && (parent = (text = (TextImpl)target).getParentNode()) instanceof IEvalTarget) {
            return Vocabulary.isClickable().eval((IEvalTarget)parent);
        }
        if (target instanceof ElementImpl) {
            ElementImpl.InputType type;
            ElementImpl element = (ElementImpl)target;
            String name = element.getLocalName();
            String href = (String)Helper.get(element.getINode(), "href");
            if (("A".equals(name) || "AREA".equals(name)) && href != null && href.length() > 0) {
                return true;
            }
            if ("BUTTON".equals(name) || "OPTION".equals(name)) {
                return true;
            }
            if ("INPUT".equals(name) && (type = element.getInputType()) != null) {
                return type.isClickable();
            }
            if (Helper.hasProperty(element.getINode(), "onclick")) {
                return true;
            }
        }
        if (target instanceof Node && (p = (node = (Node)target).getParentNode()) instanceof IEvalTarget) {
            return Vocabulary.isClickable().eval((IEvalTarget)p);
        }
        return false;
    }

    public boolean isLink(IEvalTarget target) {
        Node node;
        Node p;
        TextImpl text;
        Node parent;
        if (target instanceof TextImpl && (parent = (text = (TextImpl)target).getParentNode()) instanceof IEvalTarget) {
            return Vocabulary.isLink().eval((IEvalTarget)parent);
        }
        if (target instanceof ElementImpl) {
            ElementImpl element = (ElementImpl)target;
            String name = element.getLocalName();
            String href = (String)Helper.get(element.getINode(), "href");
            if (("A".equals(name) || "AREA".equals(name)) && href != null && href.length() > 0) {
                return true;
            }
        }
        if (target instanceof Node && (p = (node = (Node)target).getParentNode()) instanceof IEvalTarget) {
            return Vocabulary.isLink().eval((IEvalTarget)p);
        }
        return false;
    }

    public boolean isCheckbox(IEvalTarget target) {
        ElementImpl element;
        ElementImpl.InputType type;
        if (target instanceof ElementImpl && (type = (element = (ElementImpl)target).getInputType()) != null) {
            return type.isCheckBox();
        }
        return false;
    }

    public boolean isChecked(IEvalTarget target) {
        Object obj;
        if (target instanceof ElementImpl && (obj = Helper.get(((ElementImpl)target).getINode(), "checked")) != null) {
            return (Boolean)obj;
        }
        return false;
    }

    public boolean isRadio(IEvalTarget target) {
        ElementImpl element;
        ElementImpl.InputType type;
        if (target instanceof ElementImpl && (type = (element = (ElementImpl)target).getInputType()) != null) {
            return type.isRadio();
        }
        return false;
    }

    public boolean isTextbox(IEvalTarget target) {
        ElementImpl element;
        ElementImpl.InputType type;
        if (target instanceof ElementImpl && (type = (element = (ElementImpl)target).getInputType()) != null) {
            return type.isEdit();
        }
        return false;
    }

    public boolean isPassword(IEvalTarget target) {
        ElementImpl element;
        ElementImpl.InputType type;
        if (target instanceof ElementImpl && (type = (element = (ElementImpl)target).getInputType()) != null) {
            return type.isPassword();
        }
        return false;
    }

    public boolean isButton(IEvalTarget target) {
        ElementImpl element;
        ElementImpl.InputType type;
        if (target instanceof ElementImpl && (type = (element = (ElementImpl)target).getInputType()) != null) {
            return type.isButton();
        }
        return false;
    }

    private boolean isInTags(IEvalTarget target, HashSet<String> tags) {
        ElementImpl element;
        String name;
        return target instanceof ElementImpl && tags.contains((name = (element = (ElementImpl)target).getNodeName()).intern());
    }

    public boolean isListTop(IEvalTarget target) {
        if (this.isInTags(target, listTopTags) && target instanceof Element) {
            Element e = (Element)target;
            NodeList nl = e.getChildNodes();
            int count = 0;
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                if (n instanceof IEvalTarget && this.isListItem((IEvalTarget)n)) {
                    ++count;
                }
                ++i;
            }
            if (count > 1) {
                return true;
            }
        }
        return false;
    }

    public boolean isListItem(IEvalTarget target) {
        return this.isListItemJumpPoint(target);
    }

    public boolean isFileEdit(IEvalTarget target) {
        ElementImpl element;
        ElementImpl.InputType type;
        if (target instanceof ElementImpl && (type = (element = (ElementImpl)target).getInputType()) != null) {
            return type.isFileEdit();
        }
        return false;
    }

    public boolean isEmbeddedObject(IEvalTarget target) {
        ElementImpl element;
        String name;
        return target instanceof ElementImpl && ("EMBED".equals(name = (element = (ElementImpl)target).getLocalName()) || "OBJECT".equals(name));
    }

    public boolean isImage(IEvalTarget target) {
        if (!(target instanceof ElementImpl)) {
            return false;
        }
        ElementImpl element = (ElementImpl)target;
        String name = element.getLocalName();
        return "IMG".equals(name);
    }

    public boolean hasContent(IEvalTarget target) {
        if (this.isMultilineEdit(target) && target instanceof Element) {
            return !this.hasContent((IEvalTarget)((Element)target).getFirstChild());
        }
        if (this.isInputable(target)) {
            return true;
        }
        if (this.isListTop(target)) {
            return true;
        }
        return super.hasContent(target);
    }

    public boolean isReducible(IEvalTarget target) {
        if (!(target instanceof ElementImpl)) {
            return false;
        }
        ElementImpl element = (ElementImpl)target;
        String name = element.getLocalName().intern();
        return reducibleElementNames.contains(name);
    }

    public boolean isVisitedLink(IEvalTarget target) {
        if (!(target instanceof INodeEx)) {
            return false;
        }
        INodeEx nex = (INodeEx)target;
        String url = nex.getLinkURI();
        if (url == null) {
            return false;
        }
        return ComPlugin.getDefault().getBrowserHistory().isVisited(url);
    }

    public boolean isHeadingJumpPoint(IEvalTarget target) {
        return this.isJumpPoint(target, headingTags);
    }

    public boolean isListItemJumpPoint(IEvalTarget target) {
        return this.isJumpPoint(target, listItemTags);
    }

    public boolean isBlockJumpPointF(IEvalTarget target) {
        return this.isJumpPoint(target, blockTags, 3) || this.isJumpPoint2(target, headingTags, 3);
    }

    public boolean isBlockJumpPointB(IEvalTarget target) {
        return this.isJumpPoint(target, blockTags, 3) || this.isJumpPoint2(target, headingTags, 3);
    }

    private boolean isJumpPoint(IEvalTarget target, HashSet<String> tags) {
        return this.isJumpPoint(target, tags, 100);
    }

    private boolean isJumpPoint(IEvalTarget target, HashSet<String> tags, int depth) {
        Element element;
        String name;
        if (depth <= 0) {
            return false;
        }
        if (target instanceof Element && tags.contains((name = (element = (Element)target).getLocalName()).intern())) {
            return true;
        }
        if (!(target instanceof Node)) {
            return false;
        }
        Node node = (Node)target;
        Node prev = node.getPreviousSibling();
        while (prev != null) {
            if (this.hasText(prev)) {
                return false;
            }
            prev = prev.getPreviousSibling();
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        if (parent instanceof IEvalTarget) {
            return this.isJumpPoint((IEvalTarget)parent, tags, depth - 1);
        }
        return false;
    }

    private boolean isJumpPoint2(IEvalTarget target, HashSet<String> tags, int depth) {
        Element element;
        String name;
        if (depth <= 0) {
            return false;
        }
        if (target instanceof Element && tags.contains((name = (element = (Element)target).getLocalName()).intern())) {
            return true;
        }
        if (!(target instanceof Node)) {
            return false;
        }
        Node node = (Node)target;
        Node parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        if (parent instanceof IEvalTarget) {
            return this.isJumpPoint((IEvalTarget)parent, tags, depth - 1);
        }
        return false;
    }

    private boolean hasText(Node prev) {
        if (prev instanceof INodeEx) {
            INodeEx nex = (INodeEx)prev;
            if (nex.hasChildNodes()) {
                NodeList list = nex.getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node cn = list.item(i);
                    if (this.hasText(cn)) {
                        return true;
                    }
                    ++i;
                }
            } else if (nex.extractString().length() > 0) {
                return true;
            }
        }
        return false;
    }

    public boolean isAccessKey(char key, IEvalTarget node) {
        if (!(node instanceof INodeEx)) {
            return false;
        }
        INodeEx nex = (INodeEx)node;
        char c = nex.getAccessKey();
        return c == key;
    }

    public boolean isReachable(IEvalTarget evalTarget, Node target) {
        if (!(evalTarget instanceof Node)) {
            return false;
        }
        Node node = (Node)evalTarget;
        Node a1 = this.searchNonReducibleAncestor(node);
        if (a1 == null) {
            return false;
        }
        Node a2 = this.searchNonReducibleAncestor(target);
        if (a2 == null) {
            return false;
        }
        if (a1.getParentNode() == null) {
            return false;
        }
        if (a2.getParentNode() == null) {
            return false;
        }
        if (!a1.getParentNode().isSameNode(a2.getParentNode())) {
            return false;
        }
        if (a1 instanceof IEvalTarget && a2 instanceof IEvalTarget) {
            IEvalTarget t1 = (IEvalTarget)a1;
            IEvalTarget t2 = (IEvalTarget)a2;
            if (this.isLink(t1) && this.isLink(t2)) {
                return true;
            }
            if (this.isButton(t1) && this.isButton(t2)) {
                return true;
            }
        }
        Node start = node;
        Node end = target;
        if (end instanceof Text) {
            end = this.getPrev(end);
        }
        if (end == null) {
            return false;
        }
        Node next = this.getNext(start);
        while (next != null) {
            if (!(next instanceof IEvalTarget)) {
                next = this.getNext(next);
                continue;
            }
            if (!Vocabulary.isReducible().eval((IEvalTarget)next)) {
                return false;
            }
            if (next.isSameNode(end)) break;
            next = this.getNext(next);
        }
        return true;
    }

    private Node getPrev(Node node) {
        Node prev = node.getPreviousSibling();
        if (prev != null) {
            return prev;
        }
        return node.getParentNode();
    }

    private Node getNext(Node node) {
        Node next = node.getNextSibling();
        if (next != null) {
            return next;
        }
        return node.getParentNode();
    }

    private Node searchNonReducibleAncestor(Node node) {
        Node child = null;
        Node parent = node;
        while (parent != null && parent instanceof IEvalTarget && (parent instanceof Text || this.isImage((IEvalTarget)parent)) || this.isReducible((IEvalTarget)parent)) {
            child = parent;
            parent = parent.getParentNode();
        }
        return child;
    }
}

