/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.core.config;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.actf.core.config.ConfigurationException;
import org.eclipse.actf.core.config.IConfiguration;
import org.eclipse.actf.util.resources.ClassLoaderCache;

public class AbstractConfiguration
implements IConfiguration {
    static final long serialVersionUID = -1301837737929422833L;
    protected Map _configMap = new HashMap();
    protected String _curPool;

    public AbstractConfiguration() {
        this.createSymbolPool("actf");
    }

    public Map getSymbolPoolContents(String poolID) {
        return (Map)this._configMap.get(poolID);
    }

    public void setSymbolPool(String id) {
        if (id == null || !this._configMap.containsKey(id)) {
            throw new IllegalArgumentException("No pool with id " + id);
        }
        this._curPool = id;
    }

    public void createSymbolPool(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Pool name cannot be null");
        }
        this._configMap.put(id, new HashMap());
        this.setSymbolPool(id);
    }

    public String getSymbolPool() {
        return this._curPool;
    }

    public String[] getSymbolPools() {
        return this._configMap.keySet().toArray(new String[0]);
    }

    public String[] getModelTypes() {
        this.setSymbolPool("model");
        return this.getParameterNames();
    }

    public void setParameter(String key, Object value) {
        if (value != null) {
            this.getSymbolPoolContents(this._curPool).put(key, value);
        }
    }

    public void setParameter(String key, String value) {
        this.getSymbolPoolContents(this._curPool).put(key, value);
    }

    public void setParameter(String key, int value) {
        this.getSymbolPoolContents(this._curPool).put(key, new Integer(value));
    }

    public void setParameter(String key, double value) {
        this.getSymbolPoolContents(this._curPool).put(key, new Double(value));
    }

    public void setParameter(String key, boolean value) {
        this.getSymbolPoolContents(this._curPool).put(key, value);
    }

    public void setParameter(String key, Class value) {
        this.getSymbolPoolContents(this._curPool).put(key, value);
    }

    public void setParameter(String poolID, String name, Object val) {
        String curID = this.getSymbolPool();
        this.setSymbolPool(poolID);
        this.getSymbolPoolContents(this._curPool).put(name, val);
        this.setSymbolPool(curID);
    }

    public Object getParameter(String key) {
        return this.getSymbolPoolContents(this._curPool).get(key);
    }

    public String getStringParameter(String key) {
        String res = (String)this.getSymbolPoolContents(this._curPool).get(key);
        return res == null ? "" : res;
    }

    public int getIntParameter(String key) {
        Object obj = this.getSymbolPoolContents(this._curPool).get(key);
        int res = Integer.MIN_VALUE;
        if (obj instanceof Integer) {
            res = (Integer)obj;
        } else if (obj instanceof String) {
            try {
                res = Integer.parseInt((String)obj);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return res;
    }

    public double getDoubleParameter(String key) {
        Object obj = this.getSymbolPoolContents(this._curPool).get(key);
        double res = Double.MIN_VALUE;
        if (obj instanceof Double) {
            res = (Double)obj;
        } else if (obj instanceof String) {
            try {
                res = Double.parseDouble((String)obj);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return res;
    }

    public boolean getBooleanParameter(String key) {
        Object obj = this.getSymbolPoolContents(this._curPool).get(key);
        boolean res = false;
        if (obj instanceof Boolean) {
            res = (Boolean)obj;
        } else if (obj instanceof String) {
            try {
                res = Boolean.valueOf((String)obj);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return res;
    }

    public Class getClassParameter(String key) {
        Object o = this.getSymbolPoolContents(this._curPool).get(key);
        Class res = null;
        if (o instanceof Class) {
            res = (Class)o;
        } else if (o instanceof String) {
            try {
                res = ClassLoaderCache.getDefault().classForName((String)o);
            }
            catch (Exception e) {
                Logger.getLogger("org.eclipse.actf.core").log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return res;
    }

    public String getParameterAsString(String key) {
        return this.getSymbolPoolContents(this._curPool).get(key).toString();
    }

    public void addConfigurationData(Object data) throws ConfigurationException {
        if (data != null && data instanceof Map) {
            this._configMap.put(this.getSymbolPool(), (Map)data);
        }
    }

    public String[] getParameterNames() {
        return this.getSymbolPoolContents(this._curPool).keySet().toArray(new String[0]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String[] pools = this.getSymbolPools();
        int p = 0;
        while (p < pools.length) {
            sb.append("Pool: " + pools[p]);
            sb.append('\n');
            Map symbols = this.getSymbolPoolContents(pools[p]);
            if (symbols != null && !symbols.isEmpty()) {
                for (String key : symbols.keySet()) {
                    sb.append(key);
                    sb.append('=');
                    sb.append(symbols.get(key).toString());
                    sb.append('\n');
                }
            }
            ++p;
        }
        return sb.toString();
    }
}

