/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.logging;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggingUtil {
    public static final String ACCSERVICE_LOGGER_NAME = "org.eclipse.actf.accservice";
    public static final String ACTF_CORE_LOGGER_NAME = "org.eclipse.actf.core";
    public static final String ACTF_VALIDATION_LOGGER_NAME = "org.eclipse.actf.validation";
    public static final String ACTF_JAVACO_LOGGER_NAME = "org.eclipse.actf.javaco";
    public static final String ACTF_WEBELO_LOGGER_NAME = "org.eclipse.actf.webelo";
    public static final String ACTF_UI_LOGGER_NAME = "org.eclipse.actf.ui";

    protected LoggingUtil() {
    }

    public static void printParams(Logger logger, Object[] params) {
        if (logger != null) {
            logger.log(Level.FINE, "With parameters:");
            int p = 0;
            while (params != null && p < params.length) {
                logger.log(Level.FINE, String.valueOf(params[p] == null ? "" : params[p].getClass().getName()) + ":" + params[p] + (p < params.length - 1 ? ", " : ""));
                ++p;
            }
        }
    }

    public static String firstCharToUpper(String str) {
        return String.valueOf(Character.toUpperCase(str.charAt(0))) + str.substring(1);
    }

    public static String arrayAsString(String[] str) {
        StringBuffer sb = new StringBuffer();
        int a = 0;
        while (a < str.length) {
            sb.append(str[a]);
            if (a < str.length - 1) {
                sb.append('\n');
            }
            ++a;
        }
        return sb.toString();
    }

    public static Throwable getRootException(Throwable t) {
        Throwable root = t;
        while ((t = t.getCause()) != null) {
            root = t;
        }
        return root;
    }

    public static String escape(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\"') {
                sb.append("&quote;");
            } else if (c == '\'') {
                sb.append("&apos;");
            } else if (c == '&') {
                sb.append("&amp;");
            } else if (c == '<') {
                sb.append("&lt;");
            } else if (c == '>') {
                sb.append("&gt;");
            } else if (c < ' ' || c > '~') {
                sb.append("&#");
                String xi = Integer.toHexString(c);
                if (xi.length() % 2 != 0) {
                    sb.append("0");
                }
                sb.append(xi);
                sb.append(";");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }
}

