/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.resources;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import org.eclipse.actf.util.resources.ClassLoaderCache;
import org.eclipse.actf.util.resources.IResourceLocator;

public class DefaultResourceLocator
implements IResourceLocator {
    public InputStream getResourceAsStream(String id) {
        return this.getResourceAsStream(id, this.getClass().getClassLoader());
    }

    public InputStream getResourceAsStream(String id, ClassLoader loader) {
        String name = System.getProperty(id);
        return this.getResourceAsBufferedStream(name != null ? name : id, loader);
    }

    public InputStream getResourceAsStream(String id, String base, String ext, ClassLoader loader) {
        String name = System.getProperty(id);
        return this.getResourceAsBufferedStream(name != null ? name : id, base, ext, loader);
    }

    protected InputStream makeBufferedStream(InputStream is) {
        if (is != null && !(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        return is;
    }

    protected InputStream getResourceAsBufferedStream(String id, ClassLoader loader) {
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return this.makeBufferedStream(loader.getResourceAsStream(id));
    }

    protected InputStream getResourceAsBufferedStream(String id, String base, String ext, ClassLoader loader) {
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        String path = id;
        if (base != null) {
            path = String.valueOf(base) + "/" + path;
        }
        if (ext != null) {
            path = String.valueOf(path) + "." + ext;
        }
        return this.makeBufferedStream(loader.getResourceAsStream(path));
    }

    public URL getResource(String name) {
        return ClassLoaderCache.getDefault().getResource(name);
    }

    public URL[] getResources(String name) {
        LinkedList<URL> urls = new LinkedList<URL>();
        Enumeration en = null;
        try {
            en = ClassLoaderCache.getDefault().getResources(name);
        }
        catch (IOException iOException) {}
        while (en != null && en.hasMoreElements()) {
            urls.add((URL)en.nextElement());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public String getPath(String name) {
        String result = null;
        URL url = this.getResource(name);
        if (url != null) {
            result = url.toString();
        }
        return result;
    }

    public String[] getPaths(String name) {
        String[] result = null;
        URL[] urls = this.getResources(name);
        if (urls != null) {
            result = new String[urls.length];
            int i = 0;
            while (i < urls.length) {
                if (urls[i] != null) {
                    result[i] = urls[i].toString();
                }
                ++i;
            }
        }
        return result;
    }
}

