/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.actf.model.dom.html.IHTMLParser;
import org.eclipse.actf.model.dom.html.dochandler.DefaultDocumentHandler;
import org.eclipse.actf.model.internal.dom.html.parser.EncodingException;
import org.eclipse.actf.model.internal.dom.html.parser.HTMLParser;
import org.eclipse.actf.model.internal.dom.html.util.RereadableInputStream;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class CharsetHandler
extends DefaultDocumentHandler {
    private RereadableInputStream ris;

    public CharsetHandler(HTMLParser parser, RereadableInputStream ris) {
        super(parser);
        this.ris = ris;
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        block15: {
            if (name.equalsIgnoreCase("META")) {
                String httpEquiv = null;
                String content = null;
                int i = 0;
                while (i < atts.getLength()) {
                    name = atts.getName(i);
                    if (name.equalsIgnoreCase("http-equiv")) {
                        httpEquiv = atts.getValue(i);
                    } else if (name.equalsIgnoreCase("content")) {
                        content = atts.getValue(i);
                    }
                    ++i;
                }
                if (httpEquiv == null || content == null) {
                    super.startElement(name, atts);
                    return;
                }
                if (httpEquiv.equalsIgnoreCase("Content-Type")) {
                    int charsetIndex = content.indexOf("charset=");
                    if (charsetIndex == -1) {
                        charsetIndex = content.indexOf("CHARSET=");
                    }
                    if (charsetIndex != -1) {
                        String encoding = content.substring(charsetIndex + "charset=".length());
                        try {
                            InputStreamReader newReader = new InputStreamReader((InputStream)this.ris, encoding);
                            if (((IHTMLParser)((Object)this.parser)).getEncoding() == null) {
                                ((HTMLParser)this.parser).setEncoding(encoding);
                            }
                            encoding = newReader.getEncoding();
                            String prevEncoding = ((HTMLParser)this.parser).getISReader().getEncoding();
                            if (prevEncoding.equals(encoding)) {
                                this.parser.setDocumentHandler(this.another);
                                break block15;
                            }
                            this.ris.reset();
                            ((HTMLParser)this.parser).getISReader().close();
                            this.parser.setDocumentHandler(this.another);
                            throw new EncodingException(newReader);
                        }
                        catch (IOException e) {
                            this.parser.error(10, e.getMessage());
                            this.parser.setDocumentHandler(this.another);
                            super.startElement(name, atts);
                            return;
                        }
                    }
                }
            } else if (name.equalsIgnoreCase("BODY")) {
                this.parser.setDocumentHandler(this.another);
            }
        }
        super.startElement(name, atts);
    }
}

