/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLDocument;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLAttribute;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLCDATASection;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLComment;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDOMImpl;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocType;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocTypeDef;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocumentFragment;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLElement;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLNode;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLPI;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLParentNode;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLText;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class SGMLDocument
extends SGMLParentNode
implements ISGMLDocument {
    private static final long serialVersionUID = -9052104600001817404L;
    public Element documentElement = null;
    public DocumentType doctype = null;
    private transient DOMImplementation domImpl;
    private transient SGMLDocTypeDef dtd;
    private Hashtable<Character, String> charNumEntities = new Hashtable();

    public SGMLDocument() {
        this(SGMLDOMImpl.getDOMImplementation());
    }

    protected SGMLDocument(DOMImplementation imple) {
        super(null);
        this.domImpl = imple;
    }

    void check(Node node) throws DOMException {
        if (node.getOwnerDocument() != this && !(node instanceof SGMLDocType)) {
            throw new DOMException(4, node + " created from " + node.getOwnerDocument() + " this."){
                private static final long serialVersionUID = -6949628537817157229L;
            };
        }
        switch (node.getNodeType()) {
            case 1: {
                if (this.documentElement == null) {
                    this.documentElement = (Element)node;
                    break;
                }
                throw new DOMException(3, " document cannot have roots."){
                    private static final long serialVersionUID = -8867384684522317782L;
                };
            }
            case 7: 
            case 8: {
                break;
            }
            case 10: {
                this.doctype = (DocumentType)node;
                ((SGMLNode)node).ownerDocument = this;
                break;
            }
            default: {
                throw new DOMException(3, node + " is not allowed as a child of " + this){
                    private static final long serialVersionUID = 7083250644035192730L;
                };
            }
        }
    }

    public Node cloneNode(boolean deep) {
        SGMLDocument ret = (SGMLDocument)super.cloneNode(true);
        this.setOwnerDocument(ret, ret);
        Node child = ret.firstChild;
        while (child != null) {
            if (child instanceof Element) {
                ret.documentElement = (Element)child;
            } else if (child instanceof DocumentType) {
                ret.doctype = (DocumentType)child;
            }
            child = child.getNextSibling();
        }
        this.processNodeDeepForOptimization(ret.documentElement);
        return ret;
    }

    private void processNodeDeepForOptimization(Element element) {
        Node f = element.getFirstChild();
        while (f != null) {
            if (f instanceof Element) {
                this.processNodeDeepForOptimization((Element)f);
            }
            f = f.getNextSibling();
        }
        if (element instanceof SGMLElement) {
            ((SGMLElement)element).processNodeForOptimization(element);
        }
    }

    private void setOwnerDocument(SGMLNode ret, Document doc) {
        ret.ownerDocument = doc;
        SGMLNode child = (SGMLNode)ret.getFirstChild();
        while (child != null) {
            this.setOwnerDocument(child, doc);
            child = (SGMLNode)child.getNextSibling();
        }
    }

    public Attr createAttribute(String name) {
        return new SGMLAttribute(name, name, this);
    }

    public CDATASection createCDATASection(String c) {
        return new SGMLCDATASection(c, this);
    }

    public Comment createComment(String data) {
        return new SGMLComment(data, this);
    }

    public DocumentFragment createDocumentFragment() {
        return new SGMLDocumentFragment(this);
    }

    public Element createElement(String tagName) {
        return new SGMLElement(tagName, this);
    }

    public EntityReference createEntityReference(String a) throws DOMException {
        throw new DOMException(9, "cannot create Entity Ref."){
            private static final long serialVersionUID = -4581301359508117945L;
        };
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        return new SGMLPI(target, data, this);
    }

    public Text createTextNode(String data) {
        return new SGMLText(data, this);
    }

    public DocumentType getDoctype() {
        return this.doctype;
    }

    public Element getDocumentElement() {
        return this.documentElement;
    }

    public Node getDocumentType() {
        return this.doctype;
    }

    public NodeList getElementsByTagName(String tagname) {
        return this.documentElement.getElementsByTagName(tagname);
    }

    public DOMImplementation getImplementation() {
        return this.domImpl;
    }

    public Node getNextSibling() {
        return null;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeValue() {
        return null;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public Node getParentNode() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild == this.documentElement) {
            this.documentElement = null;
        } else if (oldChild == this.doctype) {
            this.doctype = null;
        }
        return super.removeChild(oldChild);
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        throw new DOMException(7, "#document is always null"){
            private static final long serialVersionUID = 6689389325290139309L;
        };
    }

    public void printAsXML(String publicID, URL location, PrintWriter pw, boolean indent) throws IOException {
        this.printAsXML(publicID, location, pw, indent, null);
    }

    public void printAsXML(String publicID, URL location, PrintWriter pw, boolean indent, String enc) throws IOException {
        if (enc == null) {
            pw.println("<?xml version=\"1.0\"?>");
        } else {
            pw.println("<?xml version=\"1.0\" encoding=\"" + enc + "\"?>");
        }
        if (publicID != null) {
            pw.print("<!DOCTYPE " + this.documentElement.getTagName() + " PUBLIC \"" + publicID + '\"');
            if (location != null) {
                pw.println(" \"" + location + "\">");
            } else {
                pw.println('>');
            }
        }
        ((SGMLElement)this.documentElement).printAsXML(pw, 0, indent);
        pw.println();
        pw.flush();
    }

    public void printAsXML(PrintWriter pw, boolean indent, String enc) throws IOException {
        this.printAsXML(null, null, pw, indent, enc);
    }

    public void printAsSGML(PrintWriter pw, boolean indent) throws IOException {
        if (this.doctype != null) {
            pw.println(this.doctype.toString());
        }
        if (this.documentElement != null) {
            ((SGMLElement)this.documentElement).printAsSGML(pw, 0, indent);
        }
        pw.println();
        pw.flush();
    }

    public SGMLDocTypeDef getDTD() {
        return this.dtd;
    }

    public void setDTD(SGMLDocTypeDef dtd) {
        this.dtd = dtd;
    }

    String getEntityOrigin(Character Ch) {
        return this.charNumEntities.get(Ch);
    }

    void putCharNumEntity(Character C, String ent) {
        this.charNumEntities.put(C, ent);
    }

    String getCharNumEntity(Character C) {
        return this.charNumEntities.get(C);
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        Node ret;
        switch (importedNode.getNodeType()) {
            case 1: {
                ret = this.createElement(importedNode.getNodeName());
                NamedNodeMap attributes = importedNode.getAttributes();
                int i = 0;
                while (i < attributes.getLength()) {
                    Attr importedAttr = (Attr)attributes.item(i);
                    if (importedAttr.getSpecified()) {
                        Attr attr = this.createAttribute(importedAttr.getNodeName());
                        attr.setValue(importedAttr.getValue());
                        ((Element)ret).setAttributeNode(attr);
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                ret = this.createAttribute(importedNode.getNodeName());
                ((Attr)ret).setValue(importedNode.getNodeValue());
                break;
            }
            case 3: {
                ret = this.createTextNode(importedNode.getNodeValue());
                break;
            }
            case 4: {
                ret = this.createCDATASection(importedNode.getNodeValue());
                break;
            }
            case 8: {
                ret = this.createComment(importedNode.getNodeValue());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)importedNode;
                ret = this.createProcessingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 5: {
                throw new DOMException(9, "ENTITY_REFERENCE: " + importedNode){
                    private static final long serialVersionUID = 1578579363722608207L;
                };
            }
            case 6: {
                throw new DOMException(9, "ENTITY: " + importedNode){
                    private static final long serialVersionUID = -450181572985174561L;
                };
            }
            case 9: {
                throw new DOMException(9, "DOCUMENT: " + importedNode){
                    private static final long serialVersionUID = 8785157203267073381L;
                };
            }
            case 10: {
                throw new DOMException(9, "DOCUMENT_TYPE: " + importedNode){
                    private static final long serialVersionUID = 5629745929750604049L;
                };
            }
            case 11: {
                ret = this.createDocumentFragment();
                break;
            }
            case 12: {
                throw new DOMException(9, "NOTATION: " + importedNode){
                    private static final long serialVersionUID = 1787799543281735366L;
                };
            }
            default: {
                throw new DOMException(9, "Unknown node type: " + importedNode.getNodeType()){
                    private static final long serialVersionUID = -9119985548894040858L;
                };
            }
        }
        if (deep) {
            Node importedChild = importedNode.getFirstChild();
            while (importedChild != null) {
                ret.appendChild(this.importNode(importedChild, true));
                importedChild = importedChild.getNextSibling();
            }
        }
        return ret;
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.createElement(qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.createAttribute(qualifiedName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.getElementsByTagName(localName);
    }

    public Element getElementById(String elementID) {
        if (this.documentElement instanceof SGMLElement) {
            HashMap<String, List<WeakReference<Element>>> map = SGMLParentNode.getIdMap(this);
            List<WeakReference<Element>> list = map.get(elementID);
            if (list == null) {
                return null;
            }
            return (Element)list.get(0).get();
        }
        return null;
    }

    public Node adoptNode(Node source) throws DOMException {
        return null;
    }

    public String getDocumentURI() {
        return null;
    }

    public DOMConfiguration getDomConfig() {
        return null;
    }

    public String getInputEncoding() {
        return null;
    }

    public boolean getStrictErrorChecking() {
        return false;
    }

    public String getXmlEncoding() {
        return null;
    }

    public boolean getXmlStandalone() {
        return false;
    }

    public String getXmlVersion() {
        return null;
    }

    public void normalizeDocument() {
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    public void setDocumentURI(String documentURI) {
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
    }
}

