/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.impl;

import org.eclipse.actf.ai.internal.navigator.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SearchDialog
extends Dialog {
    private static String formInputString = "";
    private Text searchField;
    private Button forwardRadio;
    private Button backwardRadio;
    private Button exactButton;
    private static boolean isForward = true;
    private static boolean exact = false;

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.FormInputDialog_Search);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.searchField = new Text(container, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 400;
        gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        this.searchField.setLayoutData((Object)gd);
        this.searchField.setText(formInputString);
        this.searchField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                formInputString = SearchDialog.this.searchField.getText();
            }
        });
        this.backwardRadio = new Button(container, 16);
        this.backwardRadio.setSelection(!isForward);
        this.backwardRadio.setText(Messages.FormInputDialog_Backward);
        this.backwardRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                isForward = false;
            }
        });
        this.forwardRadio = new Button(container, 16);
        this.forwardRadio.setText(Messages.FormInputDialog_Forward);
        this.forwardRadio.setSelection(isForward);
        this.forwardRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                isForward = true;
            }
        });
        this.exactButton = new Button(container, 32);
        this.exactButton.setSelection(exact);
        this.exactButton.setText(Messages.FormInputDialog_Exact);
        this.exactButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                exact = SearchDialog.this.exactButton.getSelection();
            }
        });
        this.searchField.setFocus();
        this.searchField.setSelection(0, formInputString.length());
        return container;
    }

    String getString() {
        return formInputString;
    }

    boolean isForward() {
        return isForward;
    }

    boolean isExact() {
        return exact;
    }

    SearchDialog(Shell parent) {
        super(parent);
    }

    public void setForward(boolean b) {
        isForward = b;
    }
}

