/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ui.util;

import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class DialogSave {
    public static final int ALL = 0;
    public static final int HTML = 1;
    public static final int BMP = 2;
    public static final int XML = 3;
    private static final int TYPE_MAX = 3;
    private static final int MAX_FILENAME_LENGTH = 100;
    private static final String[][] FILTER = new String[][]{{"All Files (*.*)"}, {"HTML Files (*.htm, *.html)"}, {"BMP Files (*.bmp)"}, {"XML Files (*.xml)"}};
    private static final String[][] FILTER_EXT = new String[][]{{"*.*"}, {"*.htm;*.html"}, {"*.bmp"}, {"*.xml"}};
    private static final String[][] EXT_CHECK = new String[][]{new String[0], {".htm", ".html"}, {".bmp"}, {".xml"}};
    private static final String[] DEFAULT_EXT = new String[]{"", ".html", ".bmp", ".xml"};

    public static String open(Shell shell, int type, String targetNameBase, String ext) {
        String saveFileName = null;
        if (type > -1 && type <= 3) {
            FileDialog fileD = new FileDialog(shell, 8192);
            fileD.setFilterNames(FILTER[type]);
            fileD.setFilterExtensions(FILTER_EXT[type]);
            saveFileName = targetNameBase;
            if (saveFileName != null) {
                int iPos = saveFileName.indexOf("//");
                if (iPos != -1) {
                    saveFileName = saveFileName.substring(iPos + 2);
                }
                if ((saveFileName = saveFileName.replaceAll("\\p{Punct}", "_")).indexOf(".") > 0) {
                    saveFileName = saveFileName.substring(0, saveFileName.lastIndexOf("."));
                }
                if (saveFileName.length() > 100) {
                    saveFileName = saveFileName.substring(0, 100);
                }
                if (ext != null) {
                    saveFileName = String.valueOf(saveFileName) + ext;
                }
                fileD.setFileName(saveFileName);
                saveFileName = fileD.open();
                if (saveFileName != null) {
                    boolean flag = true;
                    String tmpS = saveFileName.toLowerCase();
                    int i = 0;
                    while (i < EXT_CHECK[type].length) {
                        if (tmpS.endsWith(EXT_CHECK[type][i])) {
                            flag = false;
                        }
                        ++i;
                    }
                    if (flag) {
                        saveFileName = String.valueOf(saveFileName) + DEFAULT_EXT[type];
                    }
                }
            }
        }
        return saveFileName;
    }
}

