/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.local;

import java.io.File;
import org.eclipse.actf.ai.xmlstore.IXMLEditableInfo;
import org.eclipse.actf.ai.xmlstore.IXMLSelector;
import org.eclipse.actf.ai.xmlstore.IXMLStore;
import org.eclipse.actf.ai.xmlstore.XMLStoreException;
import org.eclipse.actf.ai.xmlstore.local.UserSubStore;
import org.eclipse.actf.ai.xmlstore.local.UserXML;
import org.eclipse.actf.ai.xmlstore.local.XMLStoreLocal;

public class UserXMLStore
extends XMLStoreLocal {
    public static final String TEMP_DIR_NAME = "user";
    IXMLSelector selector;
    private File dir;

    public UserXMLStore(File dir, String[] extensions) {
        super(dir, extensions);
        this.dir = dir;
        dir.mkdirs();
    }

    protected void register(File file) {
        try {
            UserXML xf = new UserXML(file);
            this.list.add(xf);
        }
        catch (XMLStoreException xMLStoreException) {}
    }

    public IXMLEditableInfo newXML(String namespaceURI, String qualifiedName, String targetUriPattern) throws XMLStoreException {
        UserXML ux = new UserXML(namespaceURI, qualifiedName, targetUriPattern, this.dir);
        this.list.add(ux);
        return ux;
    }

    public IXMLStore specify(IXMLSelector selector) {
        return new UserSubStore(this, selector);
    }

    protected void registerDir(File dir) {
        File[] fileList = dir.listFiles();
        if (fileList == null) {
            return;
        }
        int i = 0;
        while (i < fileList.length) {
            File f = fileList[i];
            if (f.isDirectory()) {
                this.registerDir(f);
            } else if (this.isNotTemporal(f)) {
                this.register(f);
            }
            ++i;
        }
    }
}

