/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.util;

import com.ibm.icu.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.actf.ai.xmlstore.nvdl.NVDLException;
import org.eclipse.actf.ai.xmlstore.nvdl.dispatcher.NVDLDispatcherException;
import org.eclipse.actf.ai.xmlstore.nvdl.model.Location;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModel;
import org.xml.sax.SAXParseException;

public class MessageFormatter {
    static ResourceBundle resourceBundle = null;

    public static void setResourceBundle(String pkgName) {
        try {
            resourceBundle = ResourceBundle.getBundle(pkgName);
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
    }

    private static String getFormat(String propName) {
        String format;
        if (resourceBundle == null) {
            return propName;
        }
        try {
            format = resourceBundle.getString(propName);
        }
        catch (MissingResourceException missingResourceException) {
            return propName;
        }
        if (format != null) {
            return format;
        }
        return propName;
    }

    public static String model(NVDLModel model, String message) {
        Location modelLocation = model.getLocation();
        if (modelLocation == null) {
            return MessageFormat.format((String)"{0} : {1}", (Object[])new Object[]{model.toString(), message});
        }
        return MessageFormat.format((String)"{0}#{1}, Line:{2,number,integer}, Col:{3,number,integer} : {4}", (Object[])new Object[]{model.toString(), modelLocation.iri, new Integer(modelLocation.line), new Integer(modelLocation.pos), message});
    }

    public static String locAndModel(Location location, NVDLModel model, String message) {
        Location modelLocation = model.getLocation();
        if (modelLocation == null) {
            return MessageFormat.format((String)"{0} Line:{1,number,integer}, Col:{2,number,integer}, ({3} ): {4}", (Object[])new Object[]{location.iri, new Integer(location.line), new Integer(location.pos), model.toString(), message});
        }
        return MessageFormat.format((String)"{0} Line:{1,number,integer}, Col:{2,number,integer}, ({3} {4}, Line:{5,number,integer}, Col:{6,number,integer}): {7}", (Object[])new Object[]{location.iri, new Integer(location.line), new Integer(location.pos), model.toString(), modelLocation.iri, new Integer(modelLocation.line), new Integer(modelLocation.pos), message});
    }

    public static String loc(Location location, String message) {
        return MessageFormat.format((String)"{0} Line:{1,number,integer}, Col:{2,number,integer}: {3}", (Object[])new Object[]{location.iri, new Integer(location.line), new Integer(location.pos), message});
    }

    public static String mes(String propName) {
        return MessageFormatter.getFormat(propName);
    }

    public static String mes(String propName, Object[] args) {
        String format = MessageFormatter.getFormat(propName);
        String message = MessageFormat.format((String)format, (Object[])args);
        return message;
    }

    public static String exception(Exception e) {
        String message;
        Location loc = null;
        NVDLModel model = null;
        Object[] args = null;
        Exception messageException = e;
        if (e instanceof SAXParseException) {
            SAXParseException se = (SAXParseException)e;
            int line = se.getLineNumber();
            int col = se.getColumnNumber();
            String systemId = se.getSystemId();
            if (line > 0) {
                loc = new Location(line, col, systemId);
            }
            if ((e = se.getException()) == null) {
                e = se;
            }
        }
        if (e instanceof NVDLException) {
            NVDLException ne = (NVDLException)e;
            args = ne.getMessageArguments();
            if (e instanceof NVDLDispatcherException) {
                NVDLDispatcherException nvdlDispatcherException = (NVDLDispatcherException)e;
                model = nvdlDispatcherException.getCurrentModel();
            }
        }
        if (args != null) {
            message = MessageFormatter.mes(messageException.getMessage(), args);
        } else {
            message = messageException.getLocalizedMessage();
            if (message == null) {
                message = messageException.getMessage();
            }
            if (message == null) {
                message = messageException.toString();
            }
        }
        if (loc != null) {
            message = model != null ? MessageFormatter.locAndModel(loc, model, message) : MessageFormatter.loc(loc, message);
        } else if (model != null) {
            message = MessageFormatter.model(model, message);
        }
        return message;
    }
}

