/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.audio.io;

import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;

public class AudioUtil {
    public static int getBytesPerSecondLR(AudioFormat format) {
        return AudioUtil.getBytesPerSecond(format) * format.getChannels();
    }

    public static int getBytesPerSecond(AudioFormat format) {
        return AudioUtil.getBitsPerSecond(format) / 8;
    }

    public static int getBitsPerSecond(AudioFormat format) {
        return (int)format.getSampleRate() * format.getSampleSizeInBits();
    }

    public static int getSamplesPerSecond(AudioFormat format) {
        return (int)format.getSampleRate();
    }

    public static int getSamplesPerSecondLR(AudioFormat format) {
        return AudioUtil.getSamplesPerSecond(format) * format.getChannels();
    }

    public static int getBytesPerSample(AudioFormat format) {
        return format.getSampleSizeInBits() / 8;
    }

    public static int getBytesPerSampleLR(AudioFormat format) {
        return AudioUtil.getBytesPerSample(format) * format.getChannels();
    }

    public static ByteOrder getEndian(AudioFormat format) {
        if (format.isBigEndian()) {
            return ByteOrder.BIG_ENDIAN;
        }
        return ByteOrder.LITTLE_ENDIAN;
    }
}

