/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.impl;

import java.util.List;
import org.eclipse.actf.ai.fennec.FennecException;
import org.eclipse.actf.ai.fennec.impl.FennecBundleMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecMode;
import org.eclipse.actf.ai.fennec.impl.FennecServiceImpl;
import org.eclipse.actf.ai.fennec.impl.TreeItemFennec;
import org.eclipse.actf.ai.query.IQuery;
import org.w3c.dom.Node;

class FennecRecombinantMetadata
extends FennecBundleMetadata {
    public static final int TYPE_SIMPLE = 0;
    public static final int TYPE_ATTACH = 1;
    public static final int TYPE_UNWRAP = 2;
    private final int type;
    private FennecMode nextMode;

    public FennecMode getNextMode() {
        return this.nextMode;
    }

    List expand(TreeItemFennec pItem, int trigger) throws FennecException {
        return this.nextMode.expand(pItem, null, trigger);
    }

    List buildItems(TreeItemFennec baseItem, Node baseNode, int trigger) throws FennecException {
        return this.nextMode.expand(baseItem, baseNode, trigger);
    }

    TreeItemFennec buildRootItem() throws FennecException {
        TreeItemFennec root = super.buildRootItem();
        if (root == null) {
            throw new FennecException("Fennec.EMPTY_PAGE", null);
        }
        return root;
    }

    static FennecRecombinantMetadata newAttach(FennecServiceImpl fennecService, IQuery q, FennecMode mode, FennecMode nextMode, FennecMetadata[] mds) {
        FennecRecombinantMetadata md = new FennecRecombinantMetadata(fennecService, q, mode, nextMode, mds, 1);
        return md;
    }

    static FennecRecombinantMetadata newUnwrap(FennecServiceImpl fennecService, IQuery q, FennecMode mode, FennecMode nextMode, FennecMetadata[] mds) {
        FennecRecombinantMetadata md = new FennecRecombinantMetadata(fennecService, q, mode, nextMode, mds, 2);
        return md;
    }

    private FennecRecombinantMetadata(FennecServiceImpl fennecService, IQuery q, FennecMode mode, FennecMode nextMode, FennecMetadata[] mds, int type) {
        super(fennecService, q, mode, mds);
        this.type = type;
        this.nextMode = nextMode;
        nextMode.setBaseMetadata(this);
    }
}

