/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.impl;

import java.util.List;
import org.eclipse.actf.ai.fennec.FennecException;
import org.eclipse.actf.ai.fennec.impl.FennecGeneratedMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecMetadata;
import org.eclipse.actf.ai.fennec.impl.TreeItemTerms;
import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.ai.fennec.treemanager.TreeManagerException;
import org.eclipse.actf.ai.query.QueryService;
import org.eclipse.actf.model.dom.dombycom.IElementEx;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.ISelectElement;
import org.eclipse.actf.util.vocab.AbstractTerms;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.Vocabulary;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TreeItemFennec
implements ITreeItem {
    private static final TreeItemFennec[] emptyChild = new TreeItemFennec[0];
    private Node baseNode;
    private ITreeItem parent;
    private ITreeItem[] childItems;
    private FennecMetadata metadata;
    private boolean hasAlreadyChildRefreshed;
    private int nth;
    private TreeItemTerms terms;
    int distance = 0;
    private IElementEx.Position radioPosition;
    private IElementEx.Position listPosition;

    public static TreeItemFennec newTreeItem(FennecMetadata metadata, ITreeItem parent, Node baseNode) {
        if (baseNode == null) {
            return new TreeItemFennec(metadata, parent, null, new TreeItemTerms(null));
        }
        if (!(baseNode instanceof IEvalTarget)) {
            return null;
        }
        IEvalTarget evalTarget = (IEvalTarget)baseNode;
        return new TreeItemFennec(metadata, parent, baseNode, new TreeItemTerms(evalTarget));
    }

    protected TreeItemFennec(FennecMetadata metadata, ITreeItem parent, Node baseNode, TreeItemTerms terms) {
        this.terms = terms;
        this.metadata = metadata;
        this.parent = parent;
        this.baseNode = baseNode;
        this.childItems = emptyChild;
        this.nth = 0;
    }

    public AbstractTerms getTerms() {
        return this.terms;
    }

    public ITreeItem getParent() {
        return this.parent;
    }

    public int getNth() {
        return this.nth;
    }

    private void setAsRoot() {
        this.parent = null;
    }

    private void setParent() {
        int i = 0;
        while (i < this.childItems.length) {
            TreeItemFennec c = (TreeItemFennec)this.childItems[i];
            c.parent = this;
            c.nth = i++;
        }
    }

    public void setChildItems(List items) {
        this.childItems = items == null ? emptyChild : (ITreeItem[])items.toArray(emptyChild);
        this.setParent();
    }

    public void setChildItems(ITreeItem[] items) {
        this.childItems = items == null ? emptyChild : items;
        this.setParent();
    }

    public void appendChildItems(ITreeItem[] items) {
        if (items == null) {
            return;
        }
        ITreeItem[] newItems = new ITreeItem[this.childItems.length + items.length];
        int i = 0;
        while (i < this.childItems.length) {
            newItems[i] = this.childItems[i];
            ++i;
        }
        int j = 0;
        while (j < items.length) {
            TreeItemFennec c = (TreeItemFennec)items[j];
            c.parent = this;
            newItems[i] = c;
            ++i;
            ++j;
        }
        this.childItems = newItems;
    }

    public boolean hasChild() {
        return this.childItems.length > 0;
    }

    public void forceParent(ITreeItem parent) {
        this.parent = parent;
    }

    void markRefreshedChild() {
        this.hasAlreadyChildRefreshed = true;
    }

    boolean hasAlreadyChildRefreshed() {
        return this.hasAlreadyChildRefreshed;
    }

    TreeItemFennec expandChildItems(int trigger) throws FennecException {
        List newChildItems = this.metadata.expand(this, trigger);
        this.setChildItems(newChildItems);
        return this;
    }

    private Node getNearestNodeInternal(int idx) {
        if (this.baseNode != null) {
            return this.baseNode;
        }
        if (idx < this.childItems.length) {
            TreeItemFennec item = (TreeItemFennec)this.childItems[idx];
            return item.getNearestNodeInternal(0);
        }
        if (this.parent == null) {
            return null;
        }
        return ((TreeItemFennec)this.parent).getNearestNodeInternal(this.getNth());
    }

    Node getNearestNode() {
        return this.getNearestNodeInternal(0);
    }

    private TreeItemFennec autoUnwrap(int trigger) throws FennecException {
        TreeItemFennec item = this;
        while (true) {
            int newSize;
            TreeItemFennec parent;
            if ((parent = (TreeItemFennec)item.getParent()) == null) {
                item.setChildItems(emptyChild);
                return item;
            }
            int idx = item.getNth();
            List newSiblings = parent.metadata.expand(parent, 20);
            if (newSiblings != null && (newSize = newSiblings.size()) > 0) {
                if (idx >= newSize) {
                    idx = newSize - 1;
                }
                item = (TreeItemFennec)newSiblings.get(idx);
                item = item.expandChildItems(trigger);
                parent.setChildItems(newSiblings);
                return item;
            }
            item = parent;
        }
    }

    TreeItemFennec expand(int trigger) throws FennecException {
        TreeItemFennec parent = (TreeItemFennec)this.getParent();
        if (parent != null) {
            int idx = this.getNth();
            List newSiblings = parent.metadata.expand(parent, 4);
            if (newSiblings == null) {
                return parent.autoUnwrap(trigger);
            }
            int newSize = newSiblings.size();
            if (newSize == 0) {
                return parent.autoUnwrap(trigger);
            }
            if (idx >= newSize) {
                idx = newSize - 1;
            }
            TreeItemFennec newTarget = (TreeItemFennec)newSiblings.get(idx);
            newTarget = newTarget.expandChildItems(trigger);
            parent.setChildItems(newSiblings);
            return newTarget;
        }
        List newChildItems = this.metadata.expand(this, trigger);
        this.setChildItems(newChildItems);
        this.setAsRoot();
        return this;
    }

    public ITreeItem[] getChildItems() {
        return this.childItems;
    }

    public String getUIString() {
        if (this.metadata != null) {
            String r = this.metadata.getAltText(this);
            if (r == null) {
                return "";
            }
            if (r.length() > 0) {
                return r;
            }
        }
        if (this.baseNode instanceof INodeEx) {
            INodeEx node2 = (INodeEx)this.baseNode;
            return node2.extractString();
        }
        return "";
    }

    public String getDescription() {
        if (this.metadata != null) {
            String r = this.metadata.getDescription(this);
            if (r == null) {
                return "";
            }
            if (r.length() > 0) {
                return r;
            }
        }
        return "";
    }

    public String getNodeString() {
        if (this.baseNode != null) {
            return this.baseNode.getNodeName();
        }
        return "No Node";
    }

    public short getHeadingLevel() {
        if (this.metadata != null) {
            return this.metadata.getHeadingLevel(this);
        }
        return 0;
    }

    public String getLinkURI() {
        if (this.baseNode instanceof INodeEx) {
            INodeEx node2 = (INodeEx)this.baseNode;
            return node2.getLinkURI();
        }
        return null;
    }

    public Object getBaseNode() {
        return this.baseNode;
    }

    public FennecMetadata getMetadata() {
        return this.metadata;
    }

    public int doClick() throws TreeManagerException {
        if (this.baseNode instanceof INodeEx) {
            ((INodeEx)this.baseNode).doClick();
            return 8;
        }
        return 0;
    }

    public int stay() throws TreeManagerException {
        return 0;
    }

    public int highlight() throws TreeManagerException {
        if (this.baseNode instanceof INodeEx) {
            ((INodeEx)this.baseNode).highlight();
        }
        return 0;
    }

    public int unhighlight() throws TreeManagerException {
        if (this.baseNode instanceof INodeEx) {
            ((INodeEx)this.baseNode).unhighlight();
        }
        return 0;
    }

    public boolean setFocus() {
        if (this.baseNode instanceof INodeEx) {
            ((INodeEx)this.baseNode).setFocus();
        }
        return false;
    }

    public boolean isInputable() {
        if (this.baseNode instanceof IEvalTarget) {
            return Vocabulary.isInputable().eval((IEvalTarget)this.baseNode);
        }
        return false;
    }

    public boolean isClickable() {
        if (this.baseNode instanceof IEvalTarget) {
            return Vocabulary.isClickable().eval((IEvalTarget)this.baseNode);
        }
        return false;
    }

    public boolean isImage() {
        if (this.baseNode instanceof IEvalTarget) {
            return Vocabulary.isImage().eval((IEvalTarget)this.baseNode);
        }
        return false;
    }

    public String[] getStillPictureData() {
        if (!(this.baseNode instanceof INodeEx)) {
            return new String[3];
        }
        return ((INodeEx)this.baseNode).getStillPictureData();
    }

    public int setText(String text) throws TreeManagerException {
        if (this.baseNode instanceof INodeEx) {
            ((INodeEx)this.baseNode).setText(text);
        }
        return 0;
    }

    public String getText() throws TreeManagerException {
        if (this.baseNode instanceof INodeEx) {
            return ((INodeEx)this.baseNode).getText();
        }
        return "";
    }

    public void addMetadata(TreeItemFennec item) {
        if (!(this.metadata instanceof FennecGeneratedMetadata)) {
            return;
        }
        if (!(item.metadata instanceof FennecGeneratedMetadata)) {
            return;
        }
        FennecGeneratedMetadata meta = (FennecGeneratedMetadata)this.metadata;
        FennecGeneratedMetadata meta2 = (FennecGeneratedMetadata)item.metadata;
        this.metadata = FennecGeneratedMetadata.generate(meta, meta2);
    }

    public int getRadioIndex() {
        if (this.baseNode instanceof IElementEx) {
            if (this.radioPosition == null) {
                this.radioPosition = ((IElementEx)this.baseNode).getRadioPosition();
            }
            if (this.radioPosition == null) {
                return 0;
            }
            return this.radioPosition.index;
        }
        return 0;
    }

    public int getRadioTotal() {
        if (this.baseNode instanceof IElementEx) {
            if (this.radioPosition == null) {
                this.radioPosition = ((IElementEx)this.baseNode).getRadioPosition();
            }
            if (this.radioPosition == null) {
                return 0;
            }
            return this.radioPosition.total;
        }
        return 0;
    }

    public int getListIndex() {
        Node current = this.baseNode;
        do {
            if (!(current instanceof IElementEx)) continue;
            if (this.listPosition == null) {
                this.listPosition = ((IElementEx)current).getListPosition();
            }
            if (this.listPosition == null) {
                return 0;
            }
            return this.listPosition.index;
        } while ((current = current.getParentNode()) != null);
        return 0;
    }

    public int getListTotal() {
        Node current = this.baseNode;
        do {
            if (!(current instanceof IElementEx)) continue;
            if (this.listPosition == null) {
                this.listPosition = ((IElementEx)current).getListPosition();
            }
            if (this.listPosition == null) {
                return 0;
            }
            return this.listPosition.total;
        } while ((current = current.getParentNode()) != null);
        return 0;
    }

    public String getFormLabel() {
        if (!(this.baseNode instanceof IElementEx)) {
            return "";
        }
        Element label = ((IElementEx)this.baseNode).getFormLabel();
        if (label == null || !(label instanceof INodeEx)) {
            return "";
        }
        NodeList nl = label.getChildNodes();
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof INodeEx) {
                ret.append(((INodeEx)node).extractString());
            }
            ++i;
        }
        return ret.toString();
    }

    public void setSelectedIndices(int[] indices) {
        if (this.baseNode instanceof ISelectElement) {
            ((ISelectElement)this.baseNode).setSelectedIndices(indices);
        }
    }

    public int[] getSelectedIndices() {
        if (this.baseNode instanceof ISelectElement) {
            return ((ISelectElement)this.baseNode).getSelectedIndices();
        }
        return null;
    }

    public int getOptionsCount() {
        if (this.baseNode instanceof ISelectElement) {
            return ((ISelectElement)this.baseNode).getOptionsCount();
        }
        return 0;
    }

    public String getOptionTextAt(int index) {
        if (this.baseNode instanceof ISelectElement) {
            return ((ISelectElement)this.baseNode).getOptionTextAt(index);
        }
        return "";
    }

    public Node serializeQuery(Node parent) {
        if (this.baseNode == null) {
            return null;
        }
        return QueryService.serializeQuery((Node)this.baseNode, (Node)parent);
    }

    public char getAccessKey() {
        if (this.baseNode instanceof INodeEx) {
            return ((INodeEx)this.baseNode).getAccessKey();
        }
        return '\u0000';
    }
}

