/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.impl;

import org.eclipse.actf.ai.fennec.treemanager.ISoundControl;
import org.eclipse.actf.model.dom.dombycom.AnalyzedResult;
import org.eclipse.actf.model.dom.dombycom.INodeExSound;

public class TreeItemSoundControl
implements ISoundControl {
    private AnalyzedResult analyzedResult;
    private static final int VOLUME_TICK = 150;
    private static final int VOLUME_TICK_MINIMAL = 10;

    public boolean muteMedia() {
        INodeExSound[] sounds = this.analyzedResult.getSoundNodes();
        boolean r = true;
        int i = 0;
        while (i < sounds.length) {
            boolean st = sounds[i].getMuteState();
            r &= sounds[i].muteMedia(!st);
            ++i;
        }
        return r;
    }

    public ISoundControl.VolumeState getVolumeState() {
        INodeExSound[] sounds = this.analyzedResult.getSoundNodes();
        boolean mute = true;
        boolean max = true;
        boolean min = true;
        int i = 0;
        while (i < sounds.length) {
            mute &= sounds[i].getMuteState();
            int vol = sounds[i].getVolume();
            max &= vol == 1000;
            min &= vol == 0;
            ++i;
        }
        if (mute) {
            return ISoundControl.VolumeState.MUTE;
        }
        if (max) {
            return ISoundControl.VolumeState.MAX;
        }
        if (min) {
            return ISoundControl.VolumeState.MIN;
        }
        return ISoundControl.VolumeState.OTHER;
    }

    public boolean volumeDownMedia() {
        return this.volumeDownMedia(150);
    }

    public boolean minimalVolumeDownMedia() {
        return this.volumeDownMedia(10);
    }

    private boolean volumeDownMedia(int tick) {
        INodeExSound[] sounds = this.analyzedResult.getSoundNodes();
        boolean r = true;
        int i = 0;
        while (i < sounds.length) {
            int vol = sounds[i].getVolume();
            if (vol < 0) {
                return false;
            }
            vol = vol < 0 + tick ? 0 : (vol -= tick);
            r &= sounds[i].setVolume(vol);
            ++i;
        }
        return r;
    }

    public boolean volumeUpMedia() {
        return this.volumeUpMedia(150);
    }

    public boolean minimalVolumeUpMedia() {
        return this.volumeUpMedia(10);
    }

    private boolean volumeUpMedia(int tick) {
        INodeExSound[] sounds = this.analyzedResult.getSoundNodes();
        boolean r = true;
        int i = 0;
        while (i < sounds.length) {
            int vol = sounds[i].getVolume();
            if (vol < 0) {
                return false;
            }
            vol = vol > 1000 - tick ? 1000 : (vol += tick);
            r &= sounds[i].setVolume(vol);
            ++i;
        }
        return r;
    }

    public int getCount() {
        INodeExSound[] sounds = this.analyzedResult.getSoundNodes();
        return sounds.length;
    }

    public static ISoundControl newTreeItemSoundControl(AnalyzedResult ar) {
        return new TreeItemSoundControl(ar);
    }

    private TreeItemSoundControl(AnalyzedResult ar) {
        this.analyzedResult = ar;
    }

    public int[] getVolumes() {
        INodeExSound[] sounds = this.analyzedResult.getSoundNodes();
        int[] volumes = new int[sounds.length];
        int i = 0;
        while (i < sounds.length) {
            volumes[i] = sounds[i].getVolume();
            if (volumes[i] < 0) {
                volumes[i] = 0;
            }
            ++i;
        }
        return volumes;
    }

    public boolean setVolumes(int[] volumes) {
        INodeExSound[] sounds = this.analyzedResult.getSoundNodes();
        boolean r = true;
        int i = 0;
        while (i < sounds.length) {
            r &= sounds[i].setVolume(volumes[i]);
            ++i;
        }
        return r;
    }
}

